/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.Util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class ExcalConvertUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcalConvertUtil.class);

    public static MultipartFile convertXlsToXlsx(MultipartFile xlsFile) {
        try {
            String originalFilename;
            ByteArrayOutputStream xlsxOutputStream = new ByteArrayOutputStream();
            ExcalConvertUtil.convertXlsToXlsxByStream(xlsFile.getInputStream(), xlsxOutputStream);
            String newFilename = originalFilename = xlsFile.getOriginalFilename();
            if (originalFilename != null && originalFilename.endsWith(".xls")) {
                newFilename = originalFilename.substring(0, originalFilename.length() - 4) + ".xlsx";
            }
            MockMultipartFile xlsxFile = new MockMultipartFile(newFilename, newFilename, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (InputStream)new ByteArrayInputStream(xlsxOutputStream.toByteArray()));
            return xlsxFile;
        }
        catch (Exception e) {
            log.error("MultipartFile\u683c\u5f0f\u8f6c\u6362(xls->xlsx)\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public static void convertXlsToXlsxByStream(InputStream xlsInputStream, OutputStream xlsxOutputStream) {
        try {
            HSSFWorkbook oldWorkbook = new HSSFWorkbook(xlsInputStream);
            XSSFWorkbook newWorkbook = new XSSFWorkbook();
            for (int i = 0; i < oldWorkbook.getNumberOfSheets(); ++i) {
                HSSFSheet oldSheet = oldWorkbook.getSheetAt(i);
                XSSFSheet newSheet = newWorkbook.createSheet(oldSheet.getSheetName());
                for (int j = 0; j <= oldSheet.getLastRowNum(); ++j) {
                    Row oldRow = oldSheet.getRow(j);
                    Row newRow = newSheet.createRow(j);
                    if (oldRow == null) continue;
                    newRow.setHeight(oldRow.getHeight());
                    for (int k = 0; k < oldRow.getLastCellNum(); ++k) {
                        Cell oldCell = oldRow.getCell(k);
                        Cell newCell = newRow.createCell(k);
                        if (oldCell == null) continue;
                        try {
                            ExcalConvertUtil.setCellValue(newCell, oldCell);
                            ExcalConvertUtil.copyCellStyle((Workbook)newWorkbook, newCell, (Workbook)oldWorkbook, oldCell);
                            continue;
                        }
                        catch (Exception ex) {
                            log.warn("\u5355\u5143\u683c\u62f7\u8d1d\u5f02\u5e38:", (Throwable)ex);
                        }
                    }
                }
                List mergedRegions = oldSheet.getMergedRegions();
                for (CellRangeAddress mergedRegion : mergedRegions) {
                    CellRangeAddress targetMergedRegion = new CellRangeAddress(mergedRegion.getFirstRow(), mergedRegion.getLastRow(), mergedRegion.getFirstColumn(), mergedRegion.getLastColumn());
                    newSheet.addMergedRegion(targetMergedRegion);
                }
                int columnCount = 0;
                if (newSheet.getRow(0) != null) {
                    columnCount = newSheet.getRow(0).getLastCellNum();
                }
                for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                    newSheet.setColumnWidth(columnIndex, oldSheet.getColumnWidth(columnIndex));
                }
            }
            newWorkbook.write(xlsxOutputStream);
            oldWorkbook.close();
            newWorkbook.close();
            xlsxOutputStream.flush();
        }
        catch (Exception e) {
            log.error("excel\u683c\u5f0f\u8f6c\u6362(xls->xlsx)\u5f02\u5e38:", (Throwable)e);
        }
    }

    private static void setCellValue(Cell newCell, Cell oldCell) {
        if (oldCell == null) {
            return;
        }
        switch (oldCell.getCellType()) {
            case STRING: {
                newCell.setCellValue(oldCell.getStringCellValue());
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)oldCell)) {
                    newCell.setCellValue(oldCell.getDateCellValue());
                    break;
                }
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                newCell.setCellFormula(oldCell.getCellFormula());
                break;
            }
            case BLANK: {
                newCell.setBlank();
                break;
            }
            default: {
                newCell.setCellType(CellType.BLANK);
            }
        }
    }

    private static void copyCellStyle(Workbook newWorkbook, Cell newCell, Workbook oldWorkbook, Cell oldCell) {
        CellStyle oldCellStyle = oldCell.getCellStyle();
        CellStyle newCellStyle = newWorkbook.createCellStyle();
        newCellStyle.setAlignment(oldCellStyle.getAlignment());
        newCellStyle.setVerticalAlignment(oldCellStyle.getVerticalAlignment());
        newCellStyle.setWrapText(oldCellStyle.getWrapText());
        newCellStyle.setBorderTop(oldCellStyle.getBorderTop());
        newCellStyle.setBorderBottom(oldCellStyle.getBorderBottom());
        newCellStyle.setBorderLeft(oldCellStyle.getBorderLeft());
        newCellStyle.setBorderRight(oldCellStyle.getBorderRight());
        Font newFont = newWorkbook.createFont();
        Font oldFont = oldWorkbook.getFontAt(oldCellStyle.getFontIndex());
        newFont.setFontName(oldFont.getFontName());
        newFont.setFontHeightInPoints(oldFont.getFontHeightInPoints());
        newFont.setBold(oldFont.getBold());
        newFont.setItalic(oldFont.getItalic());
        newFont.setUnderline(oldFont.getUnderline());
        newFont.setStrikeout(oldFont.getStrikeout());
        newCellStyle.setFont(newFont);
        newCellStyle.setFillPattern(oldCellStyle.getFillPattern());
        newCellStyle.setFillForegroundColor(oldCellStyle.getFillForegroundColor());
        newCellStyle.setFillBackgroundColor(oldCellStyle.getFillBackgroundColor());
        newCellStyle.setDataFormat(newWorkbook.createDataFormat().getFormat(oldWorkbook.getCreationHelper().createDataFormat().getFormat(oldCellStyle.getDataFormat())));
        newCellStyle.setRotation(oldCellStyle.getRotation());
        newCell.setCellStyle(newCellStyle);
    }
}

