/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.sync.union.util;

import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.application.sync.union.util.SyncUnionHelper")
public class SyncUnionHelper {
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private ISysFunctionsBoService functionsBoService;
    @Resource
    private IHussarBaseResourceService hussarBaseResourceService;
    @Resource
    private ISysFunctionResourcesBoService functionResourcesBoService;
    @Resource
    private ISysRolesExternalService rolesExternalService;

    public Long getMenuFunId(Long reportId) {
        String eleCode = "menu_" + reportId;
        SysFunctions function = this.functionsBoService.getOneByCode(eleCode);
        return HussarUtils.isNotEmpty((Object)function) ? function.getId() : null;
    }

    public List<Long> listFunIdsByForm(Long reportId) {
        List funList = this.functionsBoService.listByModuleId(reportId);
        return funList.stream().map(SysFunctions::getId).collect(Collectors.toList());
    }

    public List<Long> listResIdsByForm(Long formId) {
        List resList = this.hussarBaseResourceService.getResourcesByModuleId(formId);
        return resList.stream().map(SysResources::getId).collect(Collectors.toList());
    }
}

