/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.sync.union.util;

import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.application.reportgroup.model.SysReportGroup;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.application.sync.union.dto.ConversionProduct;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.application.sync.union.util.SyncUnionConverter")
public class SyncUnionConverter {
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private ISysFunctionsBoService functionsBoService;
    @Resource
    private ISysFunctionsBoService sysFunctionsBoService;
    @Resource
    private IHussarBaseResourceService hussarBaseResourceService;
    private static final Long SUPERADMIN_ID = 1450785135866925066L;
    private static final Long DEVELOP_ID = 690264237607755776L;

    public ConversionProduct reportGroupToModule(SysReportGroup sysReportGroup, ConversionProduct conversionProduct) {
        if (HussarUtils.isEmpty((Object)conversionProduct)) {
            conversionProduct = new ConversionProduct();
        }
        SysFunctionModules funModule = new SysFunctionModules();
        funModule.setId(sysReportGroup.getGroupId());
        funModule.setFunctionModuleName(sysReportGroup.getGroupName());
        funModule.setFunctionModuleCode(String.valueOf(sysReportGroup.getGroupId()));
        funModule.setSeq(sysReportGroup.getSeq());
        funModule.setParentModuleId(Long.valueOf(5L));
        conversionProduct.getFunctionModulesList().add(funModule);
        SysResourceModules resModule = new SysResourceModules();
        resModule.setId(sysReportGroup.getGroupId());
        resModule.setModuleName(sysReportGroup.getGroupName());
        resModule.setModuleCode(String.valueOf(sysReportGroup.getGroupId()));
        resModule.setSeq(sysReportGroup.getSeq());
        resModule.setParentModuleId(Long.valueOf(5L));
        conversionProduct.getResourceModulesList().add(resModule);
        return conversionProduct;
    }

    public void reportToModule(SysReport sysReport, ConversionProduct conversionProduct) {
        Long parentModuleId = HussarUtils.isNotEmpty((Object)sysReport.getReportGroupId()) ? sysReport.getReportGroupId() : 5L;
        SysFunctionModules funModule = new SysFunctionModules();
        funModule.setId(sysReport.getReportId());
        funModule.setFunctionModuleName(sysReport.getReportName());
        funModule.setFunctionModuleCode(String.valueOf(sysReport.getReportId()));
        funModule.setParentModuleId(parentModuleId);
        funModule.setSeq(Integer.valueOf(sysReport.getSeq()));
        conversionProduct.getFunctionModulesList().add(funModule);
        SysResourceModules resModule = new SysResourceModules();
        resModule.setId(sysReport.getReportId());
        resModule.setModuleName(sysReport.getReportName());
        resModule.setModuleCode(String.valueOf(sysReport.getReportId()));
        resModule.setParentModuleId(parentModuleId);
        resModule.setSeq(Integer.valueOf(sysReport.getSeq()));
        conversionProduct.getResourceModulesList().add(resModule);
    }

    public SysFunctionResources newFunRes(Long funId, Long resId) {
        SysFunctionResources functionResources = new SysFunctionResources();
        functionResources.setFunctionId(funId);
        functionResources.setResourceId(resId);
        return functionResources;
    }

    public SysRoleResource newRoleRes(Long roleId, Long resId) {
        SysRoleResource sysRoleResource = new SysRoleResource();
        sysRoleResource.setRoleId(roleId);
        sysRoleResource.setResourceId(resId);
        sysRoleResource.setRelationSource("1");
        return sysRoleResource;
    }

    public SysRoleFunctions newRoleFun(Long roleId, Long funId) {
        SysRoleFunctions sysRoleFunctions = new SysRoleFunctions();
        sysRoleFunctions.setRoleId(roleId);
        sysRoleFunctions.setFunctionId(funId);
        return sysRoleFunctions;
    }
}

