/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.report.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.report.dao.SysReportMapper;
import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.application.report.service.ISysReportService;
import com.jxdinfo.hussar.application.report.service.ReportSyncService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.report.service.impl.SysReportImpl")
public class SysReportServiceImpl
extends HussarServiceImpl<SysReportMapper, SysReport>
implements ISysReportService {
    @Resource
    private ReportSyncService reportSyncService;
    @Resource
    private SysReportMapper sysReportMapper;

    @HussarTransactional(rollbackFor={Exception.class})
    public Long addReport(SysReport sysReport) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)sysReport.getReportGroupId())) {
            queryWrapper.eq(SysReport::getReportGroupId, (Object)sysReport.getReportGroupId());
        } else {
            queryWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(SysReport::getReportGroupId)).or()).eq(SysReport::getReportGroupId, (Object)"");
            });
        }
        ((LambdaQueryWrapper)queryWrapper.orderByDesc(SysReport::getSeq)).last("LIMIT 1");
        SysReport maxSeqReport = (SysReport)((SysReportMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)maxSeqReport)) {
            int maxReportSeq = maxSeqReport.getSeq();
            sysReport.setSeq(maxReportSeq + 1);
        } else {
            sysReport.setSeq(1);
        }
        boolean isAdd = this.save((BaseEntity)sysReport);
        if (isAdd) {
            this.reportSyncService.syncReport("add", sysReport);
            Long generatedId = sysReport.getReportId();
            return generatedId;
        }
        return null;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean editReport(SysReport sysReport) {
        boolean updated = this.updateById((BaseEntity)sysReport);
        this.reportSyncService.syncReport("edit", sysReport);
        return updated;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean editReports(List<SysReport> sysReports) {
        return this.updateBatchById(sysReports);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean delReport(List<Long> reportIds) {
        boolean removed = this.removeByIds(reportIds);
        if (HussarUtils.isNotEmpty(reportIds)) {
            Long reportId = reportIds.get(0);
            SysReport sysReport = new SysReport();
            sysReport.setReportId(reportId);
            this.reportSyncService.syncReport("del", sysReport);
        }
        return removed;
    }

    public List<SysReport> getSysReportByGroupId(Long reportGroupId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)reportGroupId)) {
            queryWrapper.eq(SysReport::getReportGroupId, (Object)reportGroupId);
        } else {
            queryWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(SysReport::getReportGroupId)).or()).eq(SysReport::getReportGroupId, (Object)"");
            });
        }
        queryWrapper.orderByAsc(SysReport::getSeq);
        List sysReports = ((SysReportMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return sysReports;
    }

    public List<SysReport> getSysReportVoByGroupId(Long reportGroupId) {
        return this.sysReportMapper.selectReportsByGroupId(reportGroupId);
    }

    public SysReport getSysReportById(Long reportId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysReport::getReportId, (Object)reportId);
        SysReport sysReport = (SysReport)((SysReportMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        return sysReport;
    }

    public List<SysReport> getSysReportByName(String reportName) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(SysReport::getReportName, (Object)reportName);
        List sysReports = ((SysReportMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return sysReports;
    }

    public List<SysReport> getAllSysReport() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List sysReports = ((SysReportMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return sysReports;
    }

    public Boolean addMenu(Long reportId) {
        SysReport sysReport = this.getSysReportById(reportId);
        this.reportSyncService.addMenu(this.getSysReportById(reportId));
        sysReport.setIsMenu("1");
        this.editReport(sysReport);
        return true;
    }

    public Boolean delMenu(Long reportId) {
        SysReport sysReport = this.getSysReportById(reportId);
        this.reportSyncService.delMenu(reportId);
        sysReport.setIsMenu("0");
        this.editReport(sysReport);
        return true;
    }

    public Boolean isMenu(Long reportId) {
        SysReport sysReport;
        if (HussarUtils.isNotEmpty((Object)reportId) && HussarUtils.isNotEmpty((Object)(sysReport = (SysReport)this.sysReportMapper.selectById(reportId))) && HussarUtils.equals((Object)"1", (Object)sysReport.getIsMenu())) {
            return true;
        }
        return false;
    }
}

