/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.report.controller;

import com.jxdinfo.hussar.application.report.service.ISysReportExpImpService;
import com.jxdinfo.hussar.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController(value="com.jxdinfo.hussar.application.report.controller.SysReportExpImpController")
@RequestMapping(value={"/hussarReport/report"})
public class SysReportExpImpController {
    @Resource
    private ISysReportExpImpService sysReportExpImpService;

    @GetMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa", notes="\u5bfc\u51fa")
    public ApiResponse<Map<String, String>> exportReports(@RequestParam List<Long> reportId) {
        String exportCacheKey = "export_progress_" + UUID.randomUUID();
        TransmittableThreadLocalHolder.set((String)"exportCacheKey", (Object)exportCacheKey);
        this.sysReportExpImpService.export(reportId);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("exportCacheKey", exportCacheKey);
        return ApiResponse.success(result);
    }

    @GetMapping(value={"/export_progress"})
    public ApiResponse<ExportStatusVo> getExportProgress(@RequestParam String exportCacheKey) {
        return this.sysReportExpImpService.getExportProgress(exportCacheKey);
    }

    @PostMapping(value={"/import"})
    @ApiOperation(value="\u5bfc\u5165", notes="\u5bfc\u5165")
    public ApiResponse<Map<String, String>> importReports(@RequestParam List<MultipartFile> files) {
        TransmittableThreadLocalHolder.set((String)"loginUserDetails", (Object)HussarSecurityUtils.getLoginUserDetails());
        String importCacheKey = "import_progress_" + UUID.randomUUID();
        TransmittableThreadLocalHolder.set((String)"importCacheKey", (Object)importCacheKey);
        this.sysReportExpImpService.importReport(files);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("importCacheKey", importCacheKey);
        return ApiResponse.success(result);
    }

    @GetMapping(value={"/import_progress"})
    @ApiOperation(value="\u83b7\u53d6\u5bfc\u5165\u8868\u5355\u8fdb\u5ea6", notes="\u83b7\u53d6\u5bfc\u5165\u8868\u5355\u8fdb\u5ea6")
    public ApiResponse<ImportStatusVo> getImportProgress(@RequestParam String importCacheKey) {
        return this.sysReportExpImpService.getImportProgress(importCacheKey);
    }
}

