/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.excel.controller;

import com.jxdinfo.hussar.application.excel.Vo.IWorkbookData;
import com.jxdinfo.hussar.application.excel.service.IExcelExporterService;
import com.jxdinfo.hussar.application.excel.service.IExcelImportService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import io.swagger.annotations.Api;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5bfc\u5165"})
@RestController(value="com.jxdinfo.hussar.application.excel.controller.ExcelImportController")
@RequestMapping(value={"/hussarReport/excel"})
public class ExcelImportController {
    @Resource(name="com.jxdinfo.hussar.application.excel.service.impl.ExcelImportImpl")
    private IExcelImportService excelImport;
    @Resource
    private IExcelExporterService excelExporter;
    @Resource
    private AttachmentManagerService attachmentManagerService;

    @PostMapping(value={"/reportImport"})
    public ApiResponse<Long> ImportReport(@RequestParam(value="file") MultipartFile file) {
        return ApiResponse.success((Object)this.excelImport.importReport(file));
    }

    @PostMapping(value={"/excelImport"})
    public ApiResponse<IWorkbookData> handleExcelImport(@RequestParam(value="file") MultipartFile file) {
        return ApiResponse.success((Object)this.excelImport.handleExcelImport(file));
    }

    @PostMapping(value={"/reportExport"})
    public ApiResponse<Long> ExportReport(@RequestParam(value="reportId") Long reportId) {
        return ApiResponse.success((Object)this.excelExporter.exportExcel(reportId));
    }

    @GetMapping(value={"/export_excel_download/{fileId}"})
    public void downloadExportData(@PathVariable Long fileId, HttpServletResponse response) {
        this.attachmentManagerService.fileDownload(response, fileId);
    }
}

