/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.quote.relation.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.quote.relation.dao.SysQuoteRelationMapper;
import com.jxdinfo.hussar.quote.relation.dto.CopyQuoteDto;
import com.jxdinfo.hussar.quote.relation.model.SysQuoteRelation;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysQuoteRelationServiceImpl
extends HussarServiceImpl<SysQuoteRelationMapper, SysQuoteRelation>
implements SysQuoteRelationService {
    @Resource
    private SysQuoteRelationMapper sysQuoteRelationMapper;
    private static Logger log = LoggerFactory.getLogger(SysQuoteRelationServiceImpl.class);

    @HussarTransactional
    public ApiResponse<SysQuoteRelation> deleteAndAddQuote(String resId, List<SysQuoteRelation> sysQuoteRelations) {
        try {
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SysQuoteRelation::getReferResId, (Object)resId);
            int i = this.sysQuoteRelationMapper.delete((Wrapper)queryWrapper);
            this.saveBatch(sysQuoteRelations);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5931\u8d25");
            return ApiResponse.fail((int)500, (String)"\u65b0\u589e\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f");
    }

    public ApiResponse<List<SysQuoteRelation>> getQuoteRelation(String resId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysQuoteRelation::getResId, (Object)resId);
        List sysQuoteRelations = this.sysQuoteRelationMapper.selectList((Wrapper)queryWrapper);
        return ApiResponse.success((Object)sysQuoteRelations, (String)"");
    }

    public ApiResponse<List<SysQuoteRelation>> getQuoteRelationByReferResid(String referResId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysQuoteRelation::getReferResId, (Object)referResId);
        List sysQuoteRelations = this.sysQuoteRelationMapper.selectList((Wrapper)queryWrapper);
        return ApiResponse.success((Object)sysQuoteRelations, (String)"");
    }

    public ApiResponse<String> deleteQuoteRelationByReferResid(String referResId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysQuoteRelation::getReferResId, (Object)referResId);
        int result = this.sysQuoteRelationMapper.delete((Wrapper)queryWrapper);
        if (result > 0) {
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        log.info("\u672a\u627ereferResId\u4e3a" + referResId + "\u7684\u5f15\u7528\u5173\u7cfb");
        return ApiResponse.success((int)ResultCode.SUCCESS.getCode(), (Object)("\u672a\u627e\u5230referResId\u4e3a" + referResId + "\u7684\u8d44\u6e90"), (String)("\u672a\u627e\u5230referResId\u4e3a" + referResId + "\u7684\u8d44\u6e90"));
    }

    public ApiResponse<Map<String, List<SysQuoteRelation>>> getQuoteList(List<String> resIdList) {
        HashMap<String, List> map = new HashMap<String, List>();
        for (String resid : resIdList) {
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SysQuoteRelation::getResId, (Object)resid);
            List sysQuoteRelations = this.sysQuoteRelationMapper.selectList((Wrapper)queryWrapper);
            map.put(resid, sysQuoteRelations);
        }
        return ApiResponse.success(map, (String)"");
    }

    public ApiResponse<List<SysQuoteRelation>> getAllQuoteList() {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        List sysQuoteRelations = this.sysQuoteRelationMapper.selectList((Wrapper)queryWrapper);
        return ApiResponse.success((Object)sysQuoteRelations, (String)"");
    }

    @HussarTransactional
    public ApiResponse<String> copyQuoteRelation(String oldReferResId, String newReferResId) {
        CopyQuoteDto copyQuoteDto = new CopyQuoteDto();
        copyQuoteDto.setOldReferResId(oldReferResId);
        copyQuoteDto.setNewReferResId(newReferResId);
        return this.copyQuoteRelation(copyQuoteDto);
    }

    @HussarTransactional
    public ApiResponse<String> copyQuoteRelation(CopyQuoteDto copyQuoteDto) {
        String oldReferResId = copyQuoteDto.getOldReferResId();
        String newReferResId = copyQuoteDto.getNewReferResId();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysQuoteRelation::getReferResId, (Object)oldReferResId);
        List sysQuoteRelations = this.sysQuoteRelationMapper.selectList((Wrapper)queryWrapper);
        if (sysQuoteRelations.size() == 0) {
            log.info("\u672a\u627ereferResId\u4e3a" + oldReferResId + "\u7684\u5f15\u7528\u5173\u7cfb");
            return ApiResponse.success((int)ResultCode.SUCCESS.getCode(), (Object)"\u672a\u627e\u5230\u8be5\u8d44\u6e90\u5f15\u7528\u5173\u7cfb", (String)"\u672a\u627e\u5230\u8be5\u8d44\u6e90\u5f15\u7528\u5173\u7cfb");
        }
        for (SysQuoteRelation sysQuoteRelation : sysQuoteRelations) {
            sysQuoteRelation.setId(null);
            sysQuoteRelation.setReferResId(newReferResId);
        }
        this.saveBatch(sysQuoteRelations);
        return ApiResponse.success((String)"\u590d\u5236\u6210\u529f");
    }

    public ApiResponse<List<String>> getQuoteIdList(String referResId, String useType) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.eq(SysQuoteRelation::getReferResId, (Object)referResId)).eq(SysQuoteRelation::getUseType, (Object)useType);
        List sysQuoteRelations = this.sysQuoteRelationMapper.selectList((Wrapper)queryWrapper);
        ArrayList<String> idList = new ArrayList<String>();
        for (SysQuoteRelation sysQuoteRelation : sysQuoteRelations) {
            idList.add(sysQuoteRelation.getResId());
        }
        return ApiResponse.success(idList, (String)"");
    }
}

