/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.schedule.job;

import com.jxdinfo.hussar.authorization.permit.JobProperties;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.service.UsersService;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.enums.HussarBaseModuleEnums;
import com.jxdinfo.hussar.common.enums.HussarBaseUserEnums;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.schedule.util.AccountStatusChangeMailUtil;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
public class AccountJob
implements BasicProcessor {
    private static Logger logger = LoggerFactory.getLogger(AccountJob.class);
    private static final Long[] ADMINS = new Long[]{1450756958461300737L, 1450757481235202050L, 1450757527330615298L, 1450757604556025858L, 1450757642371981314L, 679338378499727360L};
    @Autowired
    private ISysUsersService iSysUsersService;
    @Autowired
    private JobProperties jobProperties;
    @Autowired
    private UsersService usersService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantService sysTenantService;

    public ProcessResult process(TaskContext context) throws Exception {
        String tenantCode = context.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode) || "0".equals(tenantCode)) {
            this.quartzJob();
        }
        return new ProcessResult(true, "success");
    }

    private void quartzJob() {
        boolean tenantOpen = TenantCacheUtil.openTenant();
        HashSet<String> connNameList = new HashSet<String>();
        Map normalTenants = new HashMap<String, DefaultTenant>();
        if (tenantOpen) {
            Set tenantConnNameList = this.sysTenantService.getConnNameList();
            if (HussarUtils.isNotEmpty((Object)tenantConnNameList)) {
                connNameList.addAll(tenantConnNameList);
            }
            normalTenants = this.sysTenantService.getNormalTenants();
        } else {
            connNameList.add("master");
            normalTenants.put("master", new DefaultTenant());
        }
        for (String connName : connNameList) {
            boolean cancel;
            HussarTenantDefinition hussarTenantDefinition = (HussarTenantDefinition)normalTenants.get(connName);
            if (hussarTenantDefinition == null) {
                throw new BaseException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u6e90\u540d\u79f0\u4e3a" + connName + "\u7684\u79df\u6237");
            }
            HussarContextHolder.setTenant((HussarTenantDefinition)hussarTenantDefinition);
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName(HussarBaseModuleEnums.USER_MGT.getDesc());
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.UPDATE);
            UserDetails userDetails = new UserDetails();
            userDetails.setUserName(HussarBaseUserEnums.SCHEDULE_MANAGER.getUserName());
            AccountJob.handleTenantInfo(hussarTenantDefinition.getTenantCode(), connName, userDetails);
            auditLogModel.setUserDetails(userDetails);
            try {
                List<SysUsers> expireList = this.usersService.getExpireTemporaty(connName, Java8DateUtils.currentLocalDateTime());
                expireList.removeIf(sysUsers -> ArrayUtils.contains((Object[])ADMINS, (Object)sysUsers.getId()));
                if (HussarUtils.isNotEmpty(expireList)) {
                    String eventDesc = null;
                    ArrayList usersList = new ArrayList();
                    for (SysUsers user : expireList) {
                        LocalDateTime validUntil = user.getExpiredTime();
                        LocalDateTime currentTime = Java8DateUtils.currentLocalDateTime();
                        if (validUntil == null) {
                            logger.warn("\u8d26\u53f7ID:{} \u672a\u8bbe\u7f6e\u6709\u6548\u671f\uff0c\u8df3\u8fc7\u5904\u7406", (Object)user.getId());
                            continue;
                        }
                        user.setAccountStatus(UserStatus.CANCEL.getCode());
                        user.setLockTime(currentTime);
                        usersList.add(user);
                        String username = user.getUserName();
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
                        String expiredTimeStr = validUntil.format(formatter);
                        eventDesc = String.format("\u7528\u6237'%s'\u6709\u6548\u671f\u4e3a%s\uff0c\u7cfb\u7edf\u4efb\u52a1\u68c0\u6d4b\u5230\u6709\u6548\u671f\u5df2\u8fc7\uff0c\u81ea\u52a8\u5c06\u5176\u72b6\u6001\u66f4\u65b0\u4e3a'\u5df2\u8fc7\u671f'", username, expiredTimeStr);
                        UserDetails userDetails1 = new UserDetails();
                        String jobUser = this.jobProperties.getUser();
                        Long jobAccount = this.jobProperties.getAccount();
                        if (HussarUtils.isEmpty((Object)jobUser) || jobAccount == null || jobAccount <= 0L) {
                            logger.warn("\u4efb\u52a1\u914d\u7f6e\u4e2d user \u6216 account \u672a\u8bbe\u7f6e\uff0c\u8df3\u8fc7\u8bb0\u5f55\u5ba1\u8ba1\u65e5\u5fd7\uff08\u7528\u6237\u540d\uff1a{}\uff0c\u8d26\u53f7\uff1a{}\uff09", (Object)username, (Object)expiredTimeStr);
                            continue;
                        }
                        userDetails1.setUserName(jobUser);
                        userDetails1.setUserId(jobAccount);
                        AuditLogModel singleLog = new AuditLogModel();
                        BeanUtils.copyProperties((Object)auditLogModel, (Object)singleLog);
                        singleLog.setEventDesc(eventDesc);
                        singleLog.setUserDetails(userDetails1);
                        AuditLogUtils.addAuditLog((AuditLogModel)singleLog);
                        logger.info(eventDesc);
                    }
                    this.iSysUsersService.updateBatchById(usersList);
                }
            }
            catch (Exception e) {
                auditLogModel.setExceptionInfo((Throwable)e);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                logger.error(e.getMessage(), (Throwable)e);
            }
            String status_dormancy = UserStatus.DORMANCY.getCode();
            List notLoginList = this.iSysUsersService.updateUserStatusToDormancy(connName, status_dormancy);
            if (HussarUtils.isNotEmpty((Object)notLoginList)) {
                auditLogModel.setEventDesc("\u6279\u91cf\u4fee\u6539\u7528\u6237\u72b6\u6001\u4e3a\u4f11\u7720\uff01");
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            }
            if (CollectionUtils.isNotEmpty((Collection)notLoginList)) {
                for (SysUsers sysUsers2 : notLoginList) {
                    if (!StringUtils.isNotBlank((CharSequence)sysUsers2.geteMail())) continue;
                    AccountStatusChangeMailUtil.sendMail((String)connName, (SysUsers)sysUsers2, (String)status_dormancy);
                }
            }
            if (cancel = this.iSysUsersService.updateUserStatusToCancel(connName)) {
                auditLogModel.setEventDesc("\u6279\u91cf\u4fee\u6539\u7528\u6237\u72b6\u6001\u4e3a\u6ce8\u9500\uff01");
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            }
            String status_cancel = UserStatus.CANCEL.getCode();
            List logoutWarnList = this.iSysUsersService.getWillCancel(connName);
            if (CollectionUtils.isNotEmpty((Collection)logoutWarnList)) {
                for (SysUsers sysUsers3 : logoutWarnList) {
                    if (!StringUtils.isNotBlank((CharSequence)sysUsers3.geteMail())) continue;
                    AccountStatusChangeMailUtil.sendMail((String)connName, (SysUsers)sysUsers3, (String)status_cancel);
                }
            }
            HussarContextHolder.remove();
        }
    }

    private static void handleTenantInfo(String tcode, String connName, UserDetails userDetails) {
        HussarTenantDefinition hussarTenantDefinition;
        if (HussarUtils.isNotBlank((CharSequence)connName) && !connName.equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)tcode)))) {
            userDetails.setTenantId(hussarTenantDefinition.getTenantId());
            userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
        }
    }
}

