/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.plugin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.plugin.config.PluginConfigProperty;
import com.jxdinfo.hussar.plugin.dao.PluginMessageMapper;
import com.jxdinfo.hussar.plugin.dao.PluginVersionMapper;
import com.jxdinfo.hussar.plugin.dto.PluginMessageDto;
import com.jxdinfo.hussar.plugin.model.PluginMessage;
import com.jxdinfo.hussar.plugin.model.PluginVersion;
import com.jxdinfo.hussar.plugin.service.PluginMessageService;
import com.jxdinfo.hussar.plugin.service.PluginVersionService;
import com.jxdinfo.hussar.plugin.vo.PluginMessageVo;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.IntegrationConfiguration;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.operator.PluginOperator;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.operator.module.PluginInfo;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.pf4j.PluginDescriptor;
import org.pf4j.PropertiesPluginDescriptorFinder;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@HussarTokenDs
public class PluginMessageServiceImpl
extends HussarServiceImpl<PluginMessageMapper, PluginMessage>
implements PluginMessageService {
    @Autowired
    private PluginConfigProperty pluginConfigProperty;
    @Lazy
    @Autowired
    private PluginOperator defaultPluginOperator;
    @Resource
    private PluginVersionService pluginVersionService;
    @Resource
    private PluginMessageMapper pluginMessageMapper;
    @Resource
    private PluginVersionMapper pluginVersionMapper;
    @Autowired
    private IntegrationConfiguration integrationConfiguration;

    public ApiResponse<PluginMessageVo> addFile(MultipartFile multipartFile, String pluginName) {
        if (!this.integrationConfiguration.enable()) {
            throw new BaseException("\u63d2\u4ef6\u529f\u80fd\u672a\u5f00\u542f");
        }
        if (ToolUtil.isEmpty((Object)multipartFile)) {
            throw new HussarException("\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        File tempFile = null;
        try {
            File file = new File("");
            tempFile = new File(file.getCanonicalPath() + File.separator + multipartFile.getOriginalFilename());
            multipartFile.transferTo(tempFile);
            if (!this.checkFile(tempFile.getPath())) {
                if (!FileUtils.deleteQuietly((File)tempFile)) {
                    this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25 !");
                }
                throw new BaseException("\u4e0d\u5408\u6cd5\u7684\u63d2\u4ef6\u5305");
            }
            PluginDescriptor pluginDescriptorByJarPath = this.defaultPluginOperator.getPluginDescriptorByJarPath(tempFile.getPath());
            if (ToolUtil.isNotEmpty((Object)this.pluginMessageMapper.queryPluginByPluginId(pluginDescriptorByJarPath.getPluginId()))) {
                if (!FileUtils.deleteQuietly((File)tempFile)) {
                    this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25 !");
                }
                throw new BaseException("\u8be5\u63d2\u4ef6\u5df2\u4e0a\u4f20,\u8bf7\u4e0a\u4f20\u65b0\u7248\u672c");
            }
            List<String> pluginNameList = this.pluginMessageMapper.queryPluginName();
            for (String s : pluginNameList) {
                if (!s.equals(pluginName)) continue;
                if (!FileUtils.deleteQuietly((File)tempFile)) {
                    this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25 !");
                }
                throw new BaseException("\u63d2\u4ef6\u540d\u79f0\u5df2\u5b58\u5728");
            }
            FileInputStream input = new FileInputStream(tempFile);
            MockMultipartFile multipartFileTemp = new MockMultipartFile(multipartFile.getName(), multipartFile.getOriginalFilename(), "text/plain", IOUtils.toByteArray((InputStream)input));
            input.close();
            File uploadPath = new File(this.pluginConfigProperty.getPluginPath());
            if (!uploadPath.exists() || !uploadPath.isDirectory()) {
                uploadPath.mkdir();
            }
            PluginInfo pluginInfo = this.defaultPluginOperator.uploadPluginAndStart((MultipartFile)multipartFileTemp);
            PluginMessageVo pluginMessageVo = new PluginMessageVo();
            pluginMessageVo.setFileName(multipartFile.getOriginalFilename());
            pluginMessageVo.setPluginId(pluginInfo.getPluginDescriptor().getPluginId());
            pluginMessageVo.setCurrentVersion(pluginInfo.getPluginDescriptor().getVersion());
            pluginMessageVo.setJarPath(pluginInfo.getPath());
            Files.delete(tempFile.toPath());
            return ApiResponse.success((Object)pluginMessageVo);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            if (e.getMessage().contains(" Plugin id can't be empty")) {
                throw new BaseException("\u63d2\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (tempFile != null && !FileUtils.deleteQuietly(tempFile)) {
                this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25 !");
            }
            throw new BaseException("\u8be5\u63d2\u4ef6\u5df2\u5b58\u5728");
        }
    }

    public ApiResponse<Boolean> addNewVersion(MultipartFile multipartFile, String infoId) {
        if (ToolUtil.isEmpty((Object)multipartFile)) {
            throw new HussarException("\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        File tempFile = null;
        Long longInfoId = Long.parseLong(infoId);
        PluginMessage pluginMessage = (PluginMessage)this.getById(longInfoId);
        PluginMessageDto pluginMessageDto = new PluginMessageDto();
        CopyPropertieUtils.copyProperties((Object)pluginMessageDto, (Object)pluginMessage);
        boolean isUninstall = false;
        try {
            File file = new File("");
            tempFile = new File(file.getCanonicalPath() + File.separator + multipartFile.getOriginalFilename());
            multipartFile.transferTo(tempFile);
            if (!this.checkFile(tempFile.getPath())) {
                if (!FileUtils.deleteQuietly((File)tempFile)) {
                    this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25 !");
                }
                throw new BaseException("\u4e0d\u5408\u6cd5\u7684\u63d2\u4ef6\u5305");
            }
            PluginVersion pluginVersion = new PluginVersion();
            pluginVersion.setJarPath(this.backup(pluginMessageDto));
            pluginVersion.setVersionId(pluginMessage.getVersionId());
            pluginVersion.setVersionFlag(0);
            this.pluginVersionService.updateById((Object)pluginVersion);
            if ("enabled".equals(pluginMessage.getPluginState())) {
                try {
                    this.defaultPluginOperator.stop(pluginMessageDto.getPluginId());
                    this.defaultPluginOperator.uninstall(pluginMessageDto.getPluginId(), false);
                    isUninstall = true;
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    throw new BaseException("\u7248\u672c\u66f4\u65b0\u5931\u8d25");
                }
            }
            PluginDescriptor pluginDescriptorByJarPath = this.defaultPluginOperator.getPluginDescriptorByJarPath(tempFile.getPath());
            if (!pluginMessage.getPluginId().equals(pluginDescriptorByJarPath.getPluginId())) {
                if (!FileUtils.deleteQuietly((File)tempFile)) {
                    this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25 !");
                }
                throw new BaseException("\u8bf7\u4e0a\u4f20\u76f8\u540cid\u7684\u63d2\u4ef6");
            }
            LambdaQueryWrapper pluginQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)pluginQueryWrapper.eq(PluginVersion::getPluginVersion, (Object)pluginDescriptorByJarPath.getVersion())).eq(PluginVersion::getInfoId, (Object)longInfoId);
            PluginVersion oldPluginVersion = (PluginVersion)this.pluginVersionMapper.selectOne((Wrapper)pluginQueryWrapper);
            if (ToolUtil.isNotEmpty((Object)oldPluginVersion)) {
                throw new BaseException("\u8be5\u63d2\u4ef6\u7248\u672c\u5df2\u7ecf\u5b58\u5728");
            }
            MockMultipartFile multipartFileTemp = new MockMultipartFile(multipartFile.getName(), multipartFile.getOriginalFilename(), "text/plain", FileUtils.readFileToByteArray((File)tempFile));
            PluginInfo pluginInfo = this.defaultPluginOperator.uploadPluginAndStart((MultipartFile)multipartFileTemp);
            PluginMessageDto newPluginMessage = new PluginMessageDto();
            newPluginMessage.setInfoId(longInfoId);
            newPluginMessage.setPluginName(pluginMessage.getPluginName());
            newPluginMessage.setPluginDescriptor(pluginMessage.getPluginDescriptor());
            newPluginMessage.setFileName(multipartFile.getOriginalFilename());
            newPluginMessage.setPluginId(pluginInfo.getPluginDescriptor().getPluginId());
            newPluginMessage.setCurrentVersion(pluginInfo.getPluginDescriptor().getVersion());
            newPluginMessage.setJarPath(pluginInfo.getPath());
            newPluginMessage.setPluginState("enabled");
            if (!FileUtils.deleteQuietly((File)tempFile)) {
                this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25 !");
            }
            return this.addPluginInfo(newPluginMessage);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            if (isUninstall) {
                this.install(pluginMessageDto);
            }
            if (e.getMessage().contains(" Plugin id can't be empty")) {
                throw new BaseException("\u7248\u672c\u66f4\u65b0\u5931\u8d25\uff0c\u63d2\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (tempFile != null && !FileUtils.deleteQuietly(tempFile)) {
                this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25 !");
            }
            throw new BaseException("\u7248\u672c\u66f4\u65b0\u5931\u8d25\uff0c" + e.getMessage());
        }
    }

    @HussarTransactional
    public ApiResponse<Boolean> addPluginInfo(PluginMessageDto pluginMessageDto) {
        PluginMessage pluginMessage = new PluginMessage();
        BeanUtils.copyProperties((Object)pluginMessageDto, (Object)pluginMessage);
        if (ToolUtil.isEmpty((Object)pluginMessageDto.getPluginState())) {
            pluginMessage.setPluginState("enabled");
        }
        if (ToolUtil.isNotEmpty((Object)pluginMessageDto.getInfoId())) {
            pluginMessage.setInfoId(pluginMessageDto.getInfoId());
        }
        this.saveOrUpdate((BaseEntity)pluginMessage);
        PluginVersion pluginVersion = new PluginVersion();
        pluginVersion.setPluginVersion(pluginMessageDto.getCurrentVersion());
        pluginVersion.setInfoId(pluginMessage.getInfoId());
        pluginVersion.setFileName(pluginMessageDto.getFileName());
        pluginVersion.setJarPath(pluginMessageDto.getJarPath());
        pluginVersion.setVersionFlag(1);
        this.pluginVersionService.saveOrUpdate((Object)pluginVersion);
        pluginMessage.setVersionId(pluginVersion.getVersionId());
        this.saveOrUpdate((BaseEntity)pluginMessage);
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> uploadPluginInfo(PluginMessageDto pluginMessageDto) {
        List<String> pluginNameList = this.pluginMessageMapper.queryPluginName();
        PluginMessage byId = (PluginMessage)this.getById(pluginMessageDto.getInfoId());
        for (String s : pluginNameList) {
            if (!s.equals(pluginMessageDto.getPluginName()) || s.equals(byId.getPluginName())) continue;
            throw new BaseException("\u63d2\u4ef6\u540d\u79f0\u5df2\u5b58\u5728");
        }
        PluginMessage pluginMessage = new PluginMessage();
        BeanUtils.copyProperties((Object)pluginMessageDto, (Object)pluginMessage);
        return ApiResponse.success((Object)this.saveOrUpdate((BaseEntity)pluginMessage));
    }

    public ApiResponse<Boolean> deletePluginInfo(PluginMessageDto pluginMessageDto) {
        this.removeById(pluginMessageDto.getInfoId());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PluginVersion::getInfoId, (Object)pluginMessageDto.getInfoId());
        this.pluginVersionService.remove((Wrapper)queryWrapper);
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> install(PluginMessageDto pluginMessageDto) {
        try {
            PluginVersion pluginVersion = (PluginVersion)this.pluginVersionService.getById((Serializable)pluginMessageDto.getVersionId());
            Path path = Paths.get(pluginVersion.getJarPath(), new String[0]);
            pluginVersion.setVersionFlag(1);
            this.pluginVersionService.updateById((Object)pluginVersion);
            this.defaultPluginOperator.install(path);
            PluginMessage pluginMessage = new PluginMessage();
            pluginMessage.setInfoId(pluginMessageDto.getInfoId());
            pluginMessage.setPluginState("enabled");
            this.updateById((BaseEntity)pluginMessage);
            return ApiResponse.success((Object)true);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new BaseException("\u5b89\u88c5\u5931\u8d25");
        }
    }

    public ApiResponse<Boolean> uninstall(PluginMessageDto pluginMessageDto) {
        try {
            this.defaultPluginOperator.stop(pluginMessageDto.getPluginId());
            PluginVersion pluginVersion = new PluginVersion();
            pluginVersion.setJarPath(this.backup(pluginMessageDto));
            pluginVersion.setVersionId(((PluginMessage)this.getById(pluginMessageDto.getInfoId())).getVersionId());
            pluginVersion.setVersionFlag(pluginMessageDto.getVersionFlag());
            this.pluginVersionService.updateById((Object)pluginVersion);
            this.defaultPluginOperator.uninstall(pluginMessageDto.getPluginId(), false);
            PluginMessage pluginMessage = new PluginMessage();
            BeanUtils.copyProperties((Object)pluginMessageDto, (Object)pluginMessage);
            pluginMessage.setPluginState("uninstall");
            this.pluginMessageMapper.updateById(pluginMessage);
            return ApiResponse.success((Object)true);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new BaseException("\u5378\u8f7d\u5931\u8d25");
        }
    }

    public void download(HttpServletResponse httpServletResponse, PluginMessageDto pluginMessageDto) {
        if (ToolUtil.isEmpty((Object)httpServletResponse) || ToolUtil.isEmpty((Object)pluginMessageDto.getInfoId()) || ToolUtil.isEmpty((Object)pluginMessageDto.getVersionId())) {
            throw new HussarException("\u4e0b\u8f7d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PluginVersion pluginVersion = (PluginVersion)this.pluginVersionService.getById((Serializable)pluginMessageDto.getVersionId());
        String fileName = pluginVersion.getFileName();
        String path = pluginVersion.getJarPath();
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(path)), 10240);
             BufferedOutputStream out = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream());){
            fileName = URLEncoder.encode(fileName, "UTF-8");
            httpServletResponse.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            httpServletResponse.setContentType("multipart/form-data");
            IOUtils.copy((InputStream)bis, (OutputStream)out);
        }
        catch (FileNotFoundException e) {
            throw new HussarException(BizExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        catch (IOException e) {
            throw new HussarException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
    }

    public ApiResponse<Boolean> rollBack(PluginMessageDto pluginMessageDto) {
        try {
            PluginMessage oldPluginMessage = (PluginMessage)this.getById(pluginMessageDto.getInfoId());
            Long oldVersionId = oldPluginMessage.getVersionId();
            PluginVersion oldPlugin = new PluginVersion();
            oldPlugin.setVersionFlag(0);
            oldPlugin.setVersionId(oldVersionId);
            this.pluginVersionMapper.updateById(oldPlugin);
            PluginVersion newPlugin = (PluginVersion)this.pluginVersionService.getById((Serializable)pluginMessageDto.getVersionId());
            newPlugin.setVersionFlag(1);
            this.pluginVersionMapper.updateById(newPlugin);
            File newFile = new File(newPlugin.getJarPath());
            PluginMessage pluginMessage = new PluginMessage();
            pluginMessage.setInfoId(pluginMessageDto.getInfoId());
            pluginMessage.setVersionId(pluginMessageDto.getVersionId());
            pluginMessage.setCurrentVersion(newPlugin.getPluginVersion());
            pluginMessage.setPluginState("enabled");
            this.updateById((BaseEntity)pluginMessage);
            MockMultipartFile multipartFile = new MockMultipartFile(newFile.getName(), newFile.getName(), "application/form-data", FileUtils.readFileToByteArray((File)newFile));
            this.defaultPluginOperator.uploadPluginAndStart((MultipartFile)multipartFile);
            return ApiResponse.success((Object)true);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new BaseException("\u56de\u6eda\u5931\u8d25");
        }
    }

    public Page<PluginMessageVo> queryList(Page<PluginMessageVo> page, PluginMessageDto pluginMessageDto) {
        if (ToolUtil.isEmpty(page)) {
            throw new HussarException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u67e5\u8be2");
        }
        return this.pluginMessageMapper.queryPluginByName(page, pluginMessageDto);
    }

    public Page<PluginVersion> queryVersionList(Page<PluginMessageVo> page, PluginMessageDto pluginMessageDto) {
        return this.pluginVersionMapper.queryVersionList(page, pluginMessageDto.getInfoId());
    }

    protected String backup(PluginMessageDto pluginMessageDto) {
        PluginMessage pluginMessage = (PluginMessage)this.getById(pluginMessageDto.getInfoId());
        PluginVersion pluginVersion = (PluginVersion)this.pluginVersionService.getById((Serializable)pluginMessage.getVersionId());
        String targetName = null;
        try {
            File file = new File(pluginVersion.getJarPath());
            File directory = new File("");
            String courseFile = directory.getCanonicalPath();
            targetName = courseFile + File.separator + this.pluginConfigProperty.getBackUpPath() + File.separator + pluginVersion.getFileName();
            File newFile = new File(targetName);
            FileUtils.copyFile((File)file, (File)newFile, (boolean)true);
            return targetName;
        }
        catch (Exception se) {
            return targetName;
        }
    }

    private boolean checkFile(String pathStr) {
        try {
            Path path = Paths.get(pathStr, new String[0]);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader.loadClass("org.pf4j.PropertiesPluginDescriptorFinder");
            PropertiesPluginDescriptorFinder finder = (PropertiesPluginDescriptorFinder)clazz.newInstance();
            Method method = clazz.getDeclaredMethod("readProperties", Path.class);
            method.setAccessible(true);
            method.invoke((Object)finder, path);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

