/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pinyin.util;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.pinyin.annotation.PinyinSearchColumn;
import com.jxdinfo.hussar.pinyin.util.DsTypesManagerUtil;
import com.jxdinfo.hussar.pinyin.util.MybatisUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MysqlDbTypeUtil
implements DsTypesManagerUtil {
    public static String BIGINT = "BIGINT";
    public static String INT = "INT";
    public static String MEDIUMINT = "MEDIUMINT";
    public static String SMALLINT = "SMALLINT";
    public static String TINYINT = "TINYINT";
    public static String DECIMAL = "DECIMAL";
    public static String FLOAT = "FLOAT";
    public static String DOUBLE = "DOUBLE";
    public static String VARBINARY = "VARBINARY";
    public static String DATE = "DATE";
    public static String TIME = "TIME";
    public static String DATETIME = "DATETIME";
    public static String TIMESTAMP = "TIMESTAMP";
    public static String CHAR = "CHAR";
    public static String VARCHAR = "VARCHAR";
    public static String TINYTEXT = "TINYTEXT";
    public static String TEXT = "TEXT";
    public static String MEDIUMTEXT = "MEDIUMTEXT";
    public static String LONGTEXT = "LONGTEXT";
    public static String TINYBLOB = "TINYBLOB";
    public static String BLOB = "BLOB";
    public static String MEDIUMBLOB = "MEDIUMBLOB";
    public static String LONGBLOB = "LONGBLOB";
    public static String NOTNULL = "NOT NULL";
    public static String NULL = "NULL";

    @Override
    public String getCreateTableSql(ResultSetMetaData orignSelectRs, ResultSetMetaData searchColumnsRs) {
        StringBuffer sbuf = new StringBuffer();
        String pkName = "";
        try {
            int columnCount = orignSelectRs.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = orignSelectRs.getColumnName(i);
                if (HussarUtils.isNotEmpty((Object)columnName)) {
                    sbuf.append(columnName).append(" ");
                }
                String columnTypeName = orignSelectRs.getColumnTypeName(i);
                String colDescribe = this.getColumnTypeDescribe(orignSelectRs, i);
                if (HussarUtils.isNotEmpty((Object)columnTypeName)) {
                    sbuf.append(columnTypeName.toLowerCase());
                    if (HussarUtils.isNotEmpty((Object)colDescribe)) {
                        sbuf.append(colDescribe);
                    }
                    sbuf.append(" ");
                }
                if (0 == orignSelectRs.isNullable(i)) {
                    sbuf.append(NOTNULL).append(" ").append(", ");
                } else if (1 == orignSelectRs.isNullable(i)) {
                    sbuf.append(NULL).append(" ").append(", ");
                }
                if (i != 1) continue;
                pkName = columnName;
            }
            sbuf.append(this.getCreateTableSearchColumnsSql(searchColumnsRs));
            if (HussarUtils.isNotEmpty((Object)pkName)) {
                sbuf.append("PRIMARY KEY (").append(pkName).append(") USING BTREE");
            }
            sbuf.append(") ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic").append(";");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return sbuf.toString();
    }

    public String getCreateTableSearchColumnsSql(ResultSetMetaData metaData) {
        StringBuffer sbufFull = new StringBuffer();
        StringBuffer sbufInitial = new StringBuffer();
        ArrayList sbufFullList = Lists.newArrayListWithCapacity((int)4);
        try {
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = metaData.getColumnName(i);
                if (HussarUtils.isNotEmpty((Object)columnName)) {
                    sbufFull.append(columnName.concat(MybatisUtil.SEARCHCOLUMNFULLSUFFIX)).append(" ");
                    sbufInitial.append(columnName.concat(MybatisUtil.SEARCHCOLUMNINITIALSUFFIX)).append(" ");
                }
                String columnTypeName = metaData.getColumnTypeName(i);
                String colDescribe = this.getSearchColumnTypeDescribe(metaData, i);
                if (HussarUtils.isNotEmpty((Object)columnTypeName)) {
                    sbufFull.append(columnTypeName.toLowerCase());
                    sbufInitial.append(columnTypeName.toLowerCase());
                    if (HussarUtils.isNotEmpty((Object)colDescribe)) {
                        sbufFull.append(colDescribe);
                        sbufInitial.append(colDescribe);
                    }
                    sbufFull.append(" ");
                    sbufInitial.append(" ");
                }
                if (0 == metaData.isNullable(i)) {
                    sbufFull.append(NOTNULL).append(" ");
                    sbufInitial.append(NOTNULL).append(" ");
                } else if (1 == metaData.isNullable(i)) {
                    sbufFull.append(NULL).append(" ");
                    sbufInitial.append(NULL).append(" ");
                }
                sbufFullList.add(sbufFull.toString());
                sbufFullList.add(sbufInitial.toString());
                sbufFull.delete(0, sbufFull.length());
                sbufInitial.delete(0, sbufInitial.length());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return String.join((CharSequence)",", sbufFullList).concat(",");
    }

    @Override
    public List<List<Object>> getDataValues(ResultSet orign, ResultSet search, String[] clomuns, String[] searchColumns, String tableName) {
        ArrayList<List<Object>> orignResult = new ArrayList<List<Object>>();
        ArrayList<Object> orignValues = null;
        try {
            ResultSetMetaData meta = orign.getMetaData();
            int columnNum = meta.getColumnCount();
            while (orign.next()) {
                orignValues = new ArrayList<Object>();
                for (int i = 1; i <= columnNum; ++i) {
                    if (this.checkIntType(meta.getColumnTypeName(i)).booleanValue()) {
                        Integer columnInt = orign.getInt(clomuns[i - 1]);
                        orignValues.add(i - 1, columnInt);
                        continue;
                    }
                    if (this.checkBigIntType(meta.getColumnTypeName(i)).booleanValue()) {
                        Long columnLong = orign.getLong(clomuns[i - 1]);
                        orignValues.add(i - 1, columnLong);
                        continue;
                    }
                    if (this.checkJavaStringType(meta.getColumnTypeName(i)).booleanValue()) {
                        String columnString = orign.getString(clomuns[i - 1]);
                        orignValues.add(i - 1, columnString);
                        continue;
                    }
                    if (this.checkFloatType(meta.getColumnTypeName(i)).booleanValue()) {
                        Float columnFloat = Float.valueOf(orign.getFloat(clomuns[i - 1]));
                        orignValues.add(i - 1, columnFloat);
                        continue;
                    }
                    if (this.checkDoubleType(meta.getColumnTypeName(i)).booleanValue()) {
                        Double columnDouble = orign.getDouble(clomuns[i - 1]);
                        orignValues.add(i - 1, columnDouble);
                        continue;
                    }
                    if (this.checkDecimalType(meta.getColumnTypeName(i)).booleanValue()) {
                        BigDecimal columnBigDecimal = orign.getBigDecimal(clomuns[i - 1]);
                        orignValues.add(i - 1, columnBigDecimal);
                        continue;
                    }
                    if (this.checkJavaBytesType(meta.getColumnTypeName(i)).booleanValue()) {
                        byte[] columnBytes = orign.getBytes(clomuns[i - 1]);
                        orignValues.add(i - 1, columnBytes);
                        continue;
                    }
                    if (this.checkDateType(meta.getColumnTypeName(i)).booleanValue()) {
                        LocalDate localDate = orign.getDate(clomuns[i - 1]).toLocalDate();
                        orignValues.add(i - 1, localDate);
                        continue;
                    }
                    if (this.checkTimeType(meta.getColumnTypeName(i)).booleanValue()) {
                        LocalTime localTime = orign.getTime(clomuns[i - 1]).toLocalTime();
                        orignValues.add(i - 1, localTime);
                        continue;
                    }
                    if (!this.checkDateTimeType(meta.getColumnTypeName(i)).booleanValue() && !this.checkTimestampType(meta.getColumnTypeName(i)).booleanValue()) continue;
                    LocalDateTime localDateTime = orign.getTimestamp(clomuns[i - 1]).toLocalDateTime();
                    orignValues.add(i - 1, localDateTime);
                }
                orignResult.add(orignValues);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return orignResult;
    }

    @Override
    public Map<String, String> searchColumnAnnationInfos(String tableName, String[] searchColumns) {
        HashMap<String, String> map = new HashMap<String, String>();
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
        List tableFields = tableInfo.getFieldList();
        int num = searchColumns.length;
        for (String columnName : searchColumns) {
            Field tableField = ((TableFieldInfo)tableFields.stream().filter(tableFieldInfo -> columnName.equals(tableFieldInfo.getColumn())).collect(Collectors.toList()).get(0)).getField();
            if (Arrays.stream(tableField.getDeclaredAnnotations()).filter(s -> "com.jxdinfo.hussar.pinyin.annotation.PinyinSearchColumn".equals(s.annotationType().getName())).collect(Collectors.toList()).size() <= 0) continue;
            PinyinSearchColumn psc = tableField.getAnnotation(PinyinSearchColumn.class);
            map.put(columnName, psc.type());
        }
        return map;
    }

    public String getColumnTypeDescribe(ResultSetMetaData metaData, int i) {
        String colDescribe = "";
        try {
            int columnDisplaySize;
            String columnTypeName = metaData.getColumnTypeName(i);
            if (this.checkCharType(columnTypeName).booleanValue()) {
                columnDisplaySize = metaData.getColumnDisplaySize(i);
                colDescribe = "(" + columnDisplaySize + ") CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci";
            }
            if (this.checkVarbinaryType(columnTypeName).booleanValue()) {
                columnDisplaySize = metaData.getColumnDisplaySize(i);
                colDescribe = "(" + columnDisplaySize + ")";
            }
            if (this.checkTextType(columnTypeName).booleanValue()) {
                colDescribe = " CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci";
            }
            if (this.checkIntType(columnTypeName).booleanValue() || this.checkBigIntType(columnTypeName).booleanValue()) {
                int getScale = metaData.getScale(i);
                colDescribe = "(" + getScale + ")";
            }
            if (this.checkDecimalType(columnTypeName).booleanValue() || this.checkFloatType(columnTypeName).booleanValue() || this.checkDoubleType(columnTypeName).booleanValue()) {
                int getPrecision = metaData.getPrecision(i);
                int getScale = metaData.getScale(i);
                colDescribe = "(" + getPrecision + "," + getScale + ")";
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return colDescribe;
    }

    public String getSearchColumnTypeDescribe(ResultSetMetaData metaData, int i) {
        String colDescribe = "";
        try {
            int columnDisplaySize;
            String columnTypeName = metaData.getColumnTypeName(i);
            if (this.checkCharType(columnTypeName).booleanValue()) {
                columnDisplaySize = metaData.getColumnDisplaySize(i);
                colDescribe = "(" + (columnDisplaySize *= 6) + ") CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci";
            }
            if (this.checkVarbinaryType(columnTypeName).booleanValue()) {
                columnDisplaySize = metaData.getColumnDisplaySize(i);
                colDescribe = "(" + (columnDisplaySize *= 6) + ")";
            }
            if (this.checkTextType(columnTypeName).booleanValue()) {
                colDescribe = " CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci";
            }
            if (this.checkIntType(columnTypeName).booleanValue() || this.checkBigIntType(columnTypeName).booleanValue()) {
                int getScale = metaData.getScale(i);
                colDescribe = "(" + getScale + ")";
            }
            if (this.checkDecimalType(columnTypeName).booleanValue() || this.checkFloatType(columnTypeName).booleanValue() || this.checkDoubleType(columnTypeName).booleanValue()) {
                int getPrecision = metaData.getPrecision(i);
                int getScale = metaData.getScale(i);
                colDescribe = "(" + getPrecision + "," + getScale + ")";
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return colDescribe;
    }

    public Boolean checkCharType(String columnTypeName) {
        boolean result = false;
        if (columnTypeName.equals(VARCHAR) || columnTypeName.equals(CHAR)) {
            result = true;
        }
        return result;
    }

    public Boolean checkIntType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(INT) || columnTypeName.equals(MEDIUMINT) || columnTypeName.equals(SMALLINT) || columnTypeName.equals(TINYINT)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkBigIntType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(BIGINT)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkDecimalType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(DECIMAL)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkVarbinaryType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(VARBINARY)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkFloatType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(FLOAT)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkDoubleType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(DOUBLE)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkDateType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(DATE)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkTimeType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(TIME)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkDateTimeType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(DATETIME)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkTimestampType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(TIMESTAMP)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkJavaStringType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(CHAR) || columnTypeName.equals(VARCHAR) || columnTypeName.equals(TINYTEXT) || columnTypeName.equals(TEXT) || columnTypeName.equals(MEDIUMTEXT) || columnTypeName.equals(LONGTEXT)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkTextType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(TINYTEXT) || columnTypeName.equals(TEXT) || columnTypeName.equals(MEDIUMTEXT) || columnTypeName.equals(LONGTEXT)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkJavaBytesType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(VARBINARY) || columnTypeName.equals(TINYBLOB) || columnTypeName.equals(BLOB) || columnTypeName.equals(MEDIUMBLOB) || columnTypeName.equals(LONGBLOB)) {
            flag = true;
        }
        return flag;
    }
}

