/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pinyin.service.impl;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.pinyin.annotation.PinyinSearchColumn;
import com.jxdinfo.hussar.pinyin.annotation.PinyinSearchEntity;
import com.jxdinfo.hussar.pinyin.annotation.PinyinViewColumn;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.pinyin.service.IDataSyncService;
import com.jxdinfo.hussar.pinyin.util.MybatisUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.pinyin.service.impl.DataSyncServiceImpl")
public class DataSyncServiceImpl
implements IDataSyncService {
    @Autowired
    private IConvertPinyinService convertPinyinService;

    public void createDataSync(Object operateEntity) {
        Class<?> entityClass = operateEntity.getClass();
        if (HussarUtils.isEmpty(entityClass)) {
            return;
        }
        String tableName = this.checkAnnotationAndGetTableName(entityClass);
        if (HussarUtils.isBlank((CharSequence)tableName)) {
            return;
        }
        DataSource dataSource = (DataSource)SpringContextUtil.getBean(DataSource.class);
        try (Connection conn = dataSource.getConnection();){
            String dataSourceName = conn.getMetaData().getDatabaseProductName().toLowerCase();
            StringBuilder sql = new StringBuilder();
            sql.append(MybatisUtil.INSERT).append(this.getColumnName(tableName.concat(MybatisUtil.TABLESUFFIX), dataSourceName));
            LinkedList<String> columnList = new LinkedList<String>();
            LinkedList<String> valueList = new LinkedList<String>();
            for (Field field : entityClass.getDeclaredFields()) {
                TableField tableField;
                if (field.isAnnotationPresent(TableId.class)) {
                    field.setAccessible(true);
                    try {
                        TableId tableId = field.getAnnotation(TableId.class);
                        columnList.add(this.getColumnName(tableId.value(), dataSourceName));
                        valueList.add(field.get(operateEntity).toString());
                    }
                    catch (IllegalAccessException e) {
                        ApiResponse.fail((String)"\u83b7\u53d6\u6570\u636e\u4e3b\u952e\u5f02\u5e38\uff01");
                        throw new RuntimeException(e);
                    }
                }
                if (field.isAnnotationPresent(PinyinSearchColumn.class)) {
                    field.setAccessible(true);
                    try {
                        tableField = field.getAnnotation(TableField.class);
                        PinyinSearchColumn pinyinSearchColumn = field.getAnnotation(PinyinSearchColumn.class);
                        String pinyinType = pinyinSearchColumn.type();
                        columnList.add(this.getColumnName(tableField.value(), dataSourceName));
                        valueList.add(this.addSingleQuote(field.get(operateEntity).toString()));
                        columnList.add(this.getColumnName(tableField.value().concat(MybatisUtil.SEARCHCOLUMNFULLSUFFIX), dataSourceName));
                        if ("name".equals(pinyinType)) {
                            valueList.add(this.addSingleQuote(this.convertPinyinService.getNameFullPinyin(field.get(operateEntity).toString())));
                        } else {
                            valueList.add(this.addSingleQuote(this.convertPinyinService.getFullPinyin(field.get(operateEntity).toString())));
                        }
                        columnList.add(this.getColumnName(tableField.value().concat(MybatisUtil.SEARCHCOLUMNINITIALSUFFIX), dataSourceName));
                        if ("name".equals(pinyinType)) {
                            valueList.add(this.addSingleQuote(this.convertPinyinService.getNameInitialsPinyin(field.get(operateEntity).toString())));
                        } else {
                            valueList.add(this.addSingleQuote(this.convertPinyinService.getInitialsPinyin(field.get(operateEntity).toString())));
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                if (!field.isAnnotationPresent(PinyinViewColumn.class)) continue;
                field.setAccessible(true);
                try {
                    tableField = field.getAnnotation(TableField.class);
                    columnList.add(this.getColumnName(tableField.value(), dataSourceName));
                    valueList.add(this.getColumnValue(field.get(operateEntity), dataSourceName));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            sql.append(MybatisUtil.LEFTPARENTHESIS).append(String.join((CharSequence)", ", columnList)).append(MybatisUtil.RIGHTPARENTHESIS).append(MybatisUtil.VALUES).append(MybatisUtil.LEFTPARENTHESIS).append(String.join((CharSequence)", ", valueList)).append(MybatisUtil.RIGHTPARENTHESIS).append(";");
            try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
                preparedStatement.execute();
            }
        }
        catch (SQLException e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void updateDataSync(Object operateEntity) {
        Class<?> entityClass = operateEntity.getClass();
        if (HussarUtils.isEmpty(entityClass)) {
            return;
        }
        String tableName = this.checkAnnotationAndGetTableName(entityClass);
        if (HussarUtils.isBlank((CharSequence)tableName)) {
            return;
        }
        DataSource dataSource = (DataSource)SpringContextUtil.getBean(DataSource.class);
        try (Connection conn = dataSource.getConnection();){
            String dataSourceName = conn.getMetaData().getDatabaseProductName().toLowerCase();
            StringBuilder sql = new StringBuilder();
            sql.append(MybatisUtil.UPDATE).append(this.getColumnName(tableName.concat(MybatisUtil.TABLESUFFIX), dataSourceName)).append(MybatisUtil.SET);
            ArrayList<String> assignmentParts = new ArrayList<String>();
            for (Field field : entityClass.getDeclaredFields()) {
                TableField tableField;
                if (field.isAnnotationPresent(PinyinSearchColumn.class)) {
                    field.setAccessible(true);
                    try {
                        tableField = field.getAnnotation(TableField.class);
                        PinyinSearchColumn pinyinSearchColumn = field.getAnnotation(PinyinSearchColumn.class);
                        String pinyinType = pinyinSearchColumn.type();
                        String originalValue = this.getColumnName(tableField.value(), dataSourceName) + " = '" + field.get(operateEntity).toString() + "'";
                        assignmentParts.add(originalValue);
                        String fullPinyinValue = this.getColumnName(tableField.value().concat(MybatisUtil.SEARCHCOLUMNFULLSUFFIX), dataSourceName) + " = ";
                        fullPinyinValue = "name".equals(pinyinType) ? fullPinyinValue + this.addSingleQuote(this.convertPinyinService.getNameFullPinyin(field.get(operateEntity).toString())) : fullPinyinValue + this.addSingleQuote(this.convertPinyinService.getFullPinyin(field.get(operateEntity).toString()));
                        assignmentParts.add(fullPinyinValue);
                        String initialPinyinValue = this.getColumnName(tableField.value().concat(MybatisUtil.SEARCHCOLUMNINITIALSUFFIX), dataSourceName) + " = ";
                        initialPinyinValue = "name".equals(pinyinType) ? initialPinyinValue + this.addSingleQuote(this.convertPinyinService.getNameInitialsPinyin(field.get(operateEntity).toString())) : initialPinyinValue + this.addSingleQuote(this.convertPinyinService.getInitialsPinyin(field.get(operateEntity).toString()));
                        assignmentParts.add(initialPinyinValue);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                if (!field.isAnnotationPresent(PinyinViewColumn.class)) continue;
                field.setAccessible(true);
                try {
                    tableField = field.getAnnotation(TableField.class);
                    String assignStr = this.getColumnName(tableField.value(), dataSourceName) + " = " + this.getColumnValue(field.get(operateEntity), dataSourceName);
                    assignmentParts.add(assignStr);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            sql.append(String.join((CharSequence)", ", assignmentParts));
            String conditionStr = this.getPkConditionStr(operateEntity);
            if (HussarUtils.isBlank((CharSequence)conditionStr)) {
                return;
            }
            sql.append(MybatisUtil.WHERE).append(conditionStr).append(";");
            try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
                preparedStatement.execute();
            }
        }
        catch (SQLException e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void deleteDataSync(Object operateEntity) {
        Class<?> entityClass = operateEntity.getClass();
        if (HussarUtils.isEmpty(entityClass)) {
            return;
        }
        String tableName = this.checkAnnotationAndGetTableName(entityClass);
        if (HussarUtils.isBlank((CharSequence)tableName)) {
            return;
        }
        DataSource dataSource = (DataSource)SpringContextUtil.getBean(DataSource.class);
        try (Connection conn = dataSource.getConnection();){
            String dataSourceName = conn.getMetaData().getDatabaseProductName().toLowerCase();
            StringBuilder sql = new StringBuilder();
            sql.append(MybatisUtil.DELETE).append(this.getColumnName(tableName.concat(MybatisUtil.TABLESUFFIX), dataSourceName)).append(MybatisUtil.WHERE);
            String conditionStr = this.getPkConditionStr(operateEntity);
            if (HussarUtils.isBlank((CharSequence)conditionStr)) {
                return;
            }
            sql.append(conditionStr).append(";");
            try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
                preparedStatement.execute();
            }
        }
        catch (SQLException e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String checkAnnotationAndGetTableName(Class<?> entityClass) {
        PinyinSearchEntity annotation = entityClass.getAnnotation(PinyinSearchEntity.class);
        if (HussarUtils.isEmpty((Object)annotation)) {
            return null;
        }
        TableName tableName = entityClass.getAnnotation(TableName.class);
        if (HussarUtils.isEmpty((Object)tableName)) {
            return null;
        }
        return tableName.value();
    }

    public String getPkConditionStr(Object operateEntity) {
        Field[] fields;
        StringBuilder sql = new StringBuilder();
        Class<?> entityClass = operateEntity.getClass();
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(TableId.class)) continue;
            field.setAccessible(true);
            try {
                TableId tableId = field.getAnnotation(TableId.class);
                sql.append(tableId.value()).append(" = ").append(field.get(operateEntity).toString());
            }
            catch (IllegalAccessException e) {
                ApiResponse.fail((String)"\u83b7\u53d6\u6570\u636e\u4e3b\u952e\u5f02\u5e38\uff01");
                throw new RuntimeException(e);
            }
        }
        return sql.toString();
    }

    public String getColumnValue(Object fieldObject, String dataSourceName) {
        if (HussarUtils.isEmpty((Object)fieldObject)) {
            return "NULL";
        }
        if (fieldObject instanceof String) {
            return this.addSingleQuote(fieldObject.toString());
        }
        if (fieldObject instanceof Integer) {
            return fieldObject.toString();
        }
        if (fieldObject instanceof Long) {
            return fieldObject.toString();
        }
        if (fieldObject instanceof LocalDateTime) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            if ("dm dbms".equals(dataSourceName) || "kingbasees".equals(dataSourceName) || "oracle".equals(dataSourceName)) {
                return "TO_DATE('" + ((LocalDateTime)fieldObject).format(formatter) + "','SYYYY-MM-DD HH24:MI:SS')";
            }
            return this.addSingleQuote(((LocalDateTime)fieldObject).format(formatter));
        }
        return "NULL";
    }

    public String addSingleQuote(String value) {
        if (HussarUtils.isBlank((CharSequence)value)) {
            return "";
        }
        return "'" + value + "'";
    }

    public String getColumnName(String columnName, String dataSourceName) {
        switch (dataSourceName) {
            case "dm dbms": {
                return "\"" + columnName.toUpperCase() + "\"";
            }
            case "highgo": {
                return "\"" + columnName.toLowerCase() + "\"";
            }
            case "kingbasees": {
                return "\"" + columnName.toUpperCase() + "\"";
            }
            case "mysql": {
                return "`" + columnName.toUpperCase() + "`";
            }
            case "oracle": {
                return "\"" + columnName.toUpperCase() + "\"";
            }
            case "oscar": {
                return "\"" + columnName.toUpperCase() + "\"";
            }
            case "postgresql": {
                return "\"" + columnName.toLowerCase() + "\"";
            }
            case "microsoft sql server": {
                return "[" + columnName.toUpperCase() + "]";
            }
        }
        return columnName;
    }
}

