/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pinyin.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.pinyin.dao.PinyinSysAsyncEventMapper;
import com.jxdinfo.hussar.pinyin.enums.EventTypeEnum;
import com.jxdinfo.hussar.pinyin.event.PinyinAfterCreateSyncEvent;
import com.jxdinfo.hussar.pinyin.event.PinyinAfterDeleteSyncEvent;
import com.jxdinfo.hussar.pinyin.event.PinyinAfterUpdateSyncEvent;
import com.jxdinfo.hussar.pinyin.model.AsyncEventDo;
import com.jxdinfo.hussar.pinyin.service.IPinyinErrNoticeMessage;
import com.jxdinfo.hussar.pinyin.service.IPinyinRetrievalJobService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.pinyin.service.impl.pinyinRetrievalJobServiceImpl")
public class PinyinRetrievalJobServiceImpl
implements IPinyinRetrievalJobService {
    private final Logger logger = LogManager.getLogger(PinyinRetrievalJobServiceImpl.class);
    @Resource
    private PinyinSysAsyncEventMapper pinyinSysAsyncEventMapper;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired(required=false)
    private List<IPinyinErrNoticeMessage> pinyinErrNoticeMessageList;

    public void synPinyinRetrievalCopyTable() {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.le(AsyncEventDo::getRetryNum, (Object)5)).and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(AsyncEventDo::getStatus, (Object)"0")).or()).eq(AsyncEventDo::getStatus, (Object)"2"))).orderByAsc(AsyncEventDo::getCreateTime);
        List list = this.pinyinSysAsyncEventMapper.selectList((Wrapper)lambdaQueryWrapper);
        if (list != null && list.size() > 0) {
            for (AsyncEventDo asyncEventDo : list) {
                try {
                    Object obj = JSON.parseObject((String)asyncEventDo.getEvent(), Class.forName(asyncEventDo.getClassName()));
                    String eventType = asyncEventDo.getEventType();
                    if (EventTypeEnum.INSERT.getEventType().equals(eventType)) {
                        this.applicationEventPublisher.publishEvent((ApplicationEvent)new PinyinAfterCreateSyncEvent((Object)this, obj));
                    }
                    if (EventTypeEnum.UPDATE.getEventType().equals(eventType)) {
                        this.applicationEventPublisher.publishEvent((ApplicationEvent)new PinyinAfterUpdateSyncEvent((Object)this, obj));
                    }
                    if (EventTypeEnum.DELETE.getEventType().equals(eventType)) {
                        this.applicationEventPublisher.publishEvent((ApplicationEvent)new PinyinAfterDeleteSyncEvent((Object)this, obj));
                    }
                    this.pinyinSysAsyncEventMapper.deleteById(asyncEventDo.getId());
                    this.logger.info("\u4e8b\u4ef6\u7c7b\u578b\uff1a{}\uff0c\u4e8b\u4ef6\uff1a{}\uff0c\u5df2\u6b63\u5e38\u6d88\u8d39\u3002", (Object)asyncEventDo.getEventType(), (Object)asyncEventDo.getEvent());
                }
                catch (Exception e) {
                    try {
                        asyncEventDo.setRetryNum(Integer.valueOf(asyncEventDo.getRetryNum() + 1));
                        asyncEventDo.setErrorMsg(e.getMessage());
                        asyncEventDo.setStatus("2");
                        this.pinyinSysAsyncEventMapper.updateById(asyncEventDo);
                        if (asyncEventDo.getRetryNum() == 5 && this.pinyinErrNoticeMessageList != null) {
                            for (IPinyinErrNoticeMessage iPinyinErrNoticeMessage : this.pinyinErrNoticeMessageList) {
                                try {
                                    iPinyinErrNoticeMessage.noticePinyinSynErrMessage();
                                }
                                catch (Exception exception) {
                                    this.logger.error(exception.getMessage(), (Throwable)exception);
                                }
                            }
                        }
                        this.logger.info("\u4e8b\u4ef6\u7c7b\u578b\uff1a{}\uff0c\u4e8b\u4ef6\uff1a{}\uff0c\u6d88\u8d39\u5f02\u5e38\u3002", (Object)asyncEventDo.getEventType(), (Object)asyncEventDo.getEvent());
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
        }
    }
}

