/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pinyin.service.impl;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.pinyin.dto.TableFieldDto;
import com.jxdinfo.hussar.pinyin.dto.TableInfoDto;
import com.jxdinfo.hussar.pinyin.dto.UpdateDataDto;
import com.jxdinfo.hussar.pinyin.model.UpdateHistoryDataEntity;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.pinyin.service.IPinyinDataInitializeService;
import com.jxdinfo.hussar.pinyin.service.IUpdateHistoryDataService;
import com.jxdinfo.hussar.pinyin.util.MybatisUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.pinyin.service.impl.pinyinSearchServiceImpl")
public class PinyinDataInitializeServiceImpl
implements IPinyinDataInitializeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinyinDataInitializeServiceImpl.class);
    @Resource
    private IConvertPinyinService iConvertPinyinService;
    @Resource
    private IUpdateHistoryDataService iUpdateHistoryDataService;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;

    public ApiResponse<String> synchroniseHistoryRecord(TableInfoDto tableInfo) {
        String tableName = tableInfo.getTableName();
        List searchFields = tableInfo.getSearchFields();
        List viewTableFields = tableInfo.getViewFields();
        if (HussarUtils.isEmpty((Object)tableName)) {
            return ApiResponse.fail((String)"\u6e90\u6570\u636e\u5e93\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isEmpty((Object)searchFields)) {
            return ApiResponse.fail((String)"\u62fc\u97f3\u68c0\u7d22\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isEmpty((Object)viewTableFields)) {
            return ApiResponse.fail((String)"\u5c55\u793a\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.checkSearchFieldsString(tableName, searchFields)) {
            return ApiResponse.fail((String)"\u62fc\u97f3\u68c0\u7d22\u5b57\u6bb5\u4ec5\u652f\u6301\u6587\u5b57\u7c7b\u578b");
        }
        DataSource dataSource = (DataSource)SpringContextUtil.getBean(DataSource.class);
        Connection conn = null;
        String pkName = "";
        String dataSourceName = null;
        try {
            if (HussarUtils.isEmpty((Object)dataSource)) {
                return ApiResponse.fail((String)"\u83b7\u53d6\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25\uff01");
            }
            conn = dataSource.getConnection();
            pkName = this.getPrimaryKeyName(conn, tableName);
            dataSourceName = this.getDataSourceName(conn);
        }
        catch (Exception e) {
            LOGGER.error("\u62fc\u97f3\u68c0\u7d22\u540c\u6b65\u5386\u53f2\u6570\u636e\uff0c\u83b7\u53d6\u6e90\u8868\u4e3b\u952e\u62a5\u9519error:{}", (Object)e.getMessage());
            throw new BaseException("\u83b7\u53d6\u6e90\u6570\u636e\u5e93\u8868\u4e3b\u952e\u62a5\u9519\uff01");
        }
        List<String> viewFields = this.getColumnNames(viewTableFields, dataSourceName);
        List<String> searchFieldList = this.getColumnNames(searchFields, dataSourceName);
        this.addPkName(viewFields, dataSourceName, pkName);
        String viewColums = this.getConcatedColumnNames(viewFields);
        String viewColumsSql = this.getConcatedColumnNames(this.addPkName(this.getColumnNames(viewTableFields, ""), pkName));
        String searchColums = this.getConcatedColumnNames(searchFieldList);
        String searchColumsSql = this.getConcatedColumnNames(this.getColumnNames(searchFields, ""));
        String originSelectSql = this.getOriginSelectSql(viewColums, tableName);
        String searchColumsSelectSql = this.getOriginSelectSql(searchColums, tableName);
        boolean tableExistFlag = this.getTableExist(conn, tableName);
        try {
            if (tableExistFlag) {
                if (!this.checkOrignAndTarget(conn, tableName, viewFields, searchFieldList)) {
                    this.dropOldTargetTable(conn, tableName);
                    this.createTargetTable(conn, originSelectSql, searchColumsSelectSql, tableName, dataSourceName);
                }
            } else if (!tableExistFlag) {
                this.createTargetTable(conn, originSelectSql, searchColumsSelectSql, tableName, dataSourceName);
            }
            this.synchroniseHistoryRecord(originSelectSql, searchColumsSelectSql, conn, tableName, viewColumsSql, searchColumsSql, dataSourceName);
        }
        catch (Exception e) {
            LOGGER.error("\u62fc\u97f3\u68c0\u7d22\u540c\u6b65\u5386\u53f2\u6570\u636e\uff0c\u5efa\u8868\uff0c\u540c\u6b65\u6570\u636e\u5931\u8d25error:{}", (Object)e.getMessage());
            throw new BaseException("\u5386\u53f2\u6570\u636e\u540c\u6b65\u51fa\u9519\uff01");
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOGGER.error("conn\u6570\u636e\u5e93\u8fde\u63a5\u5173\u95ed\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
            }
        }
        return ApiResponse.success((String)"\u6570\u636e\u540c\u6b65\u6210\u529f");
    }

    public ApiResponse<String> updateHistoryData(UpdateDataDto updateDataDto) {
        if (HussarUtils.isBlank((CharSequence)updateDataDto.getTableName()) || HussarUtils.isBlank((CharSequence)updateDataDto.getPrimaryKeyName()) || HussarUtils.isBlank((CharSequence)updateDataDto.getOriginalName())) {
            return ApiResponse.fail((String)"\u6570\u636e\u5e93\u8868\u540d/\u4e3b\u952e\u5b57\u6bb5\u540d/\u9700\u8981\u5b9e\u73b0\u62fc\u97f3\u68c0\u7d22\u7684\u539f\u5b57\u6bb5\u540d\u4e0d\u5b8c\u6574\uff01");
        }
        List dataList = this.iUpdateHistoryDataService.selectList(updateDataDto.getTableName(), updateDataDto.getPrimaryKeyName(), updateDataDto.getOriginalName());
        List<List<Map<String, Object>>> listGroup = this.spilitGroup(dataList, 1000);
        int size = listGroup.size();
        CountDownLatch countDownLatch = new CountDownLatch(size);
        for (int i = 0; i < size; ++i) {
            ArrayList<UpdateHistoryDataEntity> updateList = new ArrayList<UpdateHistoryDataEntity>();
            List<Map<String, Object>> smallList = listGroup.get(i);
            for (int j = 0; j < smallList.size(); ++j) {
                String initialPinyin;
                String fullPinyin;
                Map<String, Object> map = smallList.get(j);
                HashMap<String, Object> resMap = new HashMap<String, Object>();
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    String lowerCaseKey = entry.getKey().toLowerCase();
                    resMap.put(lowerCaseKey, entry.getValue());
                }
                Long id = Long.valueOf(String.valueOf(resMap.get("id")));
                String chinese = resMap.get("data").toString();
                if ("1".equals(updateDataDto.getNameFlag())) {
                    fullPinyin = this.iConvertPinyinService.getNameFullPinyin(chinese);
                    initialPinyin = this.iConvertPinyinService.getNameInitialsPinyin(chinese);
                } else {
                    fullPinyin = this.iConvertPinyinService.getFullPinyin(chinese);
                    initialPinyin = this.iConvertPinyinService.getInitialsPinyin(chinese);
                }
                UpdateHistoryDataEntity updateHistoryDataEntity = new UpdateHistoryDataEntity();
                updateHistoryDataEntity.setPrimaryKeyName(updateDataDto.getPrimaryKeyName());
                updateHistoryDataEntity.setId(id);
                updateHistoryDataEntity.setPinyinFullName(updateDataDto.getPinyinFullName());
                updateHistoryDataEntity.setPinyinFullValue(fullPinyin);
                updateHistoryDataEntity.setPinyinInitialName(updateDataDto.getPinyinInitialName());
                updateHistoryDataEntity.setPinyinInitialValue(initialPinyin);
                updateList.add(updateHistoryDataEntity);
            }
            Executor executor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
            executor.execute(() -> {
                try {
                    for (int l = 0; l < updateList.size(); ++l) {
                        this.iUpdateHistoryDataService.updateBatch(updateDataDto.getTableName(), (UpdateHistoryDataEntity)updateList.get(l));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return ApiResponse.success((String)"\u8868\u4e2d\u5386\u53f2\u6570\u636e\u5237\u65b0\u6210\u529f\uff01");
    }

    private List<List<Map<String, Object>>> spilitGroup(List<Map<String, Object>> values, int groupSize) {
        ArrayList<List<Map<String, Object>>> listGroup = new ArrayList<List<Map<String, Object>>>();
        int listSize = values.size();
        int runSize = listSize / groupSize + 1;
        for (int i = 0; i < runSize; ++i) {
            List<Map<String, Object>> value;
            int end;
            int start = i * groupSize;
            if (i + 1 == runSize) {
                end = listSize;
                value = values.subList(start, end);
            } else {
                end = (i + 1) * groupSize;
                value = values.subList(start, end);
            }
            listGroup.add(value);
        }
        return listGroup;
    }

    public void addPkName(List<String> columnNames, String dataSourceName, String pkName) {
        if ("postgresql".equals(dataSourceName)) {
            columnNames.add(0, "\"" + pkName + "\"");
        } else {
            columnNames.add(0, pkName);
        }
    }

    public List<String> addPkName(List<String> columnNames, String pkName) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(0, pkName);
        result.addAll(columnNames);
        return result;
    }

    public String getDriverName() {
        String driverName = "";
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            driverName = driver.getClass().getName();
        }
        return driverName;
    }

    public List<String> getColumnNames(List<TableFieldDto> tableFields, String dataSourceName) {
        List<Object> columnNames = Lists.newArrayListWithCapacity((int)4);
        if (HussarUtils.isNotEmpty(tableFields)) {
            columnNames = "postgresql".equals(dataSourceName) ? tableFields.stream().map(TableFieldDto::getName).collect(Collectors.toList()).stream().map(s -> "\"" + s + "\"").collect(Collectors.toList()) : tableFields.stream().map(TableFieldDto::getName).collect(Collectors.toList());
        }
        return columnNames;
    }

    public String getConcatedColumnNames(List<String> columnNames) {
        return String.join((CharSequence)",", columnNames);
    }

    public boolean checkSearchFieldsString(String tableName, List<TableFieldDto> searchFields) {
        boolean result = false;
        TableInfo tableInfo = null;
        List columnNames = searchFields.stream().map(TableFieldDto::getName).collect(Collectors.toList());
        List<Object> resultList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)tableName) && HussarUtils.isNotEmpty((Object)(tableInfo = TableInfoHelper.getTableInfo((String)tableName)))) {
            List TableFieldInfos = tableInfo.getFieldList();
            resultList = TableFieldInfos.stream().filter(TableFieldInfo2 -> columnNames.contains(TableFieldInfo2.getColumn())).collect(Collectors.toList()).stream().filter(TableFieldInfo2 -> "java.lang.String".equals(TableFieldInfo2.getPropertyType().getName())).collect(Collectors.toList());
        }
        if (resultList.size() == searchFields.size()) {
            result = true;
        }
        return result;
    }

    public String transferSearchColumnsToString(List<String> searchFieldList) {
        ArrayList transferSearchColumns = Lists.newArrayListWithCapacity((int)4);
        List searchFullColumns = searchFieldList.stream().map(s -> s.concat(MybatisUtil.SEARCHCOLUMNFULLSUFFIX)).collect(Collectors.toList());
        List searchInitialColumns = searchFieldList.stream().map(s -> s.concat(MybatisUtil.SEARCHCOLUMNINITIALSUFFIX)).collect(Collectors.toList());
        int size = searchFieldList.size();
        for (int i = 0; i < size; ++i) {
            transferSearchColumns.add(searchFullColumns.get(i));
            transferSearchColumns.add(searchInitialColumns.get(i));
        }
        return String.join((CharSequence)",", transferSearchColumns);
    }

    public List<String> transferSearchColumns(List<String> searchFieldList) {
        ArrayList newTableColumnName = Lists.newArrayListWithCapacity((int)4);
        List searchFullColumns = searchFieldList.stream().map(s -> s.concat(MybatisUtil.SEARCHCOLUMNFULLSUFFIX)).collect(Collectors.toList());
        List searchInitialColumns = searchFieldList.stream().map(s -> s.concat(MybatisUtil.SEARCHCOLUMNINITIALSUFFIX)).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(searchFullColumns)) {
            int size = searchFullColumns.size();
            for (int i = 0; i < size; ++i) {
                newTableColumnName.add(searchFullColumns.get(i));
                newTableColumnName.add(searchInitialColumns.get(i));
            }
        }
        return newTableColumnName;
    }

    public boolean getTableExist(Connection conn, String tableName) {
        boolean flag = false;
        ResultSet resultSetTables = null;
        try {
            resultSetTables = conn.getMetaData().getTables(conn.getCatalog(), conn.getSchema(), tableName.concat(MybatisUtil.TABLESUFFIX), null);
            while (resultSetTables.next()) {
                flag = true;
            }
            if (!flag) {
                resultSetTables = conn.getMetaData().getTables(conn.getCatalog(), conn.getSchema(), tableName.concat(MybatisUtil.TABLESUFFIX).toLowerCase(), null);
                while (resultSetTables.next()) {
                    flag = true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6e90\u8868\u4fe1\u606f\u5931\u8d25error:{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            if (resultSetTables != null) {
                try {
                    resultSetTables.close();
                }
                catch (SQLException e) {
                    LOGGER.error("resultSetTables\u5173\u95ed\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
            }
        }
        return flag;
    }

    public void createTargetTable(Connection conn, String originSelectSql, String searchColumsSelectSql, String tableName, String dataSourceName) {
        String createTablesql = this.getCreateTableSql(conn, originSelectSql, searchColumsSelectSql, tableName, dataSourceName);
        try (PreparedStatement preparedStatement = conn.prepareStatement(createTablesql);){
            preparedStatement.execute();
        }
        catch (SQLException e) {
            throw new BaseException((Throwable)e);
        }
    }

    public void dropOldTargetTable(Connection conn, String tableName) {
        StringBuffer dropTableSql = new StringBuffer();
        try {
            dropTableSql.append(MybatisUtil.DROP).append(tableName.concat(MybatisUtil.TABLESUFFIX));
            try (PreparedStatement preparedStatement = conn.prepareStatement(dropTableSql.toString());){
                preparedStatement.execute();
            }
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public boolean checkOrignAndTarget(Connection conn, String tableName, List<String> viewFields, List<String> searchFieldList) {
        boolean flag = false;
        ResultSet resultSetColums = null;
        ArrayList targetTableColumnNames = Lists.newArrayListWithCapacity((int)4);
        ArrayList newTableColumnName = Lists.newArrayListWithCapacity((int)4);
        try {
            newTableColumnName.addAll(viewFields);
            newTableColumnName.addAll(this.transferSearchColumns(searchFieldList));
            resultSetColums = conn.getMetaData().getColumns(conn.getCatalog(), conn.getSchema(), tableName.concat(MybatisUtil.TABLESUFFIX), null);
            while (resultSetColums.next()) {
                String columnName = resultSetColums.getString("COLUMN_NAME");
                targetTableColumnNames.add(columnName);
            }
            flag = targetTableColumnNames.containsAll(newTableColumnName) && newTableColumnName.containsAll(targetTableColumnNames);
        }
        catch (Exception e) {
            LOGGER.error("\u5224\u65ad\u6e90\u540c\u6b65\u8868\u548c\u76ee\u6807\u8868\u5b57\u6bb5\u662f\u5426\u4e00\u81f4\u62a5\u9519error:{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            if (resultSetColums != null) {
                try {
                    resultSetColums.close();
                }
                catch (SQLException e) {
                    LOGGER.error("resultSetColums\u5173\u95ed\u5931\u8d25:{}", (Object)e.getMessage());
                }
            }
        }
        return flag;
    }

    public void synchroniseHistoryRecord(String originSelectSql, String searchColumsSelectSql, Connection conn, String tableName, String viewColums, String searchColums, String dataSourceName) {
        String targetTableName = tableName.concat(MybatisUtil.TABLESUFFIX);
        this.deleteTableRecords(targetTableName, conn);
        String transferedSearchColumns = this.transferSearchColumnsToString(Arrays.stream(searchColums.split(",")).collect(Collectors.toList()));
        String insertSql = this.getInsertSql(targetTableName, viewColums, transferedSearchColumns);
        String[] colums = this.getColumns(viewColums);
        String[] searchedColums = this.getColumns(searchColums);
        int rowNumber = this.getCountNum(tableName, conn);
        PreparedStatement ps = null;
        List values = null;
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        try {
            List<List<Object>> transferedSearchValues;
            List<List<Object>> dataValues;
            ps = conn.prepareStatement(insertSql);
            try (PreparedStatement originStatement = conn.prepareStatement(originSelectSql);){
                ResultSet orignQueryData = originStatement.executeQuery();
                try (PreparedStatement searchStatement = conn.prepareStatement(searchColumsSelectSql);){
                    ResultSet searchColumnsQueryData = searchStatement.executeQuery();
                    dataValues = MybatisUtil.getDataSourseManager(dataSourceName).getDataValues(orignQueryData, searchColumnsQueryData, colums, searchedColums, tableName);
                    transferedSearchValues = this.getTransferedValues(dataSourceName, searchColumnsQueryData, searchedColums, tableName);
                }
            }
            for (int k = 0; k < dataValues.size(); ++k) {
                List<Object> listOrign = dataValues.get(k);
                List<Object> listSearch = transferedSearchValues.get(k);
                listOrign.addAll(listSearch);
                result.add(listOrign);
            }
            if (HussarUtils.isNotEmpty(result)) {
                int dataLineNum = result.size();
                for (int i = 1; i <= dataLineNum; ++i) {
                    values = (List)result.get(i - 1);
                    for (int j = 1; j <= values.size(); ++j) {
                        ps.setObject(j, values.get(j - 1));
                    }
                    ps.addBatch();
                    if (i < rowNumber && i % 100 == 0) {
                        ps.executeBatch();
                        ps.clearBatch();
                        continue;
                    }
                    if (i != rowNumber) continue;
                    ps.executeBatch();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5386\u53f2\u6570\u636e\u540c\u6b65\u62a5\u9519error:{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error("\u5386\u53f2\u6570\u636e\u540c\u6b65\u5173\u95edps\u62a5\u9519:{}", (Object)e.getMessage());
            }
        }
    }

    public List<List<Object>> getTransferedValues(String dataSourceName, ResultSet search, String[] searchColumns, String tableName) {
        ArrayList<List<Object>> searchResult = new ArrayList<List<Object>>();
        ArrayList<String> transferedSearchValues = null;
        try {
            Map<String, String> searchColumnAnnationTypeValues = MybatisUtil.getDataSourseManager(dataSourceName).searchColumnAnnationInfos(tableName, searchColumns);
            ResultSetMetaData metaSearch = search.getMetaData();
            int searchColumnNum = metaSearch.getColumnCount();
            while (search.next()) {
                transferedSearchValues = new ArrayList<String>();
                for (int j = 1; j <= searchColumnNum; ++j) {
                    String columnString = search.getString(searchColumns[j - 1]);
                    String annationTypeValue = searchColumnAnnationTypeValues.get(searchColumns[j - 1]);
                    if ("name".equals(annationTypeValue)) {
                        transferedSearchValues.add(this.iConvertPinyinService.getNameFullPinyin(columnString));
                        transferedSearchValues.add(this.iConvertPinyinService.getNameInitialsPinyin(columnString));
                        continue;
                    }
                    transferedSearchValues.add(this.iConvertPinyinService.getFullPinyin(columnString));
                    transferedSearchValues.add(this.iConvertPinyinService.getInitialsPinyin(columnString));
                }
                searchResult.add(transferedSearchValues);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return searchResult;
    }

    public void deleteTableRecords(String targetTableName, Connection conn) {
        StringBuffer deleteSqlBuf = new StringBuffer();
        try {
            deleteSqlBuf.append(MybatisUtil.DELETE).append(targetTableName).append(" ");
            try (PreparedStatement preparedStatement = conn.prepareStatement(deleteSqlBuf.toString());){
                preparedStatement.execute();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getCountNum(String tableName, Connection conn) {
        String countSql = " SELECT count(*) coun FROM " + tableName;
        int rowNUmber = 0;
        try (PreparedStatement preparedStatement = conn.prepareStatement(countSql);){
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                rowNUmber = resultSet.getInt("coun");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u6e90\u8868\u8bb0\u5f55\u6570\u62a5\u9519error:{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return rowNUmber;
    }

    public String[] getColumns(String concatColumnNames) {
        String[] colums = new String[2];
        if (HussarUtils.isNotEmpty((Object)concatColumnNames)) {
            colums = concatColumnNames.split(",");
        }
        return colums;
    }

    public String getInsertSql(String targetTableName, String viewColums, String searchColums) {
        StringBuffer insertSqlBuf = new StringBuffer();
        if (HussarUtils.isNotEmpty((Object)viewColums)) {
            String sqlPlaceholder = this.getSqlPlaceholder(viewColums, searchColums);
            insertSqlBuf.append(MybatisUtil.INSERT).append(targetTableName).append(MybatisUtil.LEFTPARENTHESIS).append(viewColums).append(",").append(searchColums).append(MybatisUtil.RIGHTPARENTHESIS).append(MybatisUtil.VALUES).append(MybatisUtil.LEFTPARENTHESIS).append(sqlPlaceholder).append(MybatisUtil.RIGHTPARENTHESIS);
        }
        return insertSqlBuf.toString();
    }

    public String getSqlPlaceholder(String viewColums, String searchColums) {
        String sqlPlaceholder;
        StringBuffer sqlPlaceholderBuf = new StringBuffer();
        int viewNum = 0;
        int Searchnum = 0;
        if (HussarUtils.isNotEmpty((Object)viewColums)) {
            viewNum = viewColums.split(",").length;
            for (int i = 0; i < viewNum; ++i) {
                sqlPlaceholderBuf.append("?").append(",");
            }
        }
        if (HussarUtils.isNotEmpty((Object)searchColums)) {
            Searchnum = searchColums.split(",").length;
            for (int j = 0; j < Searchnum; ++j) {
                sqlPlaceholderBuf.append("?").append(",");
            }
        }
        if (HussarUtils.isNotEmpty((Object)(sqlPlaceholder = sqlPlaceholderBuf.toString()))) {
            sqlPlaceholder = sqlPlaceholder.substring(0, sqlPlaceholder.length() - 1);
        }
        return sqlPlaceholder;
    }

    public String getPrimaryKeyName(Connection conn, String tableName) {
        String pkName = "";
        ResultSet primryKeys = null;
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            primryKeys = metaData.getPrimaryKeys(conn.getCatalog(), conn.getSchema(), tableName);
            while (primryKeys.next()) {
                pkName = primryKeys.getString("COLUMN_NAME");
            }
        }
        catch (SQLException e) {
            LOGGER.error("\u83b7\u53d6\u6570\u636e\u5e93\u8868\u4e3b\u952e\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            if (primryKeys != null) {
                try {
                    primryKeys.close();
                }
                catch (SQLException e) {
                    LOGGER.error("primryKeys\u5173\u95ed\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
            }
        }
        return pkName;
    }

    public String getOriginSelectSql(String viewColums, String tableName) {
        StringBuffer originSelectSql = new StringBuffer();
        originSelectSql.append(MybatisUtil.SELECT).append(viewColums).append(MybatisUtil.FROM).append(tableName);
        return originSelectSql.toString();
    }

    public String getCreateTableSql(Connection conn, String orignSelectSql, String searchColumsSelectSql, String tableName, String dataSourceName) {
        StringBuffer createTableSqlBegin = this.getCreateTableSqlBegin(tableName);
        String tableColumnSql = null;
        if (conn != null) {
            try (PreparedStatement orignStatement = conn.prepareStatement(orignSelectSql);){
                ResultSetMetaData originSelectRs = orignStatement.executeQuery().getMetaData();
                try (PreparedStatement searchStatement = conn.prepareStatement(searchColumsSelectSql);){
                    ResultSetMetaData searchColumnsSelectRs = searchStatement.executeQuery().getMetaData();
                    tableColumnSql = MybatisUtil.getDataSourseManager(dataSourceName).getCreateTableSql(originSelectRs, searchColumnsSelectRs);
                    createTableSqlBegin.append(tableColumnSql);
                }
            }
            catch (SQLException e) {
                LOGGER.error("\u67e5\u8be2\u6e90\u6570\u636e\u5e93\u8868\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                throw new BaseException((Throwable)e);
            }
        }
        return createTableSqlBegin.toString();
    }

    public String getDataSourceName(Connection connection) {
        String dataSourceName = null;
        String driverName = null;
        try {
            dataSourceName = connection.getMetaData().getDatabaseProductName().toLowerCase();
            if ("postgresql".equals(dataSourceName) && HussarUtils.isNotEmpty((Object)(driverName = this.getDriverName())) && MybatisUtil.HIGNGODRIVER.equals(driverName)) {
                dataSourceName = "higngo";
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return dataSourceName;
    }

    public StringBuffer getCreateTableSqlBegin(String originTableName) {
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append(MybatisUtil.CREATETABLE).append(originTableName.concat(MybatisUtil.TABLESUFFIX)).append("( ");
        return createTableSql;
    }
}

