/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pinyin.util;

import com.jxdinfo.hussar.pinyin.util.MybatisUtil;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PinyinSqlUtil {
    public static String convert(String originalSql, Map<String, String> map, String tableName) {
        boolean limitFlag;
        String alias = PinyinSqlUtil.extractAliasFromSql(originalSql, tableName);
        String renameSql = originalSql.replaceAll("\\s{2,}", " ").replaceAll("(?i) " + tableName + " ", " " + tableName.concat(MybatisUtil.TABLESUFFIX) + " ");
        Set<String> columnNames = map.keySet();
        StringBuilder stringBuilder = new StringBuilder(renameSql);
        int orderBySql = PinyinSqlUtil.containStr(stringBuilder, "order by");
        int groupBySql = PinyinSqlUtil.containStr(stringBuilder, "group by");
        int limit = PinyinSqlUtil.containStr(stringBuilder, "limit");
        boolean orderFlag = orderBySql != -1;
        boolean groupFlag = groupBySql != -1;
        boolean bl = limitFlag = limit != -1;
        int start = groupFlag ? groupBySql : (orderFlag ? orderBySql : (limitFlag ? limit : -1));
        boolean first = true;
        boolean isAppend = start == -1;
        StringBuilder addStr = new StringBuilder();
        for (String columnName : columnNames) {
            String value = map.get(columnName);
            if (first) {
                addStr.append(" WHERE (").append(alias).append(".").append(columnName.concat(MybatisUtil.SEARCHCOLUMNFULLSUFFIX).toUpperCase()).append(" LIKE '").append(value).append("%' OR ").append(alias).append(".").append(columnName.concat(MybatisUtil.SEARCHCOLUMNINITIALSUFFIX).toUpperCase()).append(" LIKE '").append(value).append("%') ");
            } else {
                addStr.append(" AND (").append(alias).append(".").append(columnName.concat(MybatisUtil.SEARCHCOLUMNFULLSUFFIX).toUpperCase()).append(" LIKE '").append(value).append("%' OR ").append(alias).append(".").append(columnName.concat(MybatisUtil.SEARCHCOLUMNINITIALSUFFIX).toUpperCase()).append(" LIKE '").append(value).append("%') ");
            }
            if (!first) continue;
            first = false;
        }
        if (PinyinSqlUtil.containStr(stringBuilder, "where") != -1) {
            return stringBuilder.toString().replaceAll("(?i)where", addStr.append("AND ").toString());
        }
        if (isAppend) {
            stringBuilder.append(addStr.toString());
        } else {
            stringBuilder.insert(start, addStr.toString());
        }
        return stringBuilder.toString();
    }

    private static int containStr(StringBuilder s, String ch) {
        int i = s.indexOf(ch);
        if (i == -1) {
            i = s.indexOf(ch.toUpperCase());
        }
        return i;
    }

    public static String extractAliasFromSql(String sql, String tableName) {
        String regex = "(FROM\\s+)" + tableName + "\\s+(\\w+)";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }
}

