/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pinyin.service.impl;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.seg.common.Term;
import com.jxdinfo.hussar.pinyin.constants.PinyinConstant;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.pinyin.service.impl.ConvertPinyinServiceImpl")
public class ConvertPinyinServiceImpl
implements IConvertPinyinService {
    private static final HanyuPinyinOutputFormat FORMAT = new HanyuPinyinOutputFormat();

    public String getFullPinyin(String inputStr) {
        if (HussarUtils.isEmpty((Object)inputStr)) {
            return inputStr;
        }
        StringBuilder output = new StringBuilder();
        List terms = HanLP.segment((String)inputStr);
        for (Term term : terms) {
            if (term.word.matches("^[a-zA-Z]+$")) {
                output.append(term.word.toLowerCase());
                continue;
            }
            if (term.word.matches("^[\\u4E00-\\u9FA5]+$")) {
                String pinyin = HanLP.convertToPinyinString((String)term.word, (String)"", (boolean)false);
                output.append(pinyin);
                continue;
            }
            output.append(term.word);
        }
        return output.toString();
    }

    public String getInitialsPinyin(String inputStr) {
        if (HussarUtils.isEmpty((Object)inputStr)) {
            return inputStr;
        }
        StringBuilder output = new StringBuilder();
        List terms = HanLP.segment((String)inputStr);
        for (Term term : terms) {
            if (term.word.matches("^[a-zA-Z]+$")) {
                output.append(term.word.toLowerCase());
                continue;
            }
            if (term.word.matches("^[\\u4E00-\\u9FA5]+$")) {
                String pinyin = HanLP.convertToPinyinFirstCharString((String)term.word, (String)"", (boolean)false);
                output.append(pinyin);
                continue;
            }
            output.append(term.word);
        }
        return output.toString();
    }

    public String getNameFullPinyin(String inputStr) {
        for (Map.Entry map : PinyinConstant.COMPOUND_SURNAME.entrySet()) {
            if (!inputStr.startsWith((String)map.getKey())) continue;
            String suffix = inputStr.substring(((String)map.getKey()).length());
            return (String)map.getValue() + this.getFullPinyin(suffix);
        }
        for (Map.Entry map : PinyinConstant.SINGLE_SURNAME.entrySet()) {
            if (!inputStr.startsWith((String)map.getKey())) continue;
            String suffix = inputStr.substring(((String)map.getKey()).length());
            return (String)map.getValue() + this.getFullPinyin(suffix);
        }
        return this.getFullPinyin(inputStr);
    }

    public String getNameInitialsPinyin(String inputStr) {
        for (Map.Entry map : PinyinConstant.COMPOUND_SURNAME_INITIALS.entrySet()) {
            if (!inputStr.startsWith((String)map.getKey())) continue;
            String suffix = inputStr.substring(((String)map.getKey()).length());
            return (String)map.getValue() + this.getInitialsPinyin(suffix);
        }
        for (Map.Entry map : PinyinConstant.SINGLE_SURNAME.entrySet()) {
            if (!inputStr.startsWith((String)map.getKey())) continue;
            String suffix = inputStr.substring(((String)map.getKey()).length());
            return ((String)map.getValue()).charAt(0) + this.getInitialsPinyin(suffix);
        }
        return this.getInitialsPinyin(inputStr);
    }

    static {
        FORMAT.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        FORMAT.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        FORMAT.setVCharType(HanyuPinyinVCharType.WITH_V);
    }
}

