/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.onlinehist.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.permit.model.SysLoginUserIdentity;
import com.jxdinfo.hussar.authorization.permit.service.ILocalHussarBaseUserIdentityService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.operations.onlinehist.dao.SysOnlineHistMapper;
import com.jxdinfo.hussar.operations.onlinehist.model.SysOnlineHist;
import com.jxdinfo.hussar.operations.onlinehist.service.IAddOnlineHistoryService;
import com.jxdinfo.hussar.operations.onlinehist.service.ISysOnlineHistService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IpUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysOnlineHistServiceImpl
extends HussarBaseServiceImpl<SysOnlineHistMapper, SysOnlineHist>
implements ISysOnlineHistService {
    private static String HUSSAR_TOKEN = "hussar-token";
    @Resource
    private SysOnlineHistMapper sysOnlineHistMapper;
    @Autowired
    private IAddOnlineHistoryService addOnlineHistoryService;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private ILocalHussarBaseUserIdentityService hussarBaseUserIdentityService;
    @Resource
    private ISysStruService sysStruService;

    public Page<SysOnlineHist> getOnlineHistList(Page<SysOnlineHist> page, Timestamp startTime, Timestamp endTime, String userAccount) {
        page.setRecords(this.sysOnlineHistMapper.getOnlineHistList(page, startTime, endTime, userAccount));
        return page;
    }

    public void addRecord(String tokenId) {
        Long userId;
        SecurityUser shiroUser = BaseSecurityUtil.getUser((String)tokenId);
        String connName = shiroUser.getConnName();
        String tenantCode = shiroUser.getTenantCode();
        Long l = userId = ToolUtil.isNotEmpty((Object)shiroUser) ? shiroUser.getId() : null;
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new BaseException("\u767b\u5f55\u5931\u8d25 \u672a\u627e\u5230\u5bf9\u5e94shiro\u4fe1\u606f");
        }
        SysOnlineHist sysOnlineHist = new SysOnlineHist();
        sysOnlineHist.setRemoteaddr(IpUtils.getIp());
        sysOnlineHist.setRemotehost(IpUtils.getHostName());
        sysOnlineHist.setRemoteport(IpUtils.getRemotePort());
        sysOnlineHist.setBrowserType(this.getBrowserType());
        Executor loginSuccessExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (loginSuccessExecutor != null) {
            loginSuccessExecutor.execute(() -> {
                HussarContextHolder.setTenant((String)connName, (String)tenantCode);
                this.addOnlineHistoryService.asyncAddOnlineHistory((UserDetails)shiroUser, sysOnlineHist);
            });
        }
    }

    public void updateLogoffTime(String tokenId) {
        QueryWrapper sysOnlineHistQueryWrapper = new QueryWrapper();
        sysOnlineHistQueryWrapper.lambda().eq(SysOnlineHist::getTokenId, (Object)tokenId);
        List sysOnlineHistList = this.list((Wrapper)sysOnlineHistQueryWrapper);
        if (ToolUtil.isNotEmpty((Object)sysOnlineHistList)) {
            SysOnlineHist sysOnlineHist = (SysOnlineHist)sysOnlineHistList.get(0);
            sysOnlineHist.setLogoffTime(LocalDateTime.now());
            this.sysOnlineHistMapper.updateById(sysOnlineHist);
        }
    }

    public void updateLogoffTimeBatch(List<String> tokenIds) {
        if (HussarUtils.isNotEmpty(tokenIds)) {
            LocalDateTime localDateTime = LocalDateTime.now();
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysOnlineHist::getLogoffTime, (Object)localDateTime)).in(SysOnlineHist::getTokenId, tokenIds));
        }
    }

    public void updateAllLogoffTime() {
        QueryWrapper sysOnlineHistQueryWrapper = new QueryWrapper();
        sysOnlineHistQueryWrapper.lambda().isNull(SysOnlineHist::getLogoffTime);
        List sysOnlineHistList = this.list((Wrapper)sysOnlineHistQueryWrapper);
        if (ToolUtil.isNotEmpty((Object)sysOnlineHistList)) {
            sysOnlineHistList.forEach(o -> o.setLogoffTime(LocalDateTime.now()));
            this.updateBatchById(sysOnlineHistList);
        }
    }

    public void updateLayOutLogoffTime() {
        List tokenKeysList = HussarCacheUtil.getKeysRightLike((String)HUSSAR_TOKEN, (String)"hussar-token:login:token-session:");
        ArrayList<String> tokenIdNow = new ArrayList<String>();
        for (String key : tokenKeysList) {
            key = key.replace("hussar-token::hussar-token:login:token-session:", "");
            tokenIdNow.add(key);
        }
        QueryWrapper sysOnlineHistQueryWrapper = new QueryWrapper();
        sysOnlineHistQueryWrapper.lambda().isNull(SysOnlineHist::getLogoffTime);
        List<SysOnlineHist> sysOnlineHistList = this.list((Wrapper)sysOnlineHistQueryWrapper);
        sysOnlineHistList = sysOnlineHistList.stream().filter(o -> !tokenIdNow.contains(o.getTokenId())).collect(Collectors.toList());
        if (ToolUtil.isNotEmpty(sysOnlineHistList)) {
            sysOnlineHistList.forEach(o -> o.setLogoffTime(LocalDateTime.now()));
            this.updateBatchById(sysOnlineHistList);
        }
    }

    public void replaceTokenId(String oldAcessTokenId, String newAccessTokenId) {
        this.updateLogoffTime(oldAcessTokenId);
        QueryWrapper sysOnlineHistQueryWrapper = new QueryWrapper();
        sysOnlineHistQueryWrapper.lambda().eq(SysOnlineHist::getTokenId, (Object)oldAcessTokenId);
        List sysOnlineHistList = this.list((Wrapper)sysOnlineHistQueryWrapper);
        if (ToolUtil.isNotEmpty((Object)sysOnlineHistList)) {
            SysOnlineHist oldSysOnlineHist = (SysOnlineHist)sysOnlineHistList.get(0);
            SysLoginUserIdentity userIdentity = (SysLoginUserIdentity)this.hussarBaseUserIdentityService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysLoginUserIdentity::getUserId, (Object)oldSysOnlineHist.getUserId()));
            SysOrganVo dept = this.sysStruService.getOrgInfoByOrgId(userIdentity.getStruId());
            String deptName = "";
            if (ToolUtil.isNotEmpty((Object)dept) && ToolUtil.isNotEmpty((Object)dept.getOrganName())) {
                deptName = dept.getOrganName();
            }
            SysOnlineHist sysOnlineHist = new SysOnlineHist();
            sysOnlineHist.setTokenId(newAccessTokenId);
            sysOnlineHist.setUserId(oldSysOnlineHist.getUserId());
            sysOnlineHist.setUserAccount(oldSysOnlineHist.getUserAccount());
            sysOnlineHist.setUserName(oldSysOnlineHist.getUserName());
            sysOnlineHist.setCorporationId(userIdentity.getStruId());
            sysOnlineHist.setCorporationName(deptName);
            sysOnlineHist.setLoginTime(LocalDateTime.now());
            sysOnlineHist.setRemoteaddr(IpUtils.getIp());
            sysOnlineHist.setRemotehost(IpUtils.getHostName());
            sysOnlineHist.setRemoteport(IpUtils.getRemotePort());
            sysOnlineHist.setBrowserType(this.getBrowserType());
            this.saveOrUpdate((BaseEntity)sysOnlineHist);
        }
    }

    private String getBrowserType() {
        String userAgent = IpUtils.getUserAgent();
        String ua = userAgent.toLowerCase();
        String browser = "";
        if (ua.contains("edge")) {
            browser = userAgent.substring(userAgent.indexOf("Edge")).split(" ")[0].replace("/", "-");
        } else if (ua.contains("edg")) {
            browser = userAgent.substring(userAgent.indexOf("Edg")).split(" ")[0].replace("/", "-");
        } else if (ua.contains("msie")) {
            String substring = userAgent.substring(userAgent.indexOf("MSIE")).split(";")[0];
            browser = substring.split(" ")[0].replace("MSIE", "IE") + "-" + substring.split(" ")[1];
        } else if (ua.contains("safari") && ua.contains("version")) {
            browser = userAgent.substring(userAgent.indexOf("Safari")).split(" ")[0].split("/")[0] + "-" + userAgent.substring(userAgent.indexOf("Version")).split(" ")[0].split("/")[1];
        } else if (ua.contains("opr") || ua.contains("opera")) {
            browser = ua.contains("opera") ? userAgent.substring(userAgent.indexOf("Opera")).split(" ")[0].split("/")[0] + "-" + userAgent.substring(userAgent.indexOf("Version")).split(" ")[0].split("/")[1] : userAgent.substring(userAgent.indexOf("OPR")).split(" ")[0].replace("/", "-").replace("OPR", "Opera");
        } else if (ua.contains("chrome")) {
            browser = userAgent.substring(userAgent.indexOf("Chrome")).split(" ")[0].replace("/", "-");
        } else if (ua.indexOf("mozilla/7.0") > -1 || ua.indexOf("netscape6") != -1 || ua.indexOf("mozilla/4.7") != -1 || ua.indexOf("mozilla/4.78") != -1 || ua.indexOf("mozilla/4.08") != -1 || ua.indexOf("mozilla/3") != -1) {
            browser = "Netscape-?";
        } else if (ua.contains("firefox")) {
            browser = userAgent.substring(userAgent.indexOf("Firefox")).split(" ")[0].replace("/", "-");
        } else if (ua.contains("rv")) {
            String ieVersion = userAgent.substring(userAgent.indexOf("rv")).split(" ")[0].replace("rv:", "-");
            browser = "IE" + ieVersion.substring(0, ieVersion.length() - 1);
        } else {
            browser = ua.contains("mp_ios_hussar") ? "\u91d1\u4f01\u4fe1iOS" : "UnKnown";
        }
        return browser;
    }
}

