/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.listener;

import com.jxdinfo.hussar.operations.enums.TipConstantsEnum;
import com.jxdinfo.hussar.operations.onlinehist.service.ISysOnlineHistService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.security.plugin.oauth2.listener.HussarSecurityOauthListener;
import com.jxdinfo.hussar.utils.TranslateUtil;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BaseHussarSecurityOauthListener
implements HussarSecurityOauthListener {
    @Resource
    private ISysOnlineHistService iSysOnlineHistService;
    private static Logger LOGGER = LoggerFactory.getLogger(BaseHussarSecurityOauthListener.class);

    public void loginSuccess(UserDetails userDetails) {
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)TipConstantsEnum.OPERATION_LOGIN.getMessage()));
        auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.LOGIN);
        auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)TipConstantsEnum.OPERATION_LOGIN_SUCCESS.getMessage()));
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
        this.iSysOnlineHistService.addRecord(userDetails.getAccessToken());
        LOGGER.debug("\u7528\u6237:{},id\uff1a{}\u767b\u5f55\u6210\u529f", (Object)userDetails.getUserName(), (Object)userDetails.getUserId());
    }

    public void logoutSuccess(UserDetails userDetails) {
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)TipConstantsEnum.OPERATION_LOGOUT.getMessage()));
        auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.LOGOUT);
        auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)TipConstantsEnum.OPERATION_LOGOUT.getMessage()));
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
        this.iSysOnlineHistService.updateLogoffTime(userDetails.getAccessToken());
        LOGGER.debug("\u7528\u6237:{},id\uff1a{},accessToken:{},\u9000\u51fa\u6210\u529f", new Object[]{userDetails.getUserName(), userDetails.getUserId(), userDetails.getAccessToken()});
    }

    public void refreshTokenSuccess(String oldAccessToken, UserDetails newUserDetail) {
        this.iSysOnlineHistService.replaceTokenId(oldAccessToken, newUserDetail.getAccessToken());
        LOGGER.debug("\u7528\u6237:{},id\uff1a{},accessToken:{},\u5237\u65b0token\u6210\u529f,newAccessToken:{}", new Object[]{newUserDetail.getUserName(), newUserDetail.getUserId(), oldAccessToken, newUserDetail.getAccessToken()});
    }

    public void displacementSuccess(String clientId, String loginId, String accessToken) {
        LOGGER.debug("\u7528\u6237id\uff1a{},accessToken:{},\u6e05\u9664\u6216\u8005\u8e22\u4eba\u6210\u529f", (Object)loginId, (Object)accessToken);
    }
}

