/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.job;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.operations.onlinehist.model.SysOnlineHist;
import com.jxdinfo.hussar.operations.onlinehist.service.ISysOnlineHistService;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.cache.support.properties.HussarSecurityProperties;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TokenTimeOutAuditRecord
implements BasicProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenTimeOutAuditRecord.class);
    private static final ISysOnlineHistService SYS_ONLINE_HIST_SERVICE = (ISysOnlineHistService)SpringContextHolder.getBean(ISysOnlineHistService.class);
    private static final HussarSecurityProperties SECURITY_PROPERTIES = (HussarSecurityProperties)SpringContextHolder.getBean(HussarSecurityProperties.class);

    public ProcessResult process(TaskContext taskContext) throws Exception {
        LOGGER.debug("token\u8d85\u65f6\u7528\u6237\u626b\u63cf \u5ba1\u8ba1\u65e5\u5fd7\u8bb0\u5f55=====>");
        String cacheName = SECURITY_PROPERTIES.getTokenName();
        String keyPrefix = cacheName + ":oauth2:access-token:";
        List tokenKeys = HussarCacheUtil.getKeysRightLike((String)cacheName, (String)keyPrefix);
        if (CollectionUtils.isNotEmpty((Collection)tokenKeys)) {
            List tokenList = tokenKeys.stream().map(item -> item.replace(keyPrefix, "")).collect(Collectors.toList());
            tokenList = tokenList.stream().map(item -> item.replace(cacheName + "::", "")).collect(Collectors.toList());
            for (String accessToken : tokenList) {
                long expireTime = HussarCacheUtil.getKeyExpireTime((String)cacheName, (String)(keyPrefix + accessToken));
                LOGGER.debug("\u5269\u4f59\u65f6\u95f4\u4e3a===>{}", (Object)expireTime);
                if (expireTime > 60L) continue;
                QueryWrapper sysOnlineHistQueryWrapper = new QueryWrapper();
                sysOnlineHistQueryWrapper.lambda().eq(SysOnlineHist::getTokenId, (Object)accessToken);
                SysOnlineHist sysOnlineHist = (SysOnlineHist)SYS_ONLINE_HIST_SERVICE.getOne((Wrapper)sysOnlineHistQueryWrapper);
                LOGGER.debug("\u5f53\u524d\u5728\u7ebf\u7528\u6237\u4fe1\u606f\u4e3a===>{}", (Object)JSON.toJSONString((Object)sysOnlineHist));
                if (sysOnlineHist != null) {
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u51fa");
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGOUT);
                    auditLogModel.setEventDesc("\u975e\u6d3b\u52a8\u4f1a\u8bdd\u8d85\u65f6\u9000\u51fa");
                    auditLogModel.setUserDetails(HussarSecurityUtils.getLoginUserDetails((String)accessToken));
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    continue;
                }
                LOGGER.info("\u975e\u6d3b\u52a8\u4f1a\u8bdd\u8d85\u65f6\u9000\u51fa-\u6839\u636etoken\u672a\u627e\u5230\u7528\u6237===>{}", (Object)accessToken);
            }
        }
        return new ProcessResult(true, "success");
    }
}

