/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.interfacemanager.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.operations.interfacemanager.dao.SysInterfaceUserMapper;
import com.jxdinfo.hussar.operations.interfacemanager.dto.SysInterfaceUserDto;
import com.jxdinfo.hussar.operations.interfacemanager.model.SysInterfaceUser;
import com.jxdinfo.hussar.operations.interfacemanager.service.ISysInterfaceService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@HussarTokenDs
@Service
public class SysInterfaceServiceImpl
extends HussarServiceImpl<SysInterfaceUserMapper, SysInterfaceUser>
implements ISysInterfaceService {
    @Resource
    private SysInterfaceUserMapper sysInterfaceUserMapper;

    public ApiResponse<IPage<SysInterfaceUser>> queryList(Page page, SysInterfaceUser sysInterfaceUser) {
        if (ToolUtil.isEmpty((Object)page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String name = sysInterfaceUser.getUserName();
        if (!StringUtils.isEmpty((Object)name)) {
            name = name.replace("%", "\\\\%").replace("_", "\\\\_");
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.like(!StringUtils.isEmpty((Object)sysInterfaceUser.getUserName()), SysInterfaceUser::getUserName, (Object)name)).orderByDesc(SysInterfaceUser::getLastTime);
        IPage sysInterfaceUserPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return ApiResponse.success((Object)sysInterfaceUserPage);
    }

    public ApiResponse saveInterfaceUser(SysInterfaceUser sysInterfaceUser) {
        String userName = sysInterfaceUser.getUserName();
        String sysName = sysInterfaceUser.getSysName();
        String isLock = sysInterfaceUser.getIsLock();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{userName, sysName, isLock})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u65b0\u589e");
        }
        Long num = this.sysInterfaceUserMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysInterfaceUser::getUserName, (Object)userName));
        if (num != 0L) {
            throw new BaseException("\u63a5\u53e3\u7528\u6237\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        if (!this.save((BaseEntity)sysInterfaceUser)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f");
    }

    public ApiResponse updateInterfaceUser(SysInterfaceUserDto sysInterfaceUserDto) {
        Long num;
        String oldName = sysInterfaceUserDto.getOldName();
        Long userId = sysInterfaceUserDto.getId();
        String userName = sysInterfaceUserDto.getUserName();
        String sysName = sysInterfaceUserDto.getSysName();
        String sysUrl = sysInterfaceUserDto.getSysUrl();
        String isLock = sysInterfaceUserDto.getIsLock();
        if (!oldName.equals(userName) && (num = this.sysInterfaceUserMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysInterfaceUser::getUserName, (Object)userName))) != 0L) {
            throw new BaseException("\u63a5\u53e3\u7528\u6237\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        SysInterfaceUser sysInterfaceUser = new SysInterfaceUser();
        sysInterfaceUser.setId(userId);
        sysInterfaceUser.setUserName(userName);
        sysInterfaceUser.setIsLock(isLock);
        sysInterfaceUser.setSysName(sysName);
        sysInterfaceUser.setSysUrl(sysUrl);
        if (!this.saveOrUpdate((BaseEntity)sysInterfaceUser)) {
            throw new BaseException("\u66f4\u65b0\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @HussarTransactional
    public ApiResponse deleteByIds(String id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u5220\u9664");
        }
        String[] ids = id.split(",");
        List<String> idList = Arrays.asList(ids);
        if (!this.removeByIds(idList)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    public void updateInterfaceUser(String userName, Date issuedAtDate, Date expirationDate, String token) {
        List<SysInterfaceUser> users = this.sysInterfaceUserMapper.selectInterfaceUserListByName(userName);
        if (users != null && users.size() > 0) {
            SysInterfaceUser user = users.get(0);
            Integer connectNum = user.getConnectNum();
            connectNum = ToolUtil.isNotEmpty((Object)connectNum) ? Integer.valueOf(connectNum + 1) : Integer.valueOf(1);
            user.setConnectNum(connectNum);
            user.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            user.setTokenValue(token);
            user.setTokenStartTime(issuedAtDate);
            user.setTokenEndTime(expirationDate);
            this.sysInterfaceUserMapper.updateById(user);
        }
    }
}

