/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.onlineuser.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.lang.model.SysMultiLangMgt;
import com.jxdinfo.hussar.lang.service.ISysMultiLangMgtService;
import com.jxdinfo.hussar.operations.onlinehist.service.ISysOnlineHistService;
import com.jxdinfo.hussar.operations.onlineuser.dao.SysOnlineMapper;
import com.jxdinfo.hussar.operations.onlineuser.dto.SysOnlineDto;
import com.jxdinfo.hussar.operations.onlineuser.model.SysOnline;
import com.jxdinfo.hussar.operations.onlineuser.service.ISysOnlineService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.support.properties.HussarSecurityProperties;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.core.session.SecuritySession;
import com.jxdinfo.hussar.support.security.core.session.TokenSession;
import com.jxdinfo.hussar.support.security.core.session.TokenSign;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysOnlineServiceImpl
extends HussarServiceImpl<SysOnlineMapper, SysOnline>
implements ISysOnlineService {
    private static final Logger logger = LoggerFactory.getLogger(SysOnlineServiceImpl.class);
    @Resource
    private SysOnlineMapper sysOnlineMapper;
    @Autowired
    private HussarSecurityProperties securityProperties;
    @Autowired
    private ISysOnlineHistService iSysOnlineHistService;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Autowired(required=false)
    private IHussarTenantCommonService hussarTenantCommonService;
    @Resource
    private ISysMultiLangMgtService sysMultiLangMgtService;

    public Page<SysOnlineDto> getOnlineList(Page<SysOnlineDto> page, String userAccount, String userName) {
        String cacheName = this.securityProperties.getTokenName();
        String key = cacheName + ":oauth2:access-token:";
        List tokens = HussarFixedCacheUtil.getKeysRightLike((String)cacheName, (String)key);
        List filters = tokens.stream().map(item -> item.replace(key, "")).collect(Collectors.toList());
        ArrayList<String> query = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(filters)) {
            for (String s : filters) {
                query.add(s.substring(s.lastIndexOf(":") + 1));
            }
        }
        List<Object> sysOnlineList = new ArrayList();
        if (ToolUtil.isNotEmpty(query)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userId", SqlQueryUtil.transferSpecialChar((String)userAccount));
            map.put("userName", SqlQueryUtil.transferSpecialChar((String)userName));
            map.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
            map.put("tokenIdList", query);
            page.addOrder(new OrderItem[]{OrderItem.desc((String)"LOGIN_TIME")});
            sysOnlineList = this.sysOnlineMapper.getOnlineListByToken(page, map);
            for (SysOnlineDto sysOnlineDto : sysOnlineList) {
                String langKey = String.valueOf(sysOnlineDto.getUserId());
                Locale locale = LocaleContextHolder.getLocale();
                String lang = locale.toLanguageTag();
                String langText = Optional.ofNullable(this.sysMultiLangMgtService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMultiLangMgt::getLangKey, (Object)langKey)).eq(SysMultiLangMgt::getLang, (Object)lang))).map(SysMultiLangMgt::getLangText).orElse(sysOnlineDto.getUserName());
                sysOnlineDto.setUserName(langText);
            }
            if (HussarUtils.isEmpty(sysOnlineList)) {
                logger.error("\u83b7\u53d6\u5728\u7ebf\u7528\u6237\u5217\u8868\u4e3a\u7a7a\uff1a\u67e5\u8be2\u6761\u4ef6\u4e3a" + JSON.toJSONString(map));
            }
        } else if (HussarUtils.isNotEmpty((Object)tokens)) {
            logger.error("filters\u4e3a\u7a7a\uff0ctokens:{}", (Object)String.join((CharSequence)",", tokens));
        } else {
            logger.error("tokens\u4e3a\u7a7a");
        }
        page.setRecords(sysOnlineList);
        return page;
    }

    public void delRecord(String tokenId) {
        if (ToolUtil.isEmpty((Object)(tokenId = tokenId.trim()))) {
            return;
        }
        String tokenValue = BaseSecurityUtil.getTokenValue();
        TokenSession tokenSession = (TokenSession)HussarCacheUtil.get((String)"hussar-token", (Object)("hussar-token:login:token-session:" + tokenValue));
        UserDetails userDetails = tokenSession.getUserDetails();
        String accessTokenId = userDetails.getAccessToken();
        if (ToolUtil.isNotEmpty((Object)accessTokenId) && accessTokenId.equals(tokenId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TERMINATE_FAIL_INCLUDE_CURRENT_SESSION.getMessage()));
        }
        boolean removeTokenResult = HussarSecurityUtils.revokeAccessToken((String)tokenId);
        if (!removeTokenResult) {
            this.iSysOnlineHistService.updateLogoffTime(tokenId);
        }
    }

    public void delRecordByUserId(Long userId, String tCode) {
        String key;
        String cacheName = this.securityProperties.getTokenName();
        SecuritySession session = (SecuritySession)HussarCacheUtil.get((String)cacheName, (Object)(key = cacheName + ":" + "login:" + "session:" + userId), SecuritySession.class);
        if (HussarUtils.isEmpty((Object)session)) {
            return;
        }
        List tokenSignList = session.getTokenSignList();
        if (HussarUtils.isEmpty((Object)tokenSignList)) {
            return;
        }
        ArrayList<String> delTokenList = new ArrayList<String>();
        for (TokenSign sign : tokenSignList) {
            Object tokenObj;
            String accessToken;
            boolean removeTokenResult;
            String tokenValue = sign.getValue();
            TokenSession tokenSession = (TokenSession)HussarCacheUtil.get((String)cacheName, (Object)(cacheName + ":" + "login:" + "token-session:" + tokenValue));
            if (!HussarUtils.isNotEmpty((Object)tokenSession) || !HussarUtils.equals((Object)tCode, (Object)tokenSession.getUserDetails().getTenantCode()) || !(removeTokenResult = HussarSecurityUtils.revokeAccessToken((String)(accessToken = HussarUtils.isNotEmpty((Object)(tokenObj = sign.getExtendMap("access_token"))) ? String.valueOf(tokenObj) : null)))) continue;
            delTokenList.add(accessToken);
        }
        if (HussarUtils.isNotEmpty(delTokenList)) {
            this.iSysOnlineHistService.updateLogoffTimeBatch(delTokenList);
        }
    }
}

