/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.onlinehist.controller;

import com.jxdinfo.hussar.base.cloud.dto.HisUserDetailsDto;
import com.jxdinfo.hussar.operations.enums.TipConstantsEnum;
import com.jxdinfo.hussar.operations.onlinehist.service.ISysOnlineHistService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Feign\u5728\u7ebf\u7528\u6237\u5386\u53f2\u7ba1\u7406"})
public class RemoteSysOnlineHistController {
    @Resource
    private ISysOnlineHistService iSysOnlineHistService;

    @ApiOperation(value="Feign\u6dfb\u52a0\u5728\u7ebf\u7528\u6237", notes="\u6dfb\u52a0\u5728\u7ebf\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tokenId", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @PostMapping(value={"/remoteOnlineHist/addSysOnlineHist"})
    public void addSysOnlineHist(@RequestBody UserDetails userDetails) {
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)TipConstantsEnum.OPERATION_LOGIN.getMessage()));
        auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.LOGIN);
        auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)TipConstantsEnum.OPERATION_LOGIN_SUCCESS.getMessage()));
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
        this.iSysOnlineHistService.addRecord(userDetails.getAccessToken());
    }

    @ApiOperation(value="Feign\u66f4\u65b0\u5728\u7ebf\u7528\u6237", notes="\u66f4\u65b0\u5728\u7ebf\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tokenId", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @PostMapping(value={"/remoteOnlineHist/updateSysOnlineHist"})
    public void updateSysOnlineHist(@RequestBody UserDetails userDetails) {
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)TipConstantsEnum.OPERATION_LOGOUT.getMessage()));
        auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.LOGOUT);
        auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)TipConstantsEnum.OPERATION_LOGOUT.getMessage()));
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
        this.iSysOnlineHistService.updateLogoffTime(userDetails.getAccessToken());
    }

    @ApiOperation(value="Feign\u66f4\u65b0TokenId", notes="\u66f4\u65b0TokenId")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tokenId", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="Feign\u5728\u7ebf\u7528\u6237\u5386\u53f2", eventDesc="\u66f4\u65b0TokenId", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/remoteOnlineHist/updateTokenId"})
    public void updateTokenId(@RequestBody HisUserDetailsDto hisUserDetailsDto) {
        this.iSysOnlineHistService.replaceTokenId(hisUserDetailsDto.getOldAccessToken(), hisUserDetailsDto.getAccessToken());
    }
}

