/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.operations.onlinehist.model.SysOnlineHist;
import com.jxdinfo.hussar.operations.onlinehist.service.ISysOnlineHistService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.support.properties.HussarSecurityProperties;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class BaseDbSyncUserCache
implements BasicProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDbSyncUserCache.class);
    private static final ISysOnlineHistService SYS_ONLINE_HIST_SERVICE = (ISysOnlineHistService)SpringContextHolder.getBean(ISysOnlineHistService.class);
    private static final HussarSecurityProperties SECURITY_PROPERTIES = (HussarSecurityProperties)SpringContextHolder.getBean(HussarSecurityProperties.class);
    @Lazy
    @Autowired(required=false)
    private ISysTenantService sysTenantService;

    public ProcessResult process(TaskContext context) throws Exception {
        String tenantCode = context.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode) || "0".equals(tenantCode)) {
            boolean tenantOpen = TenantCacheUtil.openTenant();
            HashSet<String> connNameList = new HashSet<String>();
            Map normalTenants = new HashMap<String, DefaultTenant>();
            if (tenantOpen) {
                Set tenantConnNameList = this.sysTenantService.getConnNameList();
                if (HussarUtils.isNotEmpty((Object)tenantConnNameList)) {
                    connNameList.addAll(tenantConnNameList);
                }
                normalTenants = this.sysTenantService.getNormalTenants();
            } else {
                connNameList.add("master");
                normalTenants.put("master", new DefaultTenant());
            }
            LOGGER.debug("\u6570\u636e\u5e93\u548c\u7f13\u5b58\u540c\u6b65");
            for (String connName : connNameList) {
                HussarTenantDefinition hussarTenantDefinition = (HussarTenantDefinition)normalTenants.get(connName);
                if (hussarTenantDefinition == null) {
                    throw new BaseException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u6e90\u540d\u79f0\u4e3a" + connName + "\u7684\u79df\u6237");
                }
                HussarContextHolder.setTenant((HussarTenantDefinition)hussarTenantDefinition);
                QueryWrapper sysOnlineHistQueryWrapper = new QueryWrapper();
                sysOnlineHistQueryWrapper.lambda().isNull(SysOnlineHist::getLogoffTime);
                List list = SYS_ONLINE_HIST_SERVICE.list(connName, (Wrapper)sysOnlineHistQueryWrapper);
                String cacheName = SECURITY_PROPERTIES.getTokenName();
                String key = cacheName + ":oauth2:access-token:";
                List tokens = HussarFixedCacheUtil.getKeysRightLike((String)cacheName, (String)key);
                if (CollectionUtils.isNotEmpty((Collection)tokens)) {
                    List filters = tokens.stream().map(item -> item.replace(key, "")).collect(Collectors.toList());
                    filters = filters.stream().map(item -> item.replace(cacheName + "::", "")).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        for (SysOnlineHist sysOnlineHist : list) {
                            if (filters.contains(sysOnlineHist.getTokenId())) {
                                sysOnlineHist.setLogoffTime(null);
                                continue;
                            }
                            if (sysOnlineHist.getLogoffTime() != null) continue;
                            sysOnlineHist.setLogoffTime(LocalDateTime.now());
                        }
                        if (HussarUtils.isNotEmpty((Object)list)) {
                            SYS_ONLINE_HIST_SERVICE.updateBatchById(connName, (Collection)list);
                        }
                    }
                } else {
                    list.forEach(o -> o.setLogoffTime(LocalDateTime.now()));
                    if (HussarUtils.isNotEmpty((Object)list)) {
                        SYS_ONLINE_HIST_SERVICE.updateBatchById(connName, (Collection)list);
                    }
                }
                HussarContextHolder.remove();
            }
        }
        return new ProcessResult(true, "success");
    }
}

