/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.onlineuser.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.operations.onlinehist.service.ISysOnlineHistService;
import com.jxdinfo.hussar.operations.onlineuser.dao.SysOnlineMapper;
import com.jxdinfo.hussar.operations.onlineuser.dto.SysOnlineDto;
import com.jxdinfo.hussar.operations.onlineuser.model.SysOnline;
import com.jxdinfo.hussar.operations.onlineuser.service.ISysOnlineService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.support.properties.HussarSecurityProperties;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.core.session.TokenSession;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysOnlineServiceImpl
extends HussarServiceImpl<SysOnlineMapper, SysOnline>
implements ISysOnlineService {
    private static final Logger logger = LoggerFactory.getLogger(SysOnlineServiceImpl.class);
    @Resource
    private SysOnlineMapper sysOnlineMapper;
    @Autowired
    private HussarSecurityProperties securityProperties;
    @Autowired
    private ISysOnlineHistService iSysOnlineHistService;
    private static String HUSSAR_TOKEN = "hussar-token";

    public Page<SysOnlineDto> getOnlineList(Page<SysOnlineDto> page, String userAccount, String userName) {
        String cacheName = this.securityProperties.getTokenName();
        String key = cacheName + ":oauth2:access-token:";
        List tokens = HussarFixedCacheUtil.getKeysRightLike((String)cacheName, (String)key);
        List filters = tokens.stream().map(item -> item.replace(key, "")).collect(Collectors.toList());
        filters = filters.stream().map(item -> item.replace(cacheName + "::", "")).collect(Collectors.toList());
        List<Object> sysOnlineList = new ArrayList();
        if (ToolUtil.isNotEmpty(filters)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userId", SqlQueryUtil.transferSpecialChar((String)userAccount));
            map.put("userName", SqlQueryUtil.transferSpecialChar((String)userName));
            map.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
            map.put("tokenIdList", filters);
            page.addOrder(new OrderItem[]{OrderItem.desc((String)"LOGIN_TIME")});
            sysOnlineList = this.sysOnlineMapper.getOnlineListByToken(page, map);
            if (HussarUtils.isEmpty(sysOnlineList)) {
                logger.error("\u83b7\u53d6\u5728\u7ebf\u7528\u6237\u5217\u8868\u4e3a\u7a7a\uff1a\u67e5\u8be2\u6761\u4ef6\u4e3a" + JSON.toJSONString(map));
            }
        } else if (HussarUtils.isNotEmpty((Object)tokens)) {
            logger.error("filters\u4e3a\u7a7a\uff0ctokens:{}", (Object)String.join((CharSequence)",", tokens));
        } else {
            logger.error("tokens\u4e3a\u7a7a");
        }
        page.setRecords(sysOnlineList);
        return page;
    }

    public void delRecord(String tokenId) {
        if (ToolUtil.isEmpty((Object)(tokenId = tokenId.trim()))) {
            return;
        }
        String tokenValue = BaseSecurityUtil.getTokenValue();
        String tokenName = BaseSecurityUtil.getTokenName();
        TokenSession tokenSession = (TokenSession)HussarCacheUtil.get((String)HUSSAR_TOKEN, (Object)(HUSSAR_TOKEN + ":login:token-session:" + tokenValue));
        UserDetails userDetails = tokenSession.getUserDetails();
        String accessTokenId = userDetails.getAccessToken();
        if (ToolUtil.isNotEmpty((Object)accessTokenId) && accessTokenId.equals(tokenId)) {
            throw new BaseException("\u7ec8\u6b62\u5931\u8d25\uff01\uff08\u6240\u9009\u4f1a\u8bdd\u4e2d\u5305\u542b\u5f53\u524d\u4f1a\u8bdd\uff01\uff09");
        }
        boolean removeTokenResult = HussarSecurityUtils.revokeAccessToken((String)tokenId);
        if (!removeTokenResult) {
            this.iSysOnlineHistService.updateLogoffTime(tokenId);
        }
    }
}

