/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.onlinehist.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.permit.model.SysLoginUserIdentity;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ILocalHussarBaseUserIdentityService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.operations.onlinehist.model.SysOnlineHist;
import com.jxdinfo.hussar.operations.onlinehist.service.IAddOnlineHistoryService;
import com.jxdinfo.hussar.operations.onlinehist.service.ISysOnlineHistService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.operations.onlinehist.service.impl.addOnlineHistoryServiceImpl")
public class AddOnlineHistoryServiceImpl
implements IAddOnlineHistoryService {
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysOnlineHistService onlineHisService;
    @Resource
    private ILocalHussarBaseUserIdentityService hussarBaseUserIdentityService;

    @HussarDs(value="#connName")
    public void asyncAddOnlineHistory(String tokenId, Long userId, SysOnlineHist sysOnlineHist) {
        SysUsers sysUsers = this.sysUsersService.getById(userId);
        if (HussarUtils.isEmpty((Object)sysUsers)) {
            return;
        }
        SysLoginUserIdentity userIdentity = (SysLoginUserIdentity)this.hussarBaseUserIdentityService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysLoginUserIdentity::getUserId, (Object)userId));
        SysOrganVo dept = this.sysStruService.getOrgInfoByOrgId(userIdentity.getStruId());
        String deptName = "";
        if (ToolUtil.isNotEmpty((Object)dept) && ToolUtil.isNotEmpty((Object)dept.getOrganName())) {
            deptName = dept.getOrganName();
        }
        QueryWrapper sysOnlineHistQueryWrapper = new QueryWrapper();
        sysOnlineHistQueryWrapper.lambda().eq(SysOnlineHist::getTokenId, (Object)tokenId);
        List sysOnlineHistList = this.onlineHisService.list((Wrapper)sysOnlineHistQueryWrapper);
        if (ToolUtil.isEmpty((Object)sysOnlineHistList)) {
            sysOnlineHist.setTokenId(tokenId);
            sysOnlineHist.setUserId(sysUsers.getId());
            sysOnlineHist.setUserAccount(sysUsers.getUserAccount());
            sysOnlineHist.setUserName(sysUsers.getUserName());
            sysOnlineHist.setCorporationId(userIdentity.getStruId());
            sysOnlineHist.setCorporationName(deptName);
            sysOnlineHist.setLoginTime(LocalDateTime.now());
            this.onlineHisService.save((Object)sysOnlineHist);
        }
    }

    @HussarDs(value="#connName")
    public void asyncAddOnlineHistory(UserDetails userDetails, SysOnlineHist sysOnlineHist) {
        if (HussarUtils.isEmpty((Object)userDetails)) {
            return;
        }
        QueryWrapper sysOnlineHistQueryWrapper = new QueryWrapper();
        sysOnlineHistQueryWrapper.lambda().eq(SysOnlineHist::getTokenId, (Object)userDetails.getAccessToken());
        List sysOnlineHistList = this.onlineHisService.list((Wrapper)sysOnlineHistQueryWrapper);
        if (ToolUtil.isEmpty((Object)sysOnlineHistList)) {
            Map extendUserMap = userDetails.getExtendUserMap();
            sysOnlineHist.setTokenId(userDetails.getAccessToken());
            sysOnlineHist.setUserId(userDetails.getUserId());
            sysOnlineHist.setUserAccount((String)extendUserMap.get("account"));
            sysOnlineHist.setUserName(userDetails.getUserName());
            Object deptId = extendUserMap.get("deptId");
            if (HussarUtils.isNotEmpty(deptId)) {
                sysOnlineHist.setCorporationId(Long.valueOf(deptId.toString()));
            }
            sysOnlineHist.setCorporationName((String)extendUserMap.get("deptName"));
            sysOnlineHist.setLoginTime(LocalDateTime.now());
            this.onlineHisService.save((Object)sysOnlineHist);
        }
    }
}

