/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.system.license.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.CoreVersion;
import com.jxdinfo.hussar.common.constant.http.HttpCode;
import com.jxdinfo.hussar.common.exception.ApiException;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.Contact;
import com.jxdinfo.hussar.core.ContactInfomation;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import com.jxdinfo.hussar.core.util.SecurityUtil;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.secure.riskprotect.core.utils.XssChecker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/licenseFront"})
@Api(tags={"\u6388\u6743\u7ba1\u7406"})
public class LicenseFrontController {
    private static final String NO_LICENSE = "noLicense";
    private static final String ERROR_LICENSE = "errorLicense";
    private static final String NEED_LICENSE = "needLicense";
    private static final String NEED_WARNING = "needWarning";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String PROJECT_NAME = "projectName";
    private static final String MSG_SURPLUS = " < \u5269\u4f59\u53ef\u8bbf\u95ee\u6b21\u6570\uff1a";
    private static final String LICENSE_TYPE = "licenseType";
    private static final String DATE_FORMAT = "yyyy.MM.dd";

    @GetMapping(value={"/view"})
    @AuditLog(moduleName="\u7cfb\u7edf\u53c2\u6570", eventDesc="\u6388\u6743\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperation(value="\u6388\u6743\u4fe1\u606f", notes="\u6388\u6743\u4fe1\u606f")
    public ApiResponse<Map<String, Object>> index(@ApiParam(value="\u6388\u6743\u7c7b\u578b") @RequestParam(value="type", defaultValue="") String type) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(NO_LICENSE, false);
        dataMap.put(ERROR_LICENSE, false);
        dataMap.put(NEED_LICENSE, false);
        dataMap.put(NEED_WARNING, false);
        if ("1".equals(type)) {
            String appliCode = LicenseInfo.generateRequestSN();
            dataMap.put("requestSN", appliCode);
            if (null == appliCode || "".equals(appliCode) || appliCode.length() < 20) {
                dataMap.put(ERROR_LICENSE, true);
            } else {
                dataMap.put(NO_LICENSE, true);
            }
        } else if (this.isLicenseValid()) {
            dataMap.put(START_DATE, DateUtil.format((Date)LicenseInfo.getStartDate(), (String)"yyyy-MM-dd"));
            dataMap.put(END_DATE, DateUtil.format((Date)LicenseInfo.getEndDate(), (String)"yyyy-MM-dd"));
            Integer licenseType = LicenseInfo.getLicenseType();
            dataMap.put(PROJECT_NAME, LicenseInfo.getProjectName());
            if (licenseType == 0) {
                dataMap.put(PROJECT_NAME, LicenseInfo.getProjectName());
                dataMap.put(LICENSE_TYPE, "\u5f00\u53d1\u73af\u5883\u6388\u6743");
                dataMap.put(NEED_LICENSE, true);
            } else if (licenseType == 1) {
                dataMap.put(LICENSE_TYPE, "\u90e8\u7f72\u6388\u6743");
                this.putTips(dataMap);
            } else if (licenseType == 2) {
                dataMap.put(LICENSE_TYPE, "VOL\u6279\u91cf\u6388\u6743");
            } else if (licenseType == 3) {
                dataMap.put(PROJECT_NAME, LicenseInfo.getProjectName());
                dataMap.put(LICENSE_TYPE, "\u5f00\u53d1\u8005\u6388\u6743");
                this.putTips(dataMap);
            } else if (licenseType == 5) {
                dataMap.put(LICENSE_TYPE, "\u6b63\u5f0f\u6388\u6743");
                dataMap.put(END_DATE, "\u4e0d\u9650");
            } else {
                dataMap.put(PROJECT_NAME, LicenseInfo.getProjectName());
                dataMap.put(LICENSE_TYPE, "\u8bd5\u7528\u73af\u5883\u6388\u6743");
            }
            dataMap.put("hasLicense", true);
        } else {
            String appliCode = LicenseInfo.generateRequestSN();
            dataMap.put("requestSN", appliCode);
            if (null == appliCode || "".equals(appliCode) || appliCode.length() < 20) {
                dataMap.put(ERROR_LICENSE, true);
            } else {
                dataMap.put(NO_LICENSE, true);
            }
        }
        return ApiResponse.success(dataMap);
    }

    @PostMapping(value={"/upload"})
    @ApiOperation(value="\u6388\u6743\u6587\u4ef6\u4e0a\u4f20", notes="\u6388\u6743\u6587\u4ef6\u4e0a\u4f20")
    @ResponseBody
    public ApiResponse<Object> uploadLicenseFile(@ApiParam(value="\u6388\u6743\u6587\u4ef6") @RequestPart(value="file") MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (!StringUtils.isEmpty((CharSequence)XssChecker.checkXss((String)fileName))) {
            throw new ApiException(HttpCode.BAD_REQUEST.value().intValue(), "invalid request , xss code:" + fileName);
        }
        if (!CoreVersion.licFileName.equals(fileName)) {
            throw new BaseException("\u8be5\u6388\u6743\u6587\u4ef6\u65e0\u6548\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u540d\u662f\u5426\u6b63\u786e\uff01");
        }
        try {
            file.transferTo(new File(LicenseInfo.getUploadPath() + CoreVersion.licFileName));
        }
        catch (IOException e) {
            throw new BaseException(BizExceptionEnum.UPLOAD_ERROR.getMessage());
        }
        if (this.checkLicense()) {
            this.updateLicense();
            return ApiResponse.success((Object)HttpCode.OK.value(), (String)"\u6388\u6743\u6210\u529f\uff01");
        }
        throw new BaseException("\u8be5\u6388\u6743\u6587\u4ef6\u65e0\u6548\uff01");
    }

    @PostMapping(value={"/check"})
    @ApiOperation(value="\u6388\u6743\u68c0\u67e5", notes="\u6388\u6743\u68c0\u67e5")
    @ResponseBody
    @Inner
    public ApiResponse<Object> check() {
        boolean isTrial = SecurityUtil.isTrial();
        if (isTrial) {
            JSONObject json = new JSONObject();
            json.put(START_DATE, (Object)DateUtil.format((Date)LicenseInfo.getStartDate(), (String)DATE_FORMAT));
            json.put(END_DATE, (Object)DateUtil.format((Date)LicenseInfo.getEndDate(), (String)DATE_FORMAT));
            json.put("limit", (Object)LicenseInfo.getRequestLimit());
            throw new BaseException(json.toJSONString());
        }
        JSONObject json = new JSONObject();
        json.put("message", (Object)("\u6388\u6743\u5c06\u5728" + DateUtil.format((Date)LicenseInfo.getEndDate(), (String)DATE_FORMAT) + "\u8fc7\u671f\uff0c\u8bf7\u5c3d\u5feb\u7533\u8bf7\u6388\u6743"));
        if (LicenseInfo.nearEndDateWarning()) {
            json.put("days", (Object)"7");
            throw new BaseException(json.toJSONString());
        }
        if (LicenseInfo.needWarning()) {
            json.put("days", (Object)"30");
            throw new BaseException(json.toJSONString());
        }
        return ApiResponse.success((Object)HttpCode.OK.value(), (String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    private boolean isLicenseValid() {
        return LicenseInfo.isLicenseValidity();
    }

    private boolean checkLicense() {
        return LicenseInfo.checkLicense();
    }

    private void updateLicense() {
        LicenseInfo.update();
    }

    private void putTips(Map<String, Object> dataMap) {
        if (LicenseInfo.nearEndDateWarning()) {
            dataMap.put(NEED_WARNING, true);
            dataMap.put(NEED_LICENSE, true);
        } else if (LicenseInfo.needWarning()) {
            dataMap.put(NEED_LICENSE, true);
        }
    }

    @GetMapping(value={"/contact"})
    @ApiOperation(value="\u552e\u524d\u652f\u6301\u83b7\u53d6\u8054\u7cfb\u4eba", notes="\u552e\u524d\u652f\u6301\u83b7\u53d6\u8054\u7cfb\u4eba")
    public ApiResponse<List<Contact>> list() {
        List contactList = ContactInfomation.getContactInfo();
        return ApiResponse.success((Object)contactList);
    }
}

