/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.sqlmonitor.controller;

import com.jxdinfo.hussar.common.properties.ConnectionPoolProperties;
import com.jxdinfo.hussar.operations.sqlmonitor.service.ISqlMonitorService;
import com.jxdinfo.hussar.operations.sqlmonitor.vo.SqlMonitorVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sqlMonitorFront"})
@Api(tags={"\u6162SQL\u7ba1\u7406"})
public class SqlMonitorFrontController {
    @Autowired
    private ISqlMonitorService iSqlMonitorService;
    @Autowired
    private ConnectionPoolProperties connectionPoolProperties;

    @GetMapping(value={"/getList"})
    @ApiOperation(value="\u6162SQL\u76d1\u63a7\u5217\u8868", notes="\u67e5\u770b\u5217\u8868\u8be6\u7ec6\u4fe1\u606f")
    @AuditLog(moduleName="\u6162SQL\u7ba1\u7406", eventDesc="\u67e5\u8be2\u6162SQL\u76d1\u63a7\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"sqlMonitorFront:getList"})
    public ApiResponse<Object> list(@ApiParam(value="\u6162SQL\u76d1\u63a7VO") SqlMonitorVo sqlMonitorVo) {
        String orderBy = sqlMonitorVo.getOrderBy() == null ? null : sqlMonitorVo.getOrderBy();
        String orderType = sqlMonitorVo.getOrderType() == null ? null : sqlMonitorVo.getOrderType();
        String page = sqlMonitorVo.getPage() == null ? null : sqlMonitorVo.getPage();
        String perPageCount = sqlMonitorVo.getPerPageCount() == null ? null : sqlMonitorVo.getPerPageCount();
        HashMap<String, String> map = new HashMap<String, String>();
        if (null == orderBy) {
            orderBy = "MaxTimespan";
        }
        if (null == orderType) {
            orderType = "desc";
        }
        map.put("orderBy", orderBy);
        map.put("orderType", orderType);
        map.put("page", page);
        map.put("perPageCount", perPageCount);
        Map result = this.iSqlMonitorService.getList(map);
        int slowSqlMillis = this.connectionPoolProperties.getSlowSqlMillis();
        result.put("slowSqlMillis", slowSqlMillis);
        return ApiResponse.success((Object)result);
    }
}

