/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.system.cache.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.operations.system.cache.dto.EhcacheDto;
import com.jxdinfo.hussar.operations.system.cache.service.EhcacheService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.IResultCode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

@Service
public class EhcacheServiceImpl
implements EhcacheService {
    @Resource
    private CacheManager hussarCacheManager;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;

    public IPage<Object> queryCacheTableListForPw(Page page, EhcacheDto ehcacheDto) {
        if (ToolUtil.isEmpty((Object)page)) {
            throw new BaseException("\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String pageNum = String.valueOf(page.getCurrent());
        String limitNum = String.valueOf(page.getSize());
        String cacheName = ehcacheDto.getCacheName();
        List keyList = HussarCacheUtil.getKeysLike((String)cacheName, (String)"?");
        ArrayList records = new ArrayList();
        keyList.forEach(o -> records.add(HussarCacheUtil.get((String)cacheName, (Object)o)));
        ArrayList list = new ArrayList();
        for (int i = 0; i < records.size(); ++i) {
            Object object;
            String jsonStr;
            Map obMap;
            if (i < (Integer.parseInt(pageNum) - 1) * Integer.parseInt(limitNum) || i >= Integer.parseInt(pageNum) * Integer.parseInt(limitNum) || !ToolUtil.isNotEmpty((obMap = (Map)JSON.parseObject((String)(jsonStr = JSON.toJSONString(object = records.get(i))), Map.class)).get("expireTime"))) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("key", obMap.get("userid").toString());
            map.put("value", jsonStr);
            list.add(map);
        }
        page.setRecords(list);
        page.setTotal((long)records.size());
        return page;
    }

    public ApiResponse deleteByKeys(EhcacheDto ehcacheDto) {
        String cacheName = ehcacheDto.getCacheName().trim();
        String keys = ehcacheDto.getKeys().trim();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{cacheName, keys})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u4e0d\u80fd\u5220\u9664");
        }
        JSONArray arr = JSON.parseArray((String)keys);
        ArrayList<String> accountList = new ArrayList<String>();
        for (Object obj : arr) {
            String account = obj.toString();
            accountList.add(account);
        }
        for (Object key : arr) {
            String keyStr = String.valueOf(key);
            HussarCacheUtil.evictKeysLike((String)cacheName, (String)keyStr);
        }
        ISysUsersService iSysUsersService = (ISysUsersService)SpringContextHolder.getBean(ISysUsersService.class);
        iSysUsersService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode())).in(SysUsers::getUserAccount, accountList)).eq(SysUsers::getAccountStatus, (Object)UserStatus.PWD_LOCK.getCode()));
        return ApiResponse.success((IResultCode)ResultCode.SUCCESS);
    }
}

