/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.sqlmonitor.service.impl;

import com.alibaba.druid.spring.boot.autoconfigure.properties.DruidStatProperties;
import com.alibaba.druid.stat.DruidStatManagerFacade;
import com.alibaba.druid.util.MapComparator;
import com.jxdinfo.hussar.common.properties.ConnectionPoolProperties;
import com.jxdinfo.hussar.operations.sqlmonitor.service.ISqlMonitorService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SqlMonitorServiceImpl
implements ISqlMonitorService {
    @Autowired
    private ConnectionPoolProperties connectionPoolProperties;
    @Resource
    private DruidStatProperties druidStatProperties;
    @Resource
    private Environment environment;

    private void init() {
        try {
            this.connectionPoolProperties.setInUse(this.druidStatProperties.getStatViewServlet().isEnabled());
            this.connectionPoolProperties.setNeedLogin(false);
            String connectionProperties = this.environment.getProperty("spring.datasource.dynamic.druid.connectionProperties");
            if (HussarUtils.isNotBlank((CharSequence)connectionProperties)) {
                String[] arr;
                for (String s : arr = connectionProperties.split(";")) {
                    if (s.contains("druid.stat.mergeSql")) {
                        if (s.contains("true") || s.contains("TRUE")) {
                            this.connectionPoolProperties.setMergeSql(true);
                        } else {
                            this.connectionPoolProperties.setMergeSql(false);
                        }
                    }
                    if (!s.contains("druid.stat.slowSqlMillis")) continue;
                    this.connectionPoolProperties.setSlowSqlMillis(Integer.parseInt(s.split("=")[1]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> getList(Map<String, String> parameters) {
        this.init();
        DruidStatManagerFacade instance = DruidStatManagerFacade.getInstance();
        String connName = HussarContextHolder.getConnName();
        Object druidDataSourceByName = instance.getDruidDataSourceByName(connName);
        List array = DruidStatManagerFacade.getInstance().getSqlStatDataList(druidDataSourceByName);
        for (int i = array.size() - 1; i >= 0; --i) {
            String maxTimespan;
            Map objectMap = (Map)array.get(i);
            int slowSqlMillis = this.connectionPoolProperties.getSlowSqlMillis();
            if (slowSqlMillis <= Integer.parseInt(maxTimespan = objectMap.get("MaxTimespan").toString())) continue;
            array.remove(i);
        }
        int size = array.size();
        List<Map<String, Object>> sortedArray = this.comparatorOrderBy(array, parameters);
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("count", size);
        map.put("data", sortedArray);
        map.put("code", 0);
        map.put("msg", "success");
        return map;
    }

    private List<Map<String, Object>> comparatorOrderBy(List<Map<String, Object>> array, Map<String, String> parameters) {
        if (array != null && !array.isEmpty()) {
            String orderBy;
            String orderType = null;
            Integer page = 1;
            Integer perPageCount = Integer.MAX_VALUE;
            if (parameters == null) {
                orderBy = "SQL";
                orderType = "asc";
                page = 1;
                perPageCount = Integer.MAX_VALUE;
            } else {
                String pageCountParam;
                orderBy = parameters.get("orderBy");
                orderType = parameters.get("orderType");
                String pageParam = parameters.get("page");
                if (pageParam != null && pageParam.length() != 0) {
                    page = Integer.parseInt(pageParam);
                }
                if ((pageCountParam = parameters.get("perPageCount")) != null && pageCountParam.length() > 0) {
                    perPageCount = Integer.parseInt(pageCountParam);
                }
            }
            orderBy = orderBy == null ? "SQL" : orderBy;
            String string = orderType = orderType == null ? "asc" : orderType;
            if (!"desc".equals(orderType)) {
                orderType = "asc";
            }
            if (orderBy.trim().length() != 0) {
                Collections.sort(array, new MapComparator((Object)orderBy, "desc".equals(orderType)));
            }
            int fromIndex = (page - 1) * perPageCount;
            int toIndex = page * perPageCount;
            if (toIndex > array.size()) {
                toIndex = array.size();
            }
            return array.subList(fromIndex, toIndex);
        }
        return new ArrayList<Map<String, Object>>();
    }
}

