/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.monitor.service.impl;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.model.UserEnvPort;
import com.jxdinfo.hussar.application.service.IUserEnvPortService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.operations.monitor.ServerInfo;
import com.jxdinfo.hussar.operations.monitor.service.MyClient;
import com.jxdinfo.hussar.operations.monitor.util.DateUtils;
import com.jxdinfo.hussar.operations.monitor.vo.EnvVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.operations.monitor.service.impl.RemoteMonitorServiceImpl")
public class RemoteMonitorServiceImpl {
    @Autowired
    private MyClient myClient;
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    @Lazy
    private NacosDiscoveryProperties discoveryProperties;
    @Autowired
    private IUserEnvPortService userEnvPortService;
    @Autowired
    private ISysUsersService sysUsersService;

    public ApiResponse<ServerInfo> getInfo(String myURL, String Authorization) {
        myURL = this.getUrl(myURL);
        return this.myClient.getMonitorInfo(myURL, Authorization);
    }

    public ApiResponse<Page<ServerInfo>> getAll(String authorization, int pageNo, int pageSize) {
        String serviceName = "hussar-deploy";
        List services = this.discoveryClient.getServices();
        Page page = new Page((long)pageNo, (long)pageSize);
        if (StringUtils.isNotBlank((CharSequence)serviceName)) {
            services = services.stream().filter(item -> item.contains(serviceName)).collect(Collectors.toList());
        }
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<ServerInfo> serverInfos = new ArrayList<ServerInfo>();
        int count = 0;
        count = services.size();
        if (HussarUtils.isNotEmpty(services)) {
            for (String servcie : services) {
                int ipCount = 0;
                int healthyInstanceCount = 0;
                try {
                    List instances = this.discoveryProperties.namingServiceInstance().getAllInstances(servcie);
                    ipCount = instances.size();
                    if (ipCount > 0) {
                        for (Instance instance : instances) {
                            if (!instance.isHealthy()) continue;
                            ++healthyInstanceCount;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                page.setTotal((long)healthyInstanceCount);
            }
        }
        if (count > 0) {
            List subListServices;
            int fromIndex = (pageNo - 1) * pageSize;
            int toIndex = pageNo * pageSize;
            if (toIndex > count) {
                toIndex = count;
            }
            if (HussarUtils.isNotEmpty(subListServices = services.subList(fromIndex, toIndex))) {
                for (String servcie : subListServices) {
                    int ipCount = 0;
                    try {
                        List instances = this.discoveryProperties.namingServiceInstance().getAllInstances(servcie);
                        ipCount = instances.size();
                        if (ipCount <= 0) continue;
                        for (Instance instance : instances) {
                            if (!instance.isHealthy()) continue;
                            result.add(instance.getIp() + ":" + instance.getPort());
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                for (String url : result) {
                    ServerInfo serverInfo = (ServerInfo)this.myClient.getMonitorInfo(url, authorization).getData();
                    if (serverInfo.getSysFiles().isEmpty()) continue;
                    serverInfos.add(serverInfo);
                }
            }
            page.setRecords(serverInfos);
        }
        return ApiResponse.success((Object)page);
    }

    @HussarDs(value="#connName")
    public void getDnv(String connName, Long tenantAdminId, EnvVo envVo, List<EnvVo> envVos) {
        SecurityUser user = BaseSecurityUtil.getUser();
        this.getNacosEnvPort(envVo);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserEnvPort::getUserId, (Object)envVo.getCreatorId());
        try {
            UserEnvPort userEnvPort = (UserEnvPort)this.userEnvPortService.getOne((Wrapper)wrapper);
            if (ToolUtil.isNotEmpty((Object)userEnvPort)) {
                SysUsers sysUsers = this.sysUsersService.getById(userEnvPort.getUserId());
                envVo.setCreator(sysUsers.getUserName());
                envVo.setRunTime(DateUtils.getDatePoor((Date)DateUtils.getNowDate(), (Date)Date.from(userEnvPort.getStartTime().atZone(ZoneId.systemDefault()).toInstant())));
                envVo.setBackPort(userEnvPort.getBackPort());
                envVo.setFrontPort(userEnvPort.getFrontPort());
                if (HussarUtils.equals((Object)user.getId(), (Object)SysUserAndRole.SUPERADMIN.getValue())) {
                    if (Date.from(userEnvPort.getStartTime().atZone(ZoneId.systemDefault()).toInstant()).compareTo(DateUtils.getNowDate()) < 0) {
                        envVos.add(envVo);
                    }
                } else if (HussarUtils.equals((Object)user.getId(), (Object)userEnvPort.getUserId()) && Date.from(userEnvPort.getStartTime().atZone(ZoneId.systemDefault()).toInstant()).compareTo(DateUtils.getNowDate()) < 0) {
                    envVos.add(envVo);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ApiResponse<Boolean> stopEnv(Integer backPort, Integer frontPort, String ip, String Authorization) {
        ip = this.getUrl(ip);
        this.myClient.stopEnvService(ip, Authorization, backPort, frontPort);
        return ApiResponse.success();
    }

    public void getNacosEnvPort(EnvVo envVo) {
        String frontMain = "front-main";
        String hussarTlexample = "hussar-tlExample";
        List services = this.discoveryClient.getServices();
        if (HussarUtils.isNotEmpty(services = services.stream().filter(item -> item.contains(frontMain) || item.contains(hussarTlexample)).collect(Collectors.toList()))) {
            for (String servcie : services) {
                int ipCount = 0;
                try {
                    List instances = this.discoveryProperties.namingServiceInstance().getAllInstances(servcie);
                    ipCount = instances.size();
                    if (ipCount <= 0) continue;
                    for (Instance instance : instances) {
                        if (!instance.isHealthy() || !((String)instance.getMetadata().get("Tcode")).equals(envVo.getTenantCode())) continue;
                        envVo.setCreatorId((String)instance.getMetadata().get("Dev-User"));
                        envVo.setIp(instance.getIp());
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }

    public String getUrl(String myURL) {
        String serviceName = "hussar-deploy";
        List services = this.discoveryClient.getServices();
        if (StringUtils.isNotBlank((CharSequence)serviceName)) {
            services = services.stream().filter(item -> item.contains(serviceName)).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty((Object)services)) {
            for (String servcie : services) {
                try {
                    List instances = this.discoveryProperties.namingServiceInstance().getAllInstances(servcie);
                    for (Instance instance : instances) {
                        if (!instance.getIp().equals(myURL)) continue;
                        myURL = myURL + ":" + instance.getPort();
                        return myURL;
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        return myURL;
    }
}

