/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.monitor.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.service.IUserDevEnvService;
import com.jxdinfo.hussar.operations.monitor.ServerInfo;
import com.jxdinfo.hussar.operations.monitor.service.impl.RemoteMonitorServiceImpl;
import com.jxdinfo.hussar.operations.monitor.vo.EnvVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/remoteMonitor"})
@Api(tags={"\u8fdc\u7a0b\u7cfb\u7edf\u76d1\u63a7\u7ba1\u7406"})
public class RemoteMonitorController {
    @Autowired
    private RemoteMonitorServiceImpl remoteMonitorService;
    @Autowired
    private IUserDevEnvService userDevEnvService;
    @Autowired
    private ISysTenantService sysTenantService;

    @GetMapping(value={"/getinfo"})
    @ApiOperation(value="\u8fdc\u7a0b\u7cfb\u7edf\u76d1\u63a7", notes="\u8fdc\u7a0b\u7cfb\u7edf\u76d1\u63a7")
    @AuditLog(moduleName="\u8fdc\u7a0b\u7cfb\u7edf\u76d1\u63a7", eventDesc="\u8fdc\u7a0b\u7cfb\u7edf\u76d1\u63a7", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<ServerInfo> getInfo(@RequestParam(value="host") String myURL, @RequestParam(value="Authorization") String Authorization) {
        return this.remoteMonitorService.getInfo(myURL, Authorization);
    }

    @GetMapping(value={"/getAll"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u670d\u52a1\u5668\u8d44\u6e90", notes="\u67e5\u8be2\u6240\u6709\u670d\u52a1\u5668\u8d44\u6e90")
    @AuditLog(moduleName="\u67e5\u8be2\u6240\u6709\u670d\u52a1\u5668\u8d44\u6e90", eventDesc="\u67e5\u8be2\u6240\u6709\u670d\u52a1\u5668\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<ServerInfo>> getAll(@RequestParam(value="Authorization") String authorization, @RequestParam(value="current") int pageNo, @RequestParam(value="size") int pageSize) {
        return this.remoteMonitorService.getAll(authorization, pageNo, pageSize);
    }

    @GetMapping(value={"/getAllEnv"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5df2\u542f\u52a8\u7684\u73af\u5883\u5b9e\u4f8b", notes="\u67e5\u8be2\u6240\u6709\u5df2\u542f\u52a8\u7684\u73af\u5883\u5b9e\u4f8b")
    @AuditLog(moduleName="\u67e5\u8be2\u6240\u6709\u5df2\u542f\u52a8\u7684\u73af\u5883\u5b9e\u4f8b", eventDesc="\u67e5\u8be2\u6240\u6709\u5df2\u542f\u52a8\u7684\u73af\u5883\u5b9e\u4f8b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<EnvVo>> getAllEnv(@RequestParam(value="projectName") String projectName, @RequestParam(value="current") int pageNo, @RequestParam(value="size") int pageSize) {
        Page page = new Page((long)pageNo, (long)pageSize);
        LambdaQueryWrapper wrapper = StringUtils.isNotBlank((CharSequence)projectName) ? (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysTenant::getTenantStatus, (Object)"0")).like(SysTenant::getTenantName, (Object)projectName) : (LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysTenant::getTenantStatus, (Object)"0");
        List list = this.sysTenantService.list((Wrapper)wrapper);
        ArrayList<EnvVo> envVos = new ArrayList<EnvVo>();
        for (SysTenant sysTenant : list) {
            EnvVo envVo = new EnvVo();
            envVo.settName(sysTenant.getTenantName());
            envVo.setTenantCode(sysTenant.getTenantCode());
            this.remoteMonitorService.getDnv(sysTenant.getConnName(), sysTenant.getTenantAdminId(), envVo, envVos);
        }
        page.setRecords(envVos);
        page.setTotal((long)envVos.size());
        return ApiResponse.success((Object)page);
    }

    @GetMapping(value={"/stopEnv"})
    @ApiOperation(value="\u505c\u6b62\u73af\u5883\u5b9e\u4f8b", notes="\u505c\u6b62\u73af\u5883\u5b9e\u4f8b")
    @AuditLog(moduleName="\u505c\u6b62\u73af\u5883\u5b9e\u4f8b", eventDesc="\u505c\u6b62\u73af\u5883\u5b9e\u4f8b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> stopEnv(@RequestParam(value="frontPort") Integer frontPort, @RequestParam(value="backPort") Integer backPort, @RequestParam(value="ip") String ip, @RequestParam(value="Authorization") String Authorization) {
        return this.remoteMonitorService.stopEnv(backPort, frontPort, ip, Authorization);
    }
}

