/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.operations.onlinehist.model.SysOnlineHist;
import com.jxdinfo.hussar.operations.onlinehist.service.ISysOnlineHistService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.support.properties.HussarSecurityProperties;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BaseDbSyncUserCache
implements BasicProcessor {
    private static Logger LOGGER = LoggerFactory.getLogger(BaseDbSyncUserCache.class);
    private ISysOnlineHistService sysOnlineHistService = (ISysOnlineHistService)SpringContextHolder.getBean(ISysOnlineHistService.class);
    private HussarSecurityProperties securityProperties = (HussarSecurityProperties)SpringContextHolder.getBean(HussarSecurityProperties.class);

    public ProcessResult process(TaskContext context) throws Exception {
        LOGGER.debug("\u6570\u636e\u5e93\u548c\u7f13\u5b58\u540c\u6b65");
        QueryWrapper sysOnlineHistQueryWrapper = new QueryWrapper();
        sysOnlineHistQueryWrapper.lambda().isNull(SysOnlineHist::getLogoffTime);
        List list = this.sysOnlineHistService.list((Wrapper)sysOnlineHistQueryWrapper);
        String cacheName = this.securityProperties.getTokenName();
        String key = cacheName + ":oauth2:access-token:";
        List tokens = HussarFixedCacheUtil.getKeysRightLike((String)cacheName, (String)key);
        if (CollectionUtils.isNotEmpty((Collection)tokens)) {
            List filters = tokens.stream().map(item -> item.replace(key, "")).collect(Collectors.toList());
            filters = filters.stream().map(item -> item.replace(cacheName + "::", "")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (SysOnlineHist sysOnlineHist : list) {
                    if (filters.contains(sysOnlineHist.getTokenId())) {
                        sysOnlineHist.setLogoffTime(null);
                        continue;
                    }
                    if (sysOnlineHist.getLogoffTime() != null) continue;
                    sysOnlineHist.setLogoffTime(LocalDateTime.now());
                }
                if (HussarUtils.isNotEmpty((Object)list)) {
                    this.sysOnlineHistService.updateBatchById((Collection)list);
                }
            }
        } else {
            list.forEach(o -> o.setLogoffTime(LocalDateTime.now()));
            if (HussarUtils.isNotEmpty((Object)list)) {
                this.sysOnlineHistService.updateBatchById((Collection)list);
            }
        }
        return new ProcessResult(true, "success");
    }
}

