/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.system.cache.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.operations.system.cache.dto.EhcacheDto;
import com.jxdinfo.hussar.operations.system.cache.service.CacheService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.IResultCode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CacheServiceImpl
implements CacheService {
    private static final String LOINLOCK = "Login_Lock";
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;

    public IPage<Object> queryCacheTableListForPw(Page page, EhcacheDto ehcacheDto, boolean flag) {
        if (ToolUtil.isEmpty((Object)page)) {
            throw new BaseException("\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String pageNum = String.valueOf(page.getCurrent());
        String limitNum = String.valueOf(page.getSize());
        String cacheName = LOINLOCK;
        if (flag) {
            cacheName = ehcacheDto.getCacheName();
        }
        List keyList = HussarCacheUtil.getKeysLike((String)cacheName, (String)"?");
        ArrayList records = new ArrayList();
        String finalCacheName = cacheName;
        if (CollectionUtils.isNotEmpty((Collection)keyList)) {
            keyList.forEach(o -> {
                String key = o;
                Object o1 = HussarCacheUtil.get((String)finalCacheName, (Object)key);
                if (Objects.isNull(o1)) {
                    HussarCacheUtil.evictKeysLike((String)finalCacheName, (String)key);
                } else {
                    records.add(o1);
                }
            });
        }
        ArrayList recordsFilter = new ArrayList();
        String userName = ehcacheDto.getUserName();
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            for (Object record : records) {
                String jsonStr = JSON.toJSONStringWithDateFormat(record, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
                JSONObject jsonObject = JSON.parseObject((String)jsonStr);
                if (!jsonObject.getString("userName").contains(userName)) continue;
                recordsFilter.add(record);
            }
        } else {
            recordsFilter.addAll(records);
        }
        ArrayList list = new ArrayList();
        if (CollectionUtils.isNotEmpty(recordsFilter)) {
            for (int i = 0; i < recordsFilter.size(); ++i) {
                Object object;
                if (i < (Integer.parseInt(pageNum) - 1) * Integer.parseInt(limitNum) || i >= Integer.parseInt(pageNum) * Integer.parseInt(limitNum) || Objects.isNull(object = recordsFilter.get(i))) continue;
                String jsonStr = JSON.toJSONStringWithDateFormat(object, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("key", ((Map)JSON.parseObject((String)jsonStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0])).get("userid").toString());
                map.put("value", jsonStr);
                list.add(map);
            }
        }
        page.setRecords(list);
        page.setTotal((long)list.size());
        return page;
    }

    public ApiResponse<Object> deleteByKeys(EhcacheDto ehcacheDto) {
        String cacheName = LOINLOCK;
        String keys = ehcacheDto.getKeys().trim();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{cacheName, keys})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u4e0d\u80fd\u5220\u9664");
        }
        JSONArray arr = JSON.parseArray((String)keys);
        for (Object key : arr) {
            String keyStr = String.valueOf(key);
            HussarCacheUtil.evictKeysLike((String)cacheName, (String)keyStr);
        }
        return ApiResponse.success((IResultCode)ResultCode.SUCCESS);
    }
}

