/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.redis.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.IResultCode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="hussar.cache", name={"cacheType"}, havingValue="redis", matchIfMissing=false)
public class RedisServiceInewmpl {
    private static final String LOINLOCK = "Login_Lock";
    @Value(value="${global.tenant-open:false}")
    private boolean isTenantOpen;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;

    public List<Map<Object, Object>> getKeyAndValues(String key) {
        List keyList = HussarCacheUtil.getKeysLike((String)LOINLOCK, (String)"?");
        ArrayList records = new ArrayList();
        keyList.forEach(o -> {
            String keys = o.substring(0, o.indexOf("::"));
            String str2 = o.substring(keys.length() + 2);
            records.add(HussarCacheUtil.get((String)LOINLOCK, (Object)str2));
        });
        ArrayList<Map<Object, Object>> list = new ArrayList<Map<Object, Object>>();
        for (int i = 0; i < records.size(); ++i) {
            Object object = records.get(i);
            String jsonStr = JSON.toJSONString(object);
            Map obMap = (Map)JSON.parseObject((String)jsonStr, Map.class);
            if (!ToolUtil.isNotEmpty(obMap.get("expireTime"))) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("key", obMap.get("userid").toString());
            map.put("value", jsonStr);
            list.add(map);
        }
        return list;
    }

    public ApiResponse deleteNoSQLKeys(String[] strarr) {
        ArrayList<String> accountList = new ArrayList<String>();
        String connName = this.dynamicDataSourceService.currentDsName();
        if (this.hussarBaseProperties.isTenantOpen()) {
            for (String obj : strarr) {
                String accountKey = obj.toString();
                if (!ToolUtil.isNotEmpty((Object)accountKey)) continue;
                String account = accountKey.replace("-", "").replace(connName, "");
                accountList.add(account);
            }
        } else {
            for (String obj : strarr) {
                String account = obj.toString();
                accountList.add(account);
            }
        }
        for (String key : strarr) {
            String keyStr = String.valueOf(key);
            HussarCacheUtil.evictKeysLike((String)LOINLOCK, (String)keyStr);
        }
        ISysUsersService iSysUsersService = (ISysUsersService)SpringContextHolder.getBean(ISysUsersService.class);
        iSysUsersService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode())).in(SysUsers::getUserAccount, accountList)).eq(SysUsers::getAccountStatus, (Object)UserStatus.PWD_LOCK.getCode()));
        return ApiResponse.success((IResultCode)ResultCode.SUCCESS);
    }
}

