/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.initaction;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.properties.HussarSecurityProperties;
import com.jxdinfo.hussar.operations.onlinehist.model.SysOnlineHist;
import com.jxdinfo.hussar.operations.onlinehist.service.ISysOnlineHistService;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StartEventService {
    @Autowired
    private ISysOnlineHistService sysOnlineHistService;
    @Autowired
    private HussarSecurityProperties securityProperties;
    private static Logger LOGGER = LoggerFactory.getLogger(StartEventService.class);

    public void test() {
        LOGGER.debug("\u6570\u636e\u5e93\u548c\u7f13\u5b58\u540c\u6b65");
        QueryWrapper sysOnlineHistQueryWrapper = new QueryWrapper();
        sysOnlineHistQueryWrapper.lambda().isNull(SysOnlineHist::getLogoffTime);
        List list = this.sysOnlineHistService.list((Wrapper)sysOnlineHistQueryWrapper);
        String cacheName = this.securityProperties.getTokenName();
        String key = cacheName + ":oauth2:access-token:";
        if (StringUtils.isBlank((CharSequence)cacheName)) {
            return;
        }
        List tokens = HussarCacheUtil.getKeysRightLike((String)cacheName, (String)key);
        if (CollectionUtils.isNotEmpty((Collection)tokens)) {
            List filters = tokens.stream().map(item -> item.replace(key, "")).collect(Collectors.toList());
            filters = filters.stream().map(item -> item.replace(cacheName + "::", "")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (SysOnlineHist sysOnlineHist : list) {
                    if (filters.contains(sysOnlineHist.getTokenId())) {
                        sysOnlineHist.setLogoffTime(null);
                        continue;
                    }
                    if (sysOnlineHist.getLogoffTime() != null) continue;
                    sysOnlineHist.setLogoffTime(LocalDateTime.now());
                }
                this.sysOnlineHistService.updateBatchById((Collection)list);
            }
        } else {
            list.forEach(o -> o.setLogoffTime(LocalDateTime.now()));
            this.sysOnlineHistService.updateBatchById((Collection)list);
        }
    }
}

