/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.system.cache.manager.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.operations.system.cache.manager.QueryFreezeSecureManager;
import com.jxdinfo.hussar.operations.system.cache.vo.FreezeSecureVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.operations.system.cache.manager.impl.queryFreezeSecureManagerImpl")
public class QueryFreezeSecureManagerImpl
implements QueryFreezeSecureManager {
    @Override
    public List<FreezeSecureVo> getFreezeList(String name) {
        List<Object> result = new ArrayList<FreezeSecureVo>();
        List<FreezeSecureVo> data = this.getRealData(name);
        if (HussarUtils.isNotEmpty(data)) {
            result = data.stream().sorted(Comparator.comparing(FreezeSecureVo::getLockTime, Comparator.nullsLast(LocalDateTime::compareTo).reversed()).thenComparing(Comparator.comparing(FreezeSecureVo::getUserid))).filter(item -> HussarUtils.isNotEmpty((Object)item.getLockTime())).collect(Collectors.toList());
        }
        return result;
    }

    private List<FreezeSecureVo> getRealData(String name) {
        String cacheName = "Login_Lock";
        List keyList = HussarCacheUtil.getKeysLike((String)cacheName, (String)"?");
        ArrayList<FreezeSecureVo> records = new ArrayList<FreezeSecureVo>();
        String finalCacheName = cacheName;
        if (HussarUtils.isNotEmpty((Object)keyList)) {
            keyList.forEach(key -> {
                Object obj = HussarCacheUtil.get((String)finalCacheName, (Object)key);
                if (HussarUtils.isNull((Object)obj)) {
                    HussarCacheUtil.evictKeysLike((String)finalCacheName, (String)key);
                } else {
                    FreezeSecureVo vo = (FreezeSecureVo)JSON.parseObject((String)JSON.toJSONString((Object)HussarCacheUtil.get((String)finalCacheName, (Object)key)), FreezeSecureVo.class);
                    if (HussarUtils.isNotEmpty((Object)name)) {
                        if (vo.getUserName().contains(name)) {
                            records.add(vo);
                        }
                    } else {
                        records.add(vo);
                    }
                }
            });
        }
        return records;
    }
}

