/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.qrcode;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.core.utils.QRCodeUtil;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import com.jxdinfo.hussar.core.util.SecurityUtil;
import com.jxdinfo.hussar.operations.system.version.model.FrameworkVersion;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/qrcode"})
@Api(tags={"\u751f\u6210\u4e8c\u7ef4\u7801"})
public class QRcodeController {
    @Autowired
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    private static final String logoImgBase64 = "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";

    @GetMapping(value={"/getPicture"})
    @ApiOperation(value="\u751f\u6210\u4e8c\u7ef4\u7801", notes="\u751f\u6210\u4e8c\u7ef4\u7801")
    public void getQrcode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        String code = LicenseInfo.generateRequestSN();
        String type = "V8";
        JSONObject json = new JSONObject();
        json.put("type", (Object)type);
        json.put("code", (Object)code);
        String os = System.getProperty("os.name");
        json.put("os", (Object)os);
        if (SecurityUtil.getUseSeparation().booleanValue()) {
            json.put("ui", (Object)"element-ui");
        } else {
            json.put("ui", (Object)"Layui");
        }
        json.put("version", (Object)FrameworkVersion.getVersion());
        BufferedImage bufImage = QRCodeUtil.getBufferedImage((String)json.toString(), (Integer)180, (InputStream)QRCodeUtil.baseToInputStream((String)logoImgBase64));
        response.setContentType("image/jpg");
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write((RenderedImage)bufImage, "jpg", (OutputStream)out);
        out.close();
    }

    @GetMapping(value={"/getTotpKey"})
    @ApiOperation(value="\u751f\u6210\u4e8c\u7ef4\u7801", notes="\u751f\u6210\u4e8c\u7ef4\u7801")
    public void getTotpKey(HttpServletResponse response, @ApiParam(value="\u8eab\u4efd\u9a8c\u8bc1") @RequestParam(value="code") String code, @ApiParam(value="\u7528\u6237\u540d\u79f0") @RequestParam(value="userName") String userName) throws IOException {
        if (code == null || userName == null) {
            return;
        }
        response.setCharacterEncoding("utf-8");
        BufferedImage bufImage = QRCodeUtil.getBufferedImage((String)this.abstractOTPCredentialsMatcher.getOtpAuthString(userName, this.hussarBaseProperties.getDomain(), code), null, (InputStream)QRCodeUtil.baseToInputStream((String)logoImgBase64));
        response.setContentType("image/jpg");
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write((RenderedImage)bufImage, "jpg", (OutputStream)out);
        out.close();
    }
}

