/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.listener;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.iamdatasync.service.IAMTokenToHussarTokenService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.properties.HussarSecurityProperties;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.operations.onlinehist.service.ISysOnlineHistService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.plugin.oauth2.listener.HussarSecurityOauthListener;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BaseHussarSecurityOauthListener
implements HussarSecurityOauthListener {
    @Autowired
    private HussarSecurityProperties hussarSecurityProperties;
    @Autowired
    private ISysUsersService sysUsersService;
    @Resource
    private ISysOnlineHistService iSysOnlineHistService;
    @Resource
    private IAMTokenToHussarTokenService iAMTokenToHussarTokenService;
    private static Logger LOGGER = LoggerFactory.getLogger(BaseHussarSecurityOauthListener.class);

    public void loginSuccess(UserDetails userDetails) {
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName("\u767b\u5f55");
        auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.LOGIN);
        auditLogModel.setEventDesc("\u767b\u5f55\u6210\u529f\uff01");
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
        this.iSysOnlineHistService.addRecord(userDetails.getAccessToken());
        LOGGER.debug("\u7528\u6237:{},id\uff1a{}\u767b\u5f55\u6210\u529f", (Object)userDetails.getUserName(), (Object)userDetails.getUserId());
    }

    public void logoutSuccess(UserDetails userDetails) {
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName("\u9000\u51fa\u767b\u5f55");
        auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.LOGOUT);
        auditLogModel.setEventDesc("\u9000\u51fa\u767b\u5f55");
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
        this.iSysOnlineHistService.updateLogoffTime(userDetails.getAccessToken());
        String iamToken = HttpKit.getRequest().getHeader("iamToken");
        if (HussarUtils.isNotEmpty((Object)iamToken)) {
            LOGGER.debug("\u5f85\u56de\u6536iamToken:" + iamToken);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("accessToken", iamToken);
            try {
                JSONObject jsonObject = this.iAMTokenToHussarTokenService.revokeToken(map);
                if (!"true".equals(jsonObject.getString("result"))) {
                    throw new HussarException("\u56de\u6536iamToken\u5931\u8d25");
                }
                LOGGER.debug("iamToken\u56de\u6536\u6210\u529f");
            }
            catch (IOException e) {
                throw new HussarException("\u56de\u6536iamToken\u5931\u8d25");
            }
        }
        LOGGER.debug("\u7528\u6237:{},id\uff1a{},accessToken:{},\u9000\u51fa\u6210\u529f", new Object[]{userDetails.getUserName(), userDetails.getUserId(), userDetails.getAccessToken()});
    }

    public void refreshTokenSuccess(String oldAccessToken, UserDetails newUserDetail) {
        this.iSysOnlineHistService.replaceTokenId(oldAccessToken, newUserDetail.getAccessToken());
        LOGGER.debug("\u7528\u6237:{},id\uff1a{},accessToken:{},\u5237\u65b0token\u6210\u529f,newAccessToken:{}", new Object[]{newUserDetail.getUserName(), newUserDetail.getUserId(), oldAccessToken, newUserDetail.getAccessToken()});
    }

    public void displacementSuccess(String clientId, String loginId, String accessToken) {
        LOGGER.debug("\u7528\u6237id\uff1a{},accessToken:{},\u6e05\u9664\u6216\u8005\u8e22\u4eba\u6210\u529f", (Object)loginId, (Object)accessToken);
    }
}

