/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.notice.service.impl;

import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.notice.dao.SysMessageMapper;
import com.jxdinfo.hussar.notice.dto.AddSysMessageDto;
import com.jxdinfo.hussar.notice.dto.AddSysMessageNewDto;
import com.jxdinfo.hussar.notice.enums.NoticeTipEnum;
import com.jxdinfo.hussar.notice.model.SysMessage;
import com.jxdinfo.hussar.notice.model.SysMessageAttachment;
import com.jxdinfo.hussar.notice.model.SysMessageDetail;
import com.jxdinfo.hussar.notice.service.IMyMessageAttachmentService;
import com.jxdinfo.hussar.notice.service.IMyMessageService;
import com.jxdinfo.hussar.notice.service.ISysMessageService;
import com.jxdinfo.hussar.notice.util.FunctionUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.notice.service.impl.sysMessageServiceImpl")
public class SysMessageServiceImpl
extends HussarServiceImpl<SysMessageMapper, SysMessage>
implements ISysMessageService {
    private static final String READ_FLAG = "0";
    @Autowired
    private IMyMessageAttachmentService myMessageAttachmentService;
    @Autowired
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Autowired
    private IMyMessageService myMessageService;
    @Autowired
    protected IHussarValidateService validateService;

    public ApiResponse saveSysMessage(AddSysMessageDto addSysMessageDto) {
        if (!HussarUtils.isNotEmpty((Object)addSysMessageDto)) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_MESSAGE_EMPTY.getMessage()));
        }
        SysMessage sysMessage = new SysMessage();
        BeanUtils.copyProperties((Object)addSysMessageDto, (Object)sysMessage);
        this.saveOrUpdate((BaseEntity)sysMessage);
        List messageAttachmentList = addSysMessageDto.getMessageAttachmentList();
        if (HussarUtils.isNotEmpty((Object)messageAttachmentList)) {
            for (int i = 0; i < messageAttachmentList.size(); ++i) {
                ((SysMessageAttachment)messageAttachmentList.get(i)).setMessageId(sysMessage.getId());
            }
            this.myMessageAttachmentService.saveOrUpdateBatch((Collection)messageAttachmentList);
        }
        List userVoList = new ArrayList();
        List orgList = FunctionUtil.toLongList((String)sysMessage.getDepartmentId());
        List userList = FunctionUtil.toLongList((String)sysMessage.getUserId());
        List postList = FunctionUtil.toLongList((String)sysMessage.getPostId());
        List roleList = FunctionUtil.toLongList((String)sysMessage.getRoleId());
        userVoList = this.hussarBaseUserBoService.getUsersByOrganUser(orgList, userList);
        if (HussarUtils.isNotEmpty((Object)postList)) {
            userVoList.addAll(this.hussarBaseUserBoService.getUsersByPostIds(postList));
        }
        if (HussarUtils.isNotEmpty((Object)roleList)) {
            userVoList.addAll(this.hussarBaseUserBoService.getUserInfoByRoleId(roleList));
        }
        userVoList.stream().filter(FunctionUtil.distinctByKey(UserVo::getId)).collect(Collectors.toList());
        if (!HussarUtils.isNotEmpty(userVoList)) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_USER_EMPTY.getMessage()));
        }
        ArrayList<SysMessageDetail> sysMessageDetailList = new ArrayList<SysMessageDetail>();
        SysMessageDetail messageDetail = new SysMessageDetail();
        messageDetail.setMessageId(sysMessage.getId());
        messageDetail.setMessageTypeId(sysMessage.getMessageTypeId());
        messageDetail.setMessageTitle(sysMessage.getMessageTitle());
        messageDetail.setReleaseDate(sysMessage.getReleaseDate());
        messageDetail.setCreateTime(sysMessage.getCreateTime());
        messageDetail.setMessageContent(sysMessage.getMessageContent());
        messageDetail.setCreatoeDepartmentId(sysMessage.getCreatoeDepartmentId());
        messageDetail.setMessageIssue(sysMessage.getMessageIssue());
        messageDetail.setCreator(sysMessage.getCreator());
        messageDetail.setBusinessAddress(sysMessage.getBusinessAddress());
        messageDetail.setMobileBusinessAddress(sysMessage.getMobileBusinessAddress());
        messageDetail.setOpenWay(sysMessage.getOpenWay());
        messageDetail.setReadFlag(READ_FLAG);
        for (int i = 0; i < userVoList.size(); ++i) {
            messageDetail.setPeopleId(((UserVo)userVoList.get(i)).getId());
            sysMessageDetailList.add(messageDetail);
        }
        this.myMessageService.saveBatch(sysMessageDetailList);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_MESSAGE_SAVE_SUCCESS.getMessage()));
    }

    public ApiResponse<String> addSysMessageNew(AddSysMessageNewDto addSysMessageNewDto) {
        String validateMsg = this.validateService.validate((Object)addSysMessageNewDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        if ((HussarUtils.isNotEmpty((Object)addSysMessageNewDto.getBusinessAddress()) || HussarUtils.isNotEmpty((Object)addSysMessageNewDto.getMobileBusinessAddress())) && HussarUtils.isEmpty((Object)addSysMessageNewDto.getOpenWay())) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_HAS_BIZ_OPEN_WAY_EMPTY.getMessage()));
        }
        SysMessage sysMessage = new SysMessage();
        HussarUtils.copy((Object)addSysMessageNewDto, (Object)sysMessage);
        super.save((BaseEntity)sysMessage);
        List orgList = FunctionUtil.toLongList((String)sysMessage.getDepartmentId());
        List userList = FunctionUtil.toLongList((String)sysMessage.getUserId());
        List postList = FunctionUtil.toLongList((String)sysMessage.getPostId());
        List roleList = FunctionUtil.toLongList((String)sysMessage.getRoleId());
        List userVoList = this.hussarBaseUserBoService.getUsersByOrganUser(orgList, userList);
        if (HussarUtils.isNotEmpty((Object)postList)) {
            userVoList.addAll(this.hussarBaseUserBoService.getUsersByPostIds(postList));
        }
        if (HussarUtils.isNotEmpty((Object)roleList)) {
            userVoList.addAll(this.hussarBaseUserBoService.getUserInfoByRoleId(roleList));
        }
        List<UserVo> userVos = userVoList.stream().filter(FunctionUtil.distinctByKey(UserVo::getId)).collect(Collectors.toList());
        if (!HussarUtils.isNotEmpty((Object)userVoList)) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_USER_EMPTY.getMessage()));
        }
        List<SysMessageDetail> sysMessageDetailList = SysMessageServiceImpl.getSysMessageDetails(sysMessage, userVos, userVoList);
        this.myMessageService.saveBatch(sysMessageDetailList);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_MESSAGE_SAVE_SUCCESS.getMessage()));
    }

    private static List<SysMessageDetail> getSysMessageDetails(SysMessage sysMessage, List<UserVo> userVos, List<UserVo> userVoList) {
        ArrayList<SysMessageDetail> sysMessageDetailList = new ArrayList<SysMessageDetail>();
        for (int i = 0; i < userVos.size(); ++i) {
            SysMessageDetail messageDetail = new SysMessageDetail();
            messageDetail.setMessageId(sysMessage.getId());
            messageDetail.setCreator(sysMessage.getCreator());
            messageDetail.setLastEditor(sysMessage.getLastEditor());
            messageDetail.setReadFlag(READ_FLAG);
            messageDetail.setPeopleId(userVoList.get(i).getId());
            sysMessageDetailList.add(messageDetail);
        }
        return sysMessageDetailList;
    }
}

