/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigBoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.notice.bo.SysNoticeAttachmentBo;
import com.jxdinfo.hussar.notice.dao.MyNoticeMapper;
import com.jxdinfo.hussar.notice.dao.MyNoticeRoleDeptMapper;
import com.jxdinfo.hussar.notice.dto.AddSysNoticeDto;
import com.jxdinfo.hussar.notice.enums.NoticeTipEnum;
import com.jxdinfo.hussar.notice.model.SysNotice;
import com.jxdinfo.hussar.notice.model.SysNoticeAttachment;
import com.jxdinfo.hussar.notice.model.SysNoticeRoleDept;
import com.jxdinfo.hussar.notice.service.IMyNoticeAttachmentService;
import com.jxdinfo.hussar.notice.service.IMyNoticeRoleDeptService;
import com.jxdinfo.hussar.notice.service.IMyNoticeService;
import com.jxdinfo.hussar.notice.util.FunctionUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.notice.service.impl.MyNoticeServiceImpl")
public class MyNoticeServiceImpl
extends HussarServiceImpl<MyNoticeMapper, SysNotice>
implements IMyNoticeService {
    @Resource
    private MyNoticeMapper myNoticeMapper;
    @Resource
    private IMyNoticeAttachmentService myNoticeAttachmentService;
    @Resource
    private MyNoticeRoleDeptMapper myNoticeRoleDeptMapper;
    @Autowired
    private IMyNoticeRoleDeptService myNoticeRoleDeptService;
    @Resource
    private ISysBaseConfigBoService baseConfigService;
    private static final List<Long> SYS_ROLE_IDS = Lists.newArrayList((Object[])new Long[]{1450785135866925067L, 1450785135866925068L, 1450785135866925061L, 1450781935868925962L, 1450715195867925063L, 1450785935166925011L});

    public IPage<SysNotice> listHomeNotice(Page page) {
        LocalDateTime nowTime = LocalDateTime.now();
        if (BaseSecurityUtil.isAdmin()) {
            page.setRecords(this.myNoticeMapper.listAllNotice(page, nowTime));
        } else {
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            Long deptId = securityUser.getDeptId();
            List roleIds = securityUser.getRolesList();
            if (HussarUtils.isNotEmpty((Object)roleIds)) {
                List<SysNotice> notices = this.myNoticeMapper.listHomeNotice(page, deptId, nowTime, roleIds);
                LinkedList<SysNotice> records = new LinkedList<SysNotice>();
                LinkedList<Long> noticeIds = new LinkedList<Long>();
                for (SysNotice sysNotice : notices) {
                    if (noticeIds.contains(sysNotice.getNoticeId())) continue;
                    records.add(sysNotice);
                    noticeIds.add(sysNotice.getNoticeId());
                }
                page.setRecords(records);
            }
        }
        return page;
    }

    public IPage<SysNotice> listHomeNotice(Page page, String noticeTitle, String releaseDate) {
        LocalDateTime releaseDateQueryStart = null;
        LocalDateTime releaseDateQueryEnd = null;
        if (HussarUtils.isNotEmpty((Object)releaseDate)) {
            releaseDate = releaseDate + " 00:00:00";
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            releaseDateQueryStart = LocalDateTime.parse(releaseDate, formatter);
            releaseDateQueryEnd = LocalDateTime.of(LocalDate.from(releaseDateQueryStart), LocalTime.MAX);
        }
        if (BaseSecurityUtil.isAdmin()) {
            page.setRecords(this.myNoticeMapper.queryAllNotice(page, noticeTitle, releaseDateQueryStart, releaseDateQueryEnd));
        } else {
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            Long deptId = securityUser.getDeptId();
            List roleIds = securityUser.getRolesList();
            if (HussarUtils.isNotEmpty((Object)roleIds)) {
                List<Object> notices = new ArrayList();
                SysBaseConfig protectStatus = this.baseConfigService.getSysBaseConfig("protection_status");
                if (null != protectStatus && "3".equals(protectStatus.getConfigValue())) {
                    boolean containSys = false;
                    for (Long roleId : roleIds) {
                        if (!SYS_ROLE_IDS.contains(roleId)) continue;
                        containSys = true;
                        break;
                    }
                    if (containSys) {
                        notices = this.myNoticeMapper.queryHomeNoticeWithSecurity(page, deptId, noticeTitle, releaseDateQueryStart, releaseDateQueryEnd, roleIds, 50);
                    } else {
                        Integer securityLevel = BaseSecurityUtil.getSecurityLevel();
                        notices = this.myNoticeMapper.queryHomeNoticeWithSecurity(page, deptId, noticeTitle, releaseDateQueryStart, releaseDateQueryEnd, roleIds, securityLevel);
                    }
                } else {
                    notices = this.myNoticeMapper.queryHomeNotice(page, deptId, noticeTitle, releaseDateQueryStart, releaseDateQueryEnd, roleIds);
                }
                List uniqueNotices = notices.stream().filter(FunctionUtil.distinctByKey(SysNotice::getNoticeId)).collect(Collectors.toList());
                page.setRecords(uniqueNotices);
            }
        }
        return page;
    }

    @HussarTransactional
    public ApiResponse deleteNoticeById(List<Long> ids) {
        if (this.removeByIds(ids)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"notice_id", ids);
            if (this.myNoticeRoleDeptService.deleteNoticeRoleDept(ids) && this.myNoticeAttachmentService.deleteNoticeAtt(ids)) {
                return ApiResponse.success((String)TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_DELETE_SUCCESS.getMessage()));
            }
            throw new HussarException(TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_DELETE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_DELETE_SUCCESS.getMessage()));
    }

    public IPage<SysNotice> listNotice(Page page, String noticeTitle, String releaseDate) {
        Long userId = BaseSecurityUtil.getUser().getId();
        Long deptId = BaseSecurityUtil.getUser().getDeptId();
        String position = this.myNoticeMapper.getUserPositionByUserId(userId);
        boolean isAdminFlag = BaseSecurityUtil.isAdmin();
        LocalDateTime releaseDateQueryStart = null;
        LocalDateTime releaseDateQueryEnd = null;
        if (HussarUtils.isNotEmpty((Object)releaseDate)) {
            releaseDate = releaseDate + " 00:00:00";
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            releaseDateQueryStart = LocalDateTime.parse(releaseDate, formatter);
            releaseDateQueryEnd = LocalDateTime.of(LocalDate.from(releaseDateQueryStart), LocalTime.MAX);
        }
        if (!isAdminFlag) {
            List roleIds = BaseSecurityUtil.getUser().getRolesList();
            if ("1".equals(position)) {
                ArrayList notices = new ArrayList();
                SysBaseConfig protectStatus = this.baseConfigService.getSysBaseConfig("protection_status");
                if (null != protectStatus && "3".equals(protectStatus.getConfigValue())) {
                    boolean containSys = false;
                    for (Long roleId : roleIds) {
                        if (!SYS_ROLE_IDS.contains(roleId)) continue;
                        containSys = true;
                        break;
                    }
                    if (containSys) {
                        page.setRecords(this.myNoticeMapper.listNoticeWithSecurity(page, noticeTitle, releaseDateQueryStart, releaseDateQueryEnd, deptId, null, 50));
                    } else {
                        Integer securityLevel = BaseSecurityUtil.getSecurityLevel();
                        page.setRecords(this.myNoticeMapper.listNoticeWithSecurity(page, noticeTitle, releaseDateQueryStart, releaseDateQueryEnd, deptId, null, securityLevel));
                    }
                } else {
                    page.setRecords(this.myNoticeMapper.listNotice(page, noticeTitle, releaseDateQueryStart, releaseDateQueryEnd, deptId, null));
                }
            } else {
                ArrayList notices = new ArrayList();
                SysBaseConfig protectStatus = this.baseConfigService.getSysBaseConfig("protection_status");
                if (null != protectStatus && "3".equals(protectStatus.getConfigValue())) {
                    boolean containSys = false;
                    for (Long roleId : roleIds) {
                        if (!SYS_ROLE_IDS.contains(roleId)) continue;
                        containSys = true;
                        break;
                    }
                    if (containSys) {
                        page.setRecords(this.myNoticeMapper.listNoticeWithSecurity(page, noticeTitle, releaseDateQueryStart, releaseDateQueryEnd, null, userId, 50));
                    } else {
                        Integer securityLevel = BaseSecurityUtil.getSecurityLevel();
                        page.setRecords(this.myNoticeMapper.listNoticeWithSecurity(page, noticeTitle, releaseDateQueryStart, releaseDateQueryEnd, null, userId, securityLevel));
                    }
                } else {
                    page.setRecords(this.myNoticeMapper.listNotice(page, noticeTitle, releaseDateQueryStart, releaseDateQueryEnd, null, userId));
                }
            }
        } else {
            page.setRecords(this.myNoticeMapper.listNotice(page, noticeTitle, releaseDateQueryStart, releaseDateQueryEnd, null, null));
        }
        return page;
    }

    public ApiResponse getNotice(Long id) {
        SysNotice sysNotice = (SysNotice)this.myNoticeMapper.selectById(id);
        return ApiResponse.success((Object)sysNotice);
    }

    public ApiResponse getNotice(String id) {
        return this.getNotice(Long.parseLong(id));
    }

    @HussarTransactional
    public ApiResponse insertOrUpdate(SysNotice sysNotice) {
        if ("".equals(sysNotice.getRoleId())) {
            sysNotice.setRoleId(null);
        }
        this.saveOrUpdate((BaseEntity)sysNotice);
        Long noticeId = sysNotice.getNoticeId();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysNoticeRoleDept::getNoticeId, (Object)noticeId);
        if (this.myNoticeRoleDeptMapper.delete((Wrapper)queryWrapper) >= 0) {
            SysNoticeRoleDept sysNoticeRoleDept = new SysNoticeRoleDept();
            sysNoticeRoleDept.setNoticeId(noticeId);
            sysNoticeRoleDept.setCreator(sysNotice.getCreator());
            sysNoticeRoleDept.setCreateTime(sysNotice.getCreateTime());
            sysNoticeRoleDept.setLastTime(sysNotice.getLastTime());
            sysNoticeRoleDept.setLastEditor(sysNotice.getLastEditor());
            if (ToolUtil.isNotEmpty((Object)sysNotice.getDepartmentId())) {
                sysNoticeRoleDept.setNoticeScopeType("department");
                String[] deptIds = sysNotice.getDepartmentId().split(",");
                ArrayList<SysNoticeRoleDept> saveList = new ArrayList<SysNoticeRoleDept>();
                for (String id : deptIds) {
                    SysNoticeRoleDept noticeRoleDept = new SysNoticeRoleDept();
                    CopyPropertieUtils.copyProperties((Object)noticeRoleDept, (Object)sysNoticeRoleDept);
                    Long deptId = new Long(id);
                    noticeRoleDept.setNoticeBusinessId(deptId);
                    noticeRoleDept.setId(null);
                    saveList.add(noticeRoleDept);
                }
                if (!this.myNoticeRoleDeptService.saveBatch(saveList)) {
                    throw new HussarException(TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_SAVE_FAIL.getMessage()));
                }
            }
            if (ToolUtil.isNotEmpty((Object)sysNotice.getRoleId())) {
                sysNoticeRoleDept.setNoticeScopeType("role");
                String[] roleIds = sysNotice.getRoleId().split(",");
                ArrayList<SysNoticeRoleDept> sysNoticeRoleDeptList = new ArrayList<SysNoticeRoleDept>();
                for (String id : roleIds) {
                    SysNoticeRoleDept sysNoticeRole = new SysNoticeRoleDept();
                    CopyPropertieUtils.copyProperties((Object)sysNoticeRole, (Object)sysNoticeRoleDept);
                    Long roleId = new Long(id);
                    sysNoticeRole.setNoticeBusinessId(roleId);
                    sysNoticeRole.setId(null);
                    sysNoticeRoleDeptList.add(sysNoticeRole);
                }
                if (!this.myNoticeRoleDeptService.saveBatch(sysNoticeRoleDeptList)) {
                    throw new HussarException(TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_SAVE_FAIL.getMessage()));
                }
            }
        }
        return ApiResponse.success((Object)noticeId);
    }

    public ApiResponse listNoticeAtt(Long id) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysNoticeAttachment::getNoticeId, (Object)id);
        List list = this.myNoticeAttachmentService.list((Wrapper)queryWrapper);
        return ApiResponse.success((Object)list);
    }

    public ApiResponse listNoticeAtt(String id) {
        return this.listNoticeAtt(Long.parseLong(id));
    }

    public ApiResponse saveSysNotice(AddSysNoticeDto addSysNoticeDto) {
        if (HussarUtils.isNotEmpty((Object)addSysNoticeDto)) {
            SysNotice sysNotice = new SysNotice();
            BeanUtils.copyProperties((Object)addSysNoticeDto, (Object)sysNotice);
            sysNotice.setRoleId(Strings.emptyToNull((String)sysNotice.getRoleId()));
            if (HussarUtils.isEmpty((Object)sysNotice.getNoticeId())) {
                this.save((BaseEntity)sysNotice);
            } else {
                sysNotice.setLastEditor(BaseSecurityUtil.getUser().getId());
                sysNotice.setLastTime(LocalDateTime.now());
                sysNotice.setReleaseDate(LocalDateTime.now());
                this.myNoticeMapper.updateNoticeById(sysNotice);
            }
            SysNoticeAttachmentBo sysNoticeAttachmentBo = new SysNoticeAttachmentBo();
            sysNoticeAttachmentBo.setNoticeAttachmentId(addSysNoticeDto.getNoticeAttachmentId());
            sysNoticeAttachmentBo.setNoticeId(sysNotice.getNoticeId());
            this.myNoticeAttachmentService.insertOrUpdate(sysNoticeAttachmentBo);
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_SAVE_SUCCESS.getMessage()));
        }
        return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_DATA_EMPTY.getMessage()));
    }
}

