/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.nocode.upgrade.v193tov194alpha.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.nocode.upgrade.v193tov194alpha.service.IUpgradeService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="com.jxdinfo.hussar.nocode.upgrade.v193tov194alpha.service.impl.UpgradeServiceImpl")
public class UpgradeServiceImpl
implements IUpgradeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeServiceImpl.class);
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private CanvasService canvasService;
    @Resource
    private FormOperateService operateService;

    @Override
    @HussarTokenDs
    public void subAddSeqColumn(String formIds) {
        List<Object> formIdList = Lists.newArrayListWithExpectedSize((int)5);
        if (HussarUtils.isEmpty((Object)formIds)) {
            List sysForms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysForm::getFormType, Arrays.asList("0", "1")));
            if (CollectionUtil.isNotEmpty((Collection)sysForms)) {
                formIdList = sysForms.stream().map(SysForm::getId).collect(Collectors.toList());
            }
        } else {
            String[] split = formIds.split(",");
            formIdList = Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)formIdList)) {
            return;
        }
        for (Long formId : formIdList) {
            FormCanvasSchema canvasSchema = (FormCanvasSchema)this.canvasService.get(String.valueOf(formId)).getData();
            List widgetList = canvasSchema.childTables();
            if (HussarUtils.isEmpty((Object)widgetList)) continue;
            for (Widget sub : widgetList) {
                String subName = sub.getName();
                try {
                    this.sysFormMapper.subAddSeqColumn(subName.toUpperCase());
                }
                catch (Exception e) {
                    LOGGER.error("\u8868\u5355ID:" + formId + ",\u5b50\u8868\u8868\u540d:" + subName + ",\u589e\u52a0\u6392\u5e8f\u5b57\u6bb5\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
                }
                try {
                    this.operateService.publish(String.valueOf(formId));
                }
                catch (Exception e) {
                    LOGGER.error("\u8868\u5355ID:" + formId + ",\u8868\u5355\u6709\u5b50\u8868,\u9700\u8981\u91cd\u65b0\u53d1\u5e03,\u53d1\u5e03\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    @Override
    @HussarTokenDs
    public void publish(String formIds) {
        List<Object> formIdList = Lists.newArrayListWithExpectedSize((int)5);
        if (HussarUtils.isEmpty((Object)formIds)) {
            List sysForms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysForm::getFormType, Arrays.asList("0", "1")));
            if (CollectionUtil.isNotEmpty((Collection)sysForms)) {
                formIdList = sysForms.stream().map(SysForm::getId).collect(Collectors.toList());
            }
        } else {
            String[] split = formIds.split(",");
            formIdList = Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)formIdList)) {
            return;
        }
        for (Long formId : formIdList) {
            FormCanvasSchema canvasSchema = (FormCanvasSchema)this.canvasService.get(String.valueOf(formId)).getData();
            List widgetList = canvasSchema.childTables();
            if (HussarUtils.isEmpty((Object)widgetList)) continue;
            try {
                this.operateService.publish(String.valueOf(formId));
            }
            catch (Exception e) {
                LOGGER.error("\u8868\u5355ID:" + formId + ",\u8868\u5355\u6709\u5b50\u8868,\u9700\u8981\u91cd\u65b0\u53d1\u5e03,\u53d1\u5e03\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }
}

