/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.nocode.upgrade.v930tov940.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesBoService;
import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.no.code.business.dao.CustomViewMapper;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CustomViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SysMiddleFileStorageService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.SysMiddleFileStorage;
import com.jxdinfo.hussar.formdesign.no.code.model.view.CustomView;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.util.FileToDB;
import com.jxdinfo.hussar.nocode.upgrade.v930tov940.service.IUpgradeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.theme.config.service.IHussarThemeConfigService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.nocode.upgrade.v930tov940.service.impl.UpgradeServiceImpl")
public class UpgradeServiceImpl
implements IUpgradeService {
    private final Logger LOGGER = LoggerFactory.getLogger(UpgradeServiceImpl.class);
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private CustomViewMapper customViewMapper;
    @Resource
    private CustomViewService customViewService;
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private FileToDB fileToDB;
    @Resource
    private SysMiddleFileStorageService sysMiddleFileStorageService;
    @Resource
    private AppSyncService appSyncService;
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private ISysFunctionModulesBoService functionModulesBoService;
    @Resource
    private IHussarThemeConfigService iHussarThemeConfigService;

    @Override
    public void splitViewButtonPosition() throws Exception {
        List forms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper());
        List<Long> formIds = forms.stream().map(SysForm::getId).collect(Collectors.toList());
        this.dealOperations(formIds);
    }

    private void dealOperations(List<Long> formIds) throws Exception {
        LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper1.in(CustomView::getFormId, formIds)).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.eq(CustomView::getCategory, (Object)"public");
        });
        List customViews = this.customViewMapper.selectList((Wrapper)queryWrapper1);
        OrderItem orderItem = new OrderItem();
        orderItem.setColumn("createTime_date");
        orderItem.setAsc(false);
        ArrayList<Long> faildIds = new ArrayList<Long>();
        int size = formIds.size();
        int n = 0;
        for (Long id : formIds) {
            this.LOGGER.info("\u66f4\u65b0\u4e2d\u95f4\u6587\u4ef6\u548c\u81ea\u5b9a\u4e49\u89c6\u56fe\u6570\u636e => \u8fdb\u5ea6\uff1a{}/{}", (Object)(++n), (Object)size);
            try {
                FormViewSchema viewData = (FormViewSchema)this.viewSchemaService.get(String.valueOf(id)).getData();
                if (HussarUtils.isEmpty((Object)viewData)) continue;
                for (int i = 0; i < viewData.getViews().size(); ++i) {
                    if (!HussarUtils.isEmpty((Object)((DataView)viewData.getViews().get(i)).getTreeOrderBy())) continue;
                    ((DataView)viewData.getViews().get(i)).setTreeOrderBy(Collections.singletonList(orderItem));
                }
                this.viewSchemaService.saveOrUpdate(viewData);
                List currentCustomViews = customViews.stream().filter(c -> HussarUtils.equals((Object)c.getFormId(), (Object)id)).collect(Collectors.toList());
                if (!HussarUtils.isNotEmpty(currentCustomViews)) continue;
                for (CustomView customView : currentCustomViews) {
                    if (HussarUtils.isEmpty((Object)customView.getTreeOrderBy())) {
                        customView.setTreeOrderBy(JSON.toJSONString(Collections.singletonList(orderItem)));
                    }
                    this.customViewService.saveOrUpdate((Object)customView);
                }
            }
            catch (Exception e) {
                faildIds.add(id);
                this.LOGGER.error("\u66f4\u65b0\u4e2d\u95f4\u6587\u4ef6\u548c\u81ea\u5b9a\u4e49\u89c6\u56fe\u6570\u636e\u5f02\u5e38\uff0c\u8868\u5355ID\uff1a{}", (Object)id, (Object)e);
            }
        }
        this.LOGGER.info("\u66f4\u65b0\u4e2d\u95f4\u6587\u4ef6\u548c\u81ea\u5b9a\u4e49\u89c6\u56fe\u6570\u636e\u5b8c\u6210\uff0c\u5931\u8d25\u6570\u91cf\uff1a{}\uff0c \u8868\u5355IDs: {}", (Object)formIds.size(), (Object)JSON.toJSONString(formIds));
    }

    @Override
    public void refreshHisFileToDB() throws Exception {
        this.fileToDB.syncFileToDB();
    }

    @Override
    public void updateDelFlagHisFile() {
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"DEL_FLAG", (Object)"1");
        List sysMiddleFileStorageList = this.sysMiddleFileStorageService.list(wrapper);
        for (SysMiddleFileStorage sysMiddleFileStorage : sysMiddleFileStorageList) {
            sysMiddleFileStorage.setDelFlag("0");
            this.sysMiddleFileStorageService.updateById((Object)sysMiddleFileStorage);
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> executeList(List<Long> appIds) {
        return this.executeSync(appIds);
    }

    @Override
    public ApiResponse<Map<String, Object>> executeAll() {
        List sysApplications = this.sysApplicationBoService.list();
        List<Long> appIds = sysApplications.stream().map(SysApplication::getId).collect(Collectors.toList());
        return this.executeSync(appIds);
    }

    @Override
    public ApiResponse<Void> cleanList(List<Long> appIds) {
        return this.restoreSync(appIds);
    }

    @Override
    public ApiResponse<Void> cleanAll() {
        List sysApplications = this.sysApplicationBoService.list();
        List<Long> appIds = sysApplications.stream().map(SysApplication::getId).collect(Collectors.toList());
        return this.restoreSync(appIds);
    }

    @Override
    public void updateThemeInfo() {
        if (this.iHussarThemeConfigService.updateThemeInfo()) {
            this.LOGGER.info("\u4e3b\u9898\u6570\u636e\u5347\u7ea7\u6210\u529f");
        }
    }

    private ApiResponse<Map<String, Object>> executeSync(List<Long> appIds) {
        if (HussarUtils.isEmpty(appIds)) {
            return ApiResponse.fail((String)"\u6ca1\u6709\u9700\u8981\u540c\u6b65\u7684\u5e94\u7528\u6570\u636e");
        }
        ArrayList<Long> failedAppIds = new ArrayList<Long>();
        int totalApps = appIds.size();
        for (int i = 0; i < totalApps; ++i) {
            Long appId = appIds.get(i);
            this.LOGGER.info("\u540c\u6b65\u5386\u53f2\u5e94\u7528\u6570\u636e => \u8fdb\u5ea6\uff1a{}/{}", (Object)(i + 1), (Object)totalApps);
            if (HussarUtils.isEmpty((Object)this.sysApplicationBoService.selectById(appId))) {
                failedAppIds.add(appId);
                continue;
            }
            try {
                this.appSyncService.syncHistory(appId);
                continue;
            }
            catch (Exception e) {
                failedAppIds.add(appId);
                this.LOGGER.error("\u5e94\u7528ID {} \u540c\u6b65\u5931\u8d25", (Object)appId, (Object)e);
                SysApplication sysApplication = new SysApplication();
                sysApplication.setId(appId);
            }
        }
        this.LOGGER.info("\u5386\u53f2\u5e94\u7528\u6570\u636e\u540c\u6b65\u5b8c\u6210\uff0c\u5931\u8d25\u5e94\u7528\u6570\u91cf: {}\uff0c\u5931\u8d25\u5e94\u7528\u96c6\u5408\uff1a{}", (Object)failedAppIds.size(), (Object)JSON.toJSONString(failedAppIds));
        HashMap<String, ArrayList<Long>> result = new HashMap<String, ArrayList<Long>>(1);
        result.put("failedAppIds", failedAppIds);
        return ApiResponse.success(result);
    }

    private ApiResponse<Void> restoreSync(List<Long> appIds) {
        if (HussarUtils.isEmpty(appIds)) {
            return ApiResponse.fail((String)"\u6ca1\u6709\u9700\u8981\u56de\u6eda\u7684\u5e94\u7528\u540c\u6b65\u6570\u636e");
        }
        int totalApps = appIds.size();
        for (int i = 0; i < totalApps; ++i) {
            this.LOGGER.info("\u5220\u9664\u5386\u53f2\u5e94\u7528\u6570\u636e => \u8fdb\u5ea6\uff1a{}/{}", (Object)(i + 1), (Object)totalApps);
            SysApplication application = new SysApplication();
            application.setId(appIds.get(i));
            this.appSyncService.syncApp("clean", application);
        }
        return ApiResponse.success();
    }
}

