/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.nocode.upgrade.v194alpha2tov194alpha3.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesBoService;
import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.nocode.upgrade.v194alpha2tov194alpha3.service.IUpgradeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.nocode.upgrade.v193tov194.service.UpgradeServiceImpl")
public class UpgradeServiceImpl
implements IUpgradeService {
    @Resource
    private AppSyncService appSyncService;
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private ISysFunctionModulesBoService functionModulesBoService;
    @Value(value="${hussar.app-sync.type:}")
    private String syncType;
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeServiceImpl.class);

    @Override
    public ApiResponse<Map<String, Object>> executeList(List<Long> appIds) {
        if (!this.needSyncHistory()) {
            return ApiResponse.fail((String)"\u975e union \u540c\u6b65\u7c7b\u578b\u4e0d\u9700\u8981\u540c\u6b65\u5386\u53f2\u6570\u636e");
        }
        return this.executeSync(appIds);
    }

    @Override
    public ApiResponse<Map<String, Object>> executeAll() {
        if (!this.needSyncHistory()) {
            return ApiResponse.fail((String)"\u975e union \u540c\u6b65\u7c7b\u578b\u4e0d\u9700\u8981\u540c\u6b65\u5386\u53f2\u6570\u636e");
        }
        List sysApplications = this.sysApplicationBoService.list();
        List<Long> appIds = sysApplications.stream().map(SysApplication::getId).collect(Collectors.toList());
        return this.executeSync(appIds);
    }

    @Override
    public ApiResponse<Void> restoreList(List<Long> appIds) {
        if (!this.needSyncHistory()) {
            return ApiResponse.fail((String)"\u975e union \u540c\u6b65\u7c7b\u578b\u4e0d\u9700\u8981\u540c\u6b65\u5386\u53f2\u6570\u636e");
        }
        return this.restoreSync(appIds);
    }

    @Override
    public ApiResponse<Void> restoreAll() {
        if (!this.needSyncHistory()) {
            return ApiResponse.fail((String)"\u975e union \u540c\u6b65\u7c7b\u578b\u4e0d\u9700\u8981\u540c\u6b65\u5386\u53f2\u6570\u636e");
        }
        List sysApplications = this.sysApplicationBoService.list();
        List<Long> appIds = sysApplications.stream().map(SysApplication::getId).collect(Collectors.toList());
        return this.restoreSync(appIds);
    }

    private ApiResponse<Map<String, Object>> executeSync(List<Long> appIds) {
        if (HussarUtils.isEmpty(appIds)) {
            return ApiResponse.fail((String)"\u6ca1\u6709\u9700\u8981\u540c\u6b65\u7684\u5e94\u7528\u6570\u636e");
        }
        ArrayList<Long> failedAppIds = new ArrayList<Long>();
        int totalApps = appIds.size();
        for (int i = 0; i < totalApps; ++i) {
            Long appId = appIds.get(i);
            LOGGER.info("\u540c\u6b65\u5386\u53f2\u5e94\u7528\u6570\u636e => \u8fdb\u5ea6\uff1a{}/{}", (Object)(i + 1), (Object)totalApps);
            if (HussarUtils.isEmpty((Object)this.sysApplicationBoService.selectById(appId))) {
                failedAppIds.add(appId);
                continue;
            }
            if (HussarUtils.isNotEmpty((Object)this.functionModulesBoService.getOneById(appId))) continue;
            try {
                this.appSyncService.syncHistory(appId);
                continue;
            }
            catch (Exception e) {
                failedAppIds.add(appId);
                LOGGER.error("\u5e94\u7528ID {} \u540c\u6b65\u5931\u8d25", (Object)appId, (Object)e);
                SysApplication sysApplication = new SysApplication();
                sysApplication.setId(appId);
                this.appSyncService.syncApp("del", sysApplication);
            }
        }
        LOGGER.info("\u5386\u53f2\u5e94\u7528\u6570\u636e\u540c\u6b65\u5b8c\u6210\uff0c\u5931\u8d25\u5e94\u7528\u6570\u91cf: {}\uff0c\u5931\u8d25\u5e94\u7528\u96c6\u5408\uff1a{}", (Object)failedAppIds.size(), (Object)JSON.toJSONString(failedAppIds));
        HashMap<String, ArrayList<Long>> result = new HashMap<String, ArrayList<Long>>(1);
        result.put("failedAppIds", failedAppIds);
        return ApiResponse.success(result);
    }

    private ApiResponse<Void> restoreSync(List<Long> appIds) {
        if (HussarUtils.isEmpty(appIds)) {
            return ApiResponse.fail((String)"\u6ca1\u6709\u9700\u8981\u56de\u6eda\u7684\u5e94\u7528\u540c\u6b65\u6570\u636e");
        }
        int totalApps = appIds.size();
        for (int i = 0; i < totalApps; ++i) {
            LOGGER.info("\u5220\u9664\u5386\u53f2\u5e94\u7528\u6570\u636e => \u8fdb\u5ea6\uff1a{}/{}", (Object)(i + 1), (Object)totalApps);
            SysApplication application = new SysApplication();
            application.setId(appIds.get(i));
            this.appSyncService.syncApp("clean", application);
        }
        return ApiResponse.success();
    }

    private boolean needSyncHistory() {
        return HussarUtils.equals((Object)"union", (Object)this.syncType);
    }
}

