/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.nocode.upgrade.v193pretov193.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.nocode.upgrade.v193pretov193.service.IUpgradeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.util.TenantCommonUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.nocode.upgrade.v193pretov193.service.impl.UpgradeServiceImpl")
public class UpgradeServiceImpl
implements IUpgradeService {
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    private static Logger logger = LoggerFactory.getLogger(UpgradeServiceImpl.class);

    private boolean renewWorkflowFilePath(String processKey) {
        try {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            if (HussarUtils.isNotEmpty((Object)processKey)) {
                queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
            }
            queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
            List sysActProcessFileList = this.sysActProcessFileService.list((Wrapper)queryWrapper);
            for (SysActProcessFile sysActProcessFile : sysActProcessFileList) {
                String wfdFile = new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
                JSONObject jsonObject = JSON.parseObject((String)wfdFile);
                JSONObject slots = jsonObject.getJSONObject("slots");
                JSONArray paths = slots.getJSONArray("path");
                if (HussarUtils.isNotEmpty((Object)paths)) {
                    for (int i = 0; i < paths.size(); ++i) {
                        JSONObject path = paths.getJSONObject(i);
                        JSONObject lineConfig = path.getJSONObject("lineConfig");
                        if (!HussarUtils.isNotEmpty((Object)lineConfig)) continue;
                        if (!lineConfig.containsKey((Object)"customX")) {
                            lineConfig.put("customX", null);
                        }
                        if (lineConfig.containsKey((Object)"customY")) continue;
                        lineConfig.put("customY", null);
                    }
                }
                wfdFile = JSONObject.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                SysActProcessFile processFile = new SysActProcessFile();
                processFile.setContent(wfdFile.getBytes(StandardCharsets.UTF_8));
                LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
                if (HussarUtils.isEmpty((Object)sysActProcessFile.getProcessId())) {
                    updateWrapper.isNull(SysActProcessFile::getProcessId);
                } else {
                    updateWrapper.eq(SysActProcessFile::getProcessId, (Object)sysActProcessFile.getProcessId());
                }
                updateWrapper.eq(SysActProcessFile::getProcessKey, (Object)sysActProcessFile.getProcessKey());
                updateWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
                this.sysActProcessFileService.update((Object)processFile, (Wrapper)updateWrapper);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b{}\u66f4\u65b0\u5931\u8d25, \u5931\u8d25\u539f\u56e0: {}", new Object[]{processKey, e.toString(), e});
            return false;
        }
    }

    @Override
    @HussarTokenDs
    public ApiResponse<String> upgradeWorkflowFilePath(String processKeys) {
        String tCode = TenantCommonUtil.getTenantCodeByUrl();
        if (HussarUtils.isBlank((CharSequence)tCode)) {
            tCode = "master";
        }
        HussarCacheUtil.evictKeysLike((String)"workflow_file", (String)"bpm");
        List<Object> processKeyList = new ArrayList();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)processKeys)) {
            String[] split = processKeys.split(",");
            processKeyList = Arrays.asList(split);
        } else {
            processKeyList = this.checkPaths();
        }
        int total = processKeyList.size();
        logger.info("tCode:{}, \u5c06\u8981\u8fdb\u884c\u5237\u65b0\u7684\u6240\u6709\u6d41\u7a0b\u4fe1\u606f:{}", (Object)tCode, (Object)JSONObject.toJSONString(processKeyList));
        AtomicInteger deal = new AtomicInteger();
        AtomicInteger fail = new AtomicInteger();
        AtomicInteger success = new AtomicInteger();
        CountDownLatch countDownLatch = new CountDownLatch(total);
        String finalTCode = tCode;
        processKeyList.forEach(processKey -> {
            deal.getAndIncrement();
            if (!this.renewWorkflowFilePath((String)processKey)) {
                fail.incrementAndGet();
            } else {
                success.incrementAndGet();
            }
            countDownLatch.countDown();
            logger.info("tCode:{}, \u603b\u5171\uff1a{}, \u5df2\u5904\u7406\uff1a{}, \u6210\u529f: {}, \u5931\u8d25\uff1a{}", new Object[]{finalTCode, total, deal.get(), success.get(), fail.get()});
        });
        return ApiResponse.success((String)StringUtils.format((String)"tCode:{}, \u603b\u5171\u6d41\u7a0b\u6570\uff1a%s, \u5904\u7406\u6570\uff1a%s, \u6210\u529f\u6570\uff1a%s, \u5931\u8d25\u6570\uff1a%s", (Object[])new Object[]{tCode, total, deal, success, fail}));
    }

    @Override
    @HussarTokenDs
    public List<String> checkPaths() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
        List sysActProcessFileList = this.sysActProcessFileService.list((Wrapper)queryWrapper);
        LinkedHashSet<String> processKeySet = new LinkedHashSet<String>();
        block0: for (SysActProcessFile sysActProcessFile : sysActProcessFileList) {
            String wfdFile = new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
            JSONObject jsonObject = JSON.parseObject((String)wfdFile);
            JSONObject slots = jsonObject.getJSONObject("slots");
            JSONArray paths = slots.getJSONArray("path");
            if (!HussarUtils.isNotEmpty((Object)paths)) continue;
            for (int i = 0; i < paths.size(); ++i) {
                JSONObject path = paths.getJSONObject(i);
                JSONObject lineConfig = path.getJSONObject("lineConfig");
                if (!HussarUtils.isNotEmpty((Object)lineConfig) || lineConfig.containsKey((Object)"customX") || lineConfig.containsKey((Object)"customY") || !HussarUtils.isNotEmpty((Object)lineConfig.get((Object)"lineName"))) continue;
                processKeySet.add(sysActProcessFile.getProcessKey());
                continue block0;
            }
        }
        ArrayList<String> processKeyList = new ArrayList<String>(processKeySet);
        return processKeyList;
    }
}

