/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.no.code.message.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.model.MsgBasicSendRecord;
import com.jxdinfo.hussar.msg.send.model.MsgBasicTemplate;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.no.code.message.constant.SendStatusEnum;
import com.jxdinfo.hussar.no.code.message.dto.StationSendRecordDto;
import com.jxdinfo.hussar.no.code.message.model.MsgStationTemplate;
import com.jxdinfo.hussar.no.code.message.service.IMsgStationTemplateService;
import com.jxdinfo.hussar.no.code.message.service.IStationPushThirdService;
import com.jxdinfo.hussar.no.code.message.service.IStationSendRecordService;
import com.jxdinfo.hussar.platform.core.utils.ExceptionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.no.code.message.service.impl.StationMsgUnitySendFrameServiceImpl")
public class StationMsgUnitySendFrameServiceImpl
implements MsgUnitySendFrameService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StationMsgUnitySendFrameServiceImpl.class);
    @Autowired
    private IMsgStationTemplateService msgStationTemplateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private IStationPushThirdService stationPushThirdService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private IStationSendRecordService stationSendRecordService;

    public List<MsgBasicTemplate> getTemplateData(List<String> templateNos) {
        List list = this.msgStationTemplateService.list((Wrapper)new LambdaQueryWrapper().in(MsgStationTemplate::getTemplateNo, templateNos));
        if (HussarUtils.isNotEmpty((Object)list)) {
            ArrayList<MsgBasicTemplate> all = new ArrayList<MsgBasicTemplate>();
            for (MsgStationTemplate t : list) {
                MsgBasicTemplate m = new MsgBasicTemplate();
                m.setTemplateNo(t.getTemplateNo());
                m.setTemplateContent(t.getContent());
                all.add(m);
            }
            return all;
        }
        return new ArrayList<MsgBasicTemplate>();
    }

    public MsgBasicSendRecord msgUnitySendBefore(MsgUnitySendDto msgUnitySendDto) {
        StationSendRecordDto stationSendRecordDto = new StationSendRecordDto();
        String appId = null;
        String sceneCode = null;
        String sceneName = null;
        String appName = null;
        String appSecret = null;
        String templateNo = null;
        String templateName = null;
        String stationType = null;
        Long userSendId = null;
        String msgWebUrl = null;
        String userSendName = null;
        String msgMobileUrl = null;
        String tenantCode = null;
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        String content = null;
        try {
            Map receiveAddressMap = msgUnitySendDto.getReceiveAddress();
            if (HussarUtils.isEmpty((Object)receiveAddressMap)) {
                throw new HussarException("\u7ad9\u5185\u4fe1\u63a5\u53d7\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String station = "station_message";
            String receiveUserIdStr = (String)receiveAddressMap.get(station);
            if (StringUtils.isBlank((CharSequence)receiveUserIdStr)) {
                throw new HussarException("\u7ad9\u5185\u4fe1\u63a5\u53d7\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String[] split = receiveUserIdStr.split(",");
            receiveUserIds = new ArrayList();
            for (String s : split) {
                receiveUserIds.add(Long.parseLong(s));
            }
            stationSendRecordDto.setReceiverUserIds(receiveUserIds);
            Map incompleteTemplateParams = msgUnitySendDto.getIncompleteTemplateParams();
            Map StationIncompleteTemplateParams = (Map)incompleteTemplateParams.get("station_message");
            if (HussarUtils.isEmpty((Object)StationIncompleteTemplateParams)) {
                throw new HussarException("\u7ad9\u5185\u4fe1\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570[userSendId,msgWebUrl,msgMobileUrl]");
            }
            userSendId = (Long)StationIncompleteTemplateParams.get("userSendId");
            userSendName = (String)StationIncompleteTemplateParams.get("userSendName");
            msgWebUrl = (String)StationIncompleteTemplateParams.get("msgWebUrl");
            msgMobileUrl = (String)StationIncompleteTemplateParams.get("msgMobileUrl");
            tenantCode = msgUnitySendDto.getTenantCode();
            SecurityUser user = BaseSecurityUtil.getUser();
            if (userSendId == null) {
                userSendId = user != null ? user.getId() : Long.valueOf(1450756958461300737L);
            }
            if (StringUtils.isBlank((CharSequence)userSendName)) {
                userSendName = user != null ? user.getUserName() : "\u8d85\u7ea7\u7ba1\u7406\u5458";
            }
            if (StringUtils.isBlank((CharSequence)tenantCode)) {
                tenantCode = HussarContextHolder.getHussarTenant().getTenantCode();
            }
            stationSendRecordDto.setUserSendId(userSendId);
            stationSendRecordDto.setUserSendName(userSendName);
            stationSendRecordDto.setMsgMobileUrl(msgMobileUrl);
            stationSendRecordDto.setMsgWebUrl(msgWebUrl);
            tenantCode = StringUtils.isBlank((CharSequence)tenantCode) ? "0" : tenantCode;
            stationSendRecordDto.setTenantCode(tenantCode);
            stationSendRecordDto.setTim(Boolean.valueOf(false));
            AppSceneConfig appSceneConfig = (AppSceneConfig)this.appSceneConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(AppSceneConfig::getSceneCode, (Object)msgUnitySendDto.getSceneCode()));
            sceneCode = appSceneConfig.getSceneCode();
            sceneName = appSceneConfig.getSceneName();
            Long appAccessId = appSceneConfig.getAppPkId();
            stationSendRecordDto.setSceneCode(sceneCode);
            stationSendRecordDto.setSceneName(sceneName);
            AppAccess appAccess = (AppAccess)this.appAccessService.getById((Serializable)appAccessId);
            appId = appAccess.getAppId();
            stationSendRecordDto.setAppId(appId);
            appName = appAccess.getAppName();
            stationSendRecordDto.setAppName(appName);
            appSecret = appAccess.getAppSecret();
            stationSendRecordDto.setAppSecret(appSecret);
            ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(sceneCode, appAccessId.toString(), "station_message");
            templateNo = configJsonData.getTemplateNo();
            MsgStationTemplate stationTemplate = (MsgStationTemplate)this.msgStationTemplateService.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgStationTemplate::getTemplateNo, (Object)templateNo));
            if (stationTemplate == null) {
                throw new HussarException("\u672a\u67e5\u8be2\u5230\u6a21\u7248\u7f16\u53f7[" + templateNo + "]\u7684\u6a21\u7248");
            }
            Map currentTemplateParams = TemplateUtils.getCurrentTemplateParams((Map)msgUnitySendDto.getTemplateParams(), (String)stationTemplate.getTemplateParams());
            content = this.replaceContent(stationTemplate.getContent(), currentTemplateParams);
            stationSendRecordDto.setTemplateNo(stationTemplate.getTemplateNo());
            templateName = stationTemplate.getTemplateName();
            stationSendRecordDto.setTemplateName(templateName);
            stationSendRecordDto.setMsgContent(content);
            stationSendRecordDto.setMsgTitle(content);
            stationType = stationTemplate.getStationType();
            stationSendRecordDto.setStationType(stationType);
            this.stationPushThirdService.sendMsg(stationSendRecordDto);
        }
        catch (Exception e) {
            LOGGER.error("\u7edf\u4e00\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff1a{}", (Throwable)e);
            StationSendRecordDto recordDto = new StationSendRecordDto();
            recordDto.setSceneName(sceneName);
            recordDto.setAppName(appName);
            recordDto.setAppId(appId);
            recordDto.setAppSecret(appSecret);
            recordDto.setTemplateNo(templateNo);
            recordDto.setTemplateName(templateName);
            recordDto.setTenantCode(tenantCode);
            recordDto.setUserSendName(userSendName);
            recordDto.setUserSendId(userSendId);
            recordDto.setReceiverUserIds(receiveUserIds);
            recordDto.setMsgTitle(content);
            recordDto.setMsgContent(content);
            recordDto.setStationType(stationType);
            recordDto.setSceneCode(sceneCode);
            recordDto.setStatus(SendStatusEnum.FAIL.getCode());
            recordDto.setMsgMobileUrl(msgMobileUrl);
            recordDto.setMsgWebUrl(msgWebUrl);
            recordDto.setErrMsg(ExceptionUtil.getMessage((Throwable)e));
            this.stationSendRecordService.save(recordDto);
        }
        return null;
    }

    private String replaceContent(String content, Map<String, Object> currentTemplateParams) {
        if (HussarUtils.isNotEmpty(currentTemplateParams)) {
            return TemplateUtils.replaceParams((String)content, currentTemplateParams);
        }
        return content;
    }

    public String getMsgSendType() {
        return "station_message";
    }

    public boolean msgUnityThirdSend(MsgBasicSendRecord msgBasicSendRecord) {
        return true;
    }
}

