/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.no.code.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.common.properties.UnifiedMessageProperties;
import com.jxdinfo.hussar.msg.job.dto.JobParamsVo;
import com.jxdinfo.hussar.no.code.message.dto.StationSendRecordDto;
import com.jxdinfo.hussar.no.code.message.enums.MsgJobEnum;
import com.jxdinfo.hussar.no.code.message.properties.MsgJobExecutionProperties;
import com.jxdinfo.hussar.no.code.message.service.IStationMsgJobService;
import com.jxdinfo.hussar.no.code.message.service.IStationSendRecordService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.job.core.enums.ExecuteType;
import com.jxdinfo.hussar.support.job.core.enums.ProcessorType;
import com.jxdinfo.hussar.support.job.core.enums.TimeExpressionType;
import com.jxdinfo.hussar.support.job.core.request.http.SaveJobInfoRequest;
import com.jxdinfo.hussar.support.job.dispatch.api.service.JobServiceService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.no.code.message.service.impl.StationMsgJobServiceImpl")
public class StationMsgJobServiceImpl
implements IStationMsgJobService {
    private static final Logger logger = LoggerFactory.getLogger(StationMsgJobServiceImpl.class);
    @Autowired
    private MsgJobExecutionProperties msgJobExecutionProperties;
    @Autowired
    private UnifiedMessageProperties unifiedMessageProperties;
    @Autowired
    private IStationSendRecordService sendRecordService;
    @Autowired(required=false)
    private JobServiceService jobServiceService;

    public ApiResponse saveMsgJob(Date triggerTime, String params, MsgJobEnum msgJobEnum) {
        System.out.println("\u6253\u5305\u6d4b\u8bd5");
        if (this.msgJobExecutionProperties.isEnableSingleModel()) {
            if (!this.msgJobExecutionProperties.isEnableExecutor() || !this.msgJobExecutionProperties.isEnableServer()) {
                throw new HussarException("\u4efb\u52a1\u8c03\u5ea6\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u53d1\u9001\u5b9a\u65f6\u6d88\u606f\uff01");
            }
        } else if (!this.msgJobExecutionProperties.isEnableExecutor()) {
            throw new HussarException("\u6267\u884c\u5668\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u53d1\u9001\u5b9a\u65f6\u6d88\u606f\uff01");
        }
        if (HussarUtils.isEmpty((Object)triggerTime)) {
            throw new HussarException("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u65f6\u95f4\u4e3a\u7a7a\uff01");
        }
        if (triggerTime.getTime() < System.currentTimeMillis() + 120000L) {
            throw new HussarException("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f42\u5206\u949f\u4ee5\u4e0a\uff01");
        }
        if (HussarUtils.isNotEmpty((Object)this.jobServiceService)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("ss mm HH dd MM ? yyyy");
            String jobTime = dateFormat.format(triggerTime);
            JobParamsVo jobParamsVo = new JobParamsVo();
            jobParamsVo.setType(msgJobEnum.getCode());
            jobParamsVo.setJobParams(params);
            SaveJobInfoRequest saveJobInfoRequest = new SaveJobInfoRequest();
            saveJobInfoRequest.setJobName(msgJobEnum.getName());
            saveJobInfoRequest.setJobDescription(msgJobEnum.getName());
            saveJobInfoRequest.setTimeExpression(jobTime);
            saveJobInfoRequest.setJobParams(JSONObject.toJSONString((Object)jobParamsVo));
            saveJobInfoRequest.setAppId(this.unifiedMessageProperties.getJobAppId());
            saveJobInfoRequest.setTimeExpressionType(TimeExpressionType.CRON);
            saveJobInfoRequest.setExecuteType(ExecuteType.STANDALONE);
            saveJobInfoRequest.setProcessorType(ProcessorType.BUILT_IN);
            saveJobInfoRequest.setProcessorInfo("com.jxdinfo.hussar.msg.config.MsgJobProcessors");
            try {
                ApiResponse response = this.jobServiceService.saveJobApi(saveJobInfoRequest);
                if (response.getCode() != ResultCode.SUCCESS.getCode()) {
                    throw new HussarException(response.getMsg());
                }
                return response;
            }
            catch (ParseException e) {
                throw new HussarException(e.getMessage());
            }
        }
        return ApiResponse.fail((String)"\u65e0\u6cd5\u6ce8\u5165Bean jobServiceService");
    }

    public void deleteMsgJob(Long jobId) {
        this.jobServiceService.physicalDeleteJob(jobId);
    }

    public void sendMsg(JobParamsVo jobParamsVo, Long jobId) throws Exception {
        MsgJobEnum msgJobEnum = MsgJobEnum.getByCode((String)jobParamsVo.getType());
        if (msgJobEnum == null) {
            return;
        }
        try {
            this.sendRecordService.save((StationSendRecordDto)JSONObject.parseObject((String)jobParamsVo.getJobParams(), StationSendRecordDto.class));
        }
        catch (Exception e) {
            logger.error(JSON.toJSONString((Object)jobParamsVo), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            this.deleteMsgJob(jobId);
        }
    }
}

