/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.no.code.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.no.code.message.service.ISendClientMessage;
import com.jxdinfo.hussar.no.code.message.vo.StationNoReadMsgVo;
import com.jxdinfo.hussar.notice.dto.AddSysMessageNewDto;
import com.jxdinfo.hussar.notice.service.ISysMessageService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.no.code.message.service.impl.sendClientMessageImpl")
public class SendClientMessageImpl
implements ISendClientMessage {
    private final Logger LOGGER = LoggerFactory.getLogger(SendClientMessageImpl.class);
    @Autowired
    private ISysMessageService sysMessageService;
    @Autowired
    private ISysUsersService sysUsersService;

    public void sendMessageOne(Long userId, String message) {
        StationNoReadMsgVo vo = (StationNoReadMsgVo)JSON.parseObject((String)message, StationNoReadMsgVo.class);
        if (vo != null) {
            AddSysMessageNewDto station = new AddSysMessageNewDto();
            String stationType = vo.getStationType();
            if (StringUtils.isBlank((CharSequence)stationType)) {
                stationType = "14";
            }
            String msgWebUrl = vo.getMsgWebUrl();
            String msgMobileUrl = vo.getMsgMobileUrl();
            Date sendTime = vo.getSendTime();
            String showTitle = vo.getShowTitle();
            Long userSendId = vo.getUserSendId();
            if (userSendId == null) {
                userSendId = 1450757642371981314L;
            }
            Long userReceiverId = vo.getUserReceiverId();
            station.setMessageTypeId(Long.valueOf(stationType));
            station.setReleaseDate(LocalDateTime.ofInstant(Instant.ofEpochMilli(sendTime.getTime()), ZoneId.systemDefault()));
            station.setMessageContent(showTitle);
            station.setBusinessAddress(msgWebUrl);
            station.setMobileBusinessAddress(msgMobileUrl);
            if (StringUtils.isNotBlank((CharSequence)msgWebUrl) || StringUtils.isNotBlank((CharSequence)msgMobileUrl)) {
                station.setOpenWay("1");
            }
            station.setUserId(String.valueOf(userReceiverId));
            station.setCreator(userSendId);
            SysUsers byId = this.sysUsersService.getById(userSendId);
            if (HussarUtils.isNotEmpty((Object)byId)) {
                Long departmentId = byId.getDepartmentId();
                station.setCreatoeDepartmentId(departmentId);
                station.setMessageIssue(byId.getUserName());
            } else {
                station.setCreatoeDepartmentId(Long.valueOf(111L));
                station.setMessageIssue("\u9ed8\u8ba4\u7528\u6237");
            }
            station.setLastEditor(userSendId);
            this.sysMessageService.addSysMessageNew(station);
        }
    }
}

