/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.example.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static OkHttpClient client;
    private static final Logger logger;
    private static final TrustManager[] trustAllCerts;

    private static OkHttpClient client() {
        if (client != null) {
            return client;
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            client = new OkHttpClient.Builder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            }).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
            return client;
        }
        catch (Exception e) {
            throw new HussarException("\u521d\u59cb\u5316 HttpClient \u5931\u8d25");
        }
    }

    public static String sendPost(String url, Map<String, Object> bodyData) {
        String bodyJsonStr = JSON.toJSONString(bodyData);
        RequestBody requestBody = RequestBody.create((String)bodyJsonStr, (MediaType)MediaType.parse((String)"application/json;charset=UTF-8"));
        Request ssoRequest = new Request.Builder().url(url).addHeader("Content-Type", "application/json;charset=UTF-8").post(requestBody).build();
        logger.info("\u8bf7\u6c42\u5165\u53c2\uff1aurl\uff1a{} header\uff1a{} body\uff1a{}", new Object[]{ssoRequest.url(), ssoRequest.headers(), JSON.toJSONString(bodyData)});
        try {
            Response response = HttpUtil.client().newCall(ssoRequest).execute();
            if (!response.isSuccessful()) {
                throw new HussarException("\u8bf7\u6c42\u5f02\u5e38" + response.message());
            }
            logger.info("\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)response.body()));
            return Objects.requireNonNull(response.body()).string();
        }
        catch (Exception e) {
            throw new HussarException("\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
    }

    static {
        logger = LoggerFactory.getLogger(HttpUtil.class);
        trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
    }
}

