/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.example.donghang;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.example.donghang.DonghangLoginProperties;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppOauthConfig;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppOauthConfigService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service
public class DongHangLoginServiceImpl
implements HussarLoginValidateService {
    protected static Logger logger = LoggerFactory.getLogger(DongHangLoginServiceImpl.class);
    private static OkHttpClient client;
    @Resource
    private DonghangLoginProperties properties;
    @Resource
    private ISysAppOauthConfigService sysAppOauthConfigService;
    private static final TrustManager[] trustAllCerts;

    public String getLoginType() {
        return "donghang";
    }

    public String beforeSelectUser(HttpServletRequest httpRequest, String loginCode, AuthcDto authcDto) {
        String appId = httpRequest.getHeader("appId");
        LambdaQueryWrapper sysAppOauthConfigWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppOauthConfig::getAppId, (Object)appId);
        SysAppOauthConfig sysAppOauthConfig = (SysAppOauthConfig)this.sysAppOauthConfigService.getOne((Wrapper)sysAppOauthConfigWrapper);
        String appCode = sysAppOauthConfig.getAuthId();
        String appSecret = sysAppOauthConfig.getAuthSecret();
        String grantType = sysAppOauthConfig.getGrantType();
        logger.info("\u4e1c\u822aappId:{}, appSecret: {}, tokenUrl: {}", new Object[]{appCode, appSecret, this.properties.getTokenUrl()});
        if (HussarUtils.isEmpty((Object)loginCode)) {
            throw new HussarException("\u83b7\u53d6token\u4fe1\u606f\u5931\u8d25, \u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FormBody.Builder builder = new FormBody.Builder();
        builder.add("app_id", appCode);
        builder.add("grant_type", grantType);
        builder.add("code", loginCode);
        Long timestamp = System.currentTimeMillis();
        builder.add("timestamp", timestamp.toString());
        String sign = DigestUtils.md5DigestAsHex((byte[])(timestamp + appCode + appSecret).getBytes());
        builder.add("sign", sign);
        Request request = new Request.Builder().url(this.properties.getTokenUrl()).post((RequestBody)builder.build()).build();
        try {
            Response response = DongHangLoginServiceImpl.client().newCall(request).execute();
            logger.info("\u4e1c\u822a\u8ba4\u8bc1\u54cd\u5e94:{}", (Object)response);
        }
        catch (Exception e) {
            throw new HussarException("\u4e1c\u822a\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25", (Throwable)e);
        }
        return "superadmin";
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
    }

    private static OkHttpClient client() {
        if (client != null) {
            return client;
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            client = new OkHttpClient.Builder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            }).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
            return client;
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u4e1c\u822ahttpClient\u5931\u8d25", (Throwable)e);
            throw new HussarException("\u521d\u59cb\u5316\u4e1c\u822ahttpClient\u5931\u8d25");
        }
    }

    static {
        trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
    }
}

