/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.example.custom;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hussarNoCode/custom/api"})
public class CustomApiController {
    @Resource
    private FilePublishService filePublishService;
    @Resource
    private ISysApplicationBoService sysApplicationService;
    @Resource
    private FormDesignProperties formDesignProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomApiController.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/deployment_package_download"})
    public void download(@RequestParam(value="appId") String appId, HttpServletResponse response) throws Exception {
        block18: {
            String zipPath = null;
            try {
                String rootPath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), "template"});
                String appJsonPath = FileUtil.posixPath((String[])new String[]{rootPath, "app.json"});
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("appId", appId);
                this.writeToFile(map, appJsonPath);
                String appName = this.sysApplicationService.selectById(Long.valueOf(appId)).getAppName();
                zipPath = new File(rootPath).getParent() + File.separator + appName + ".zip";
                ZipUtil.zip((String)rootPath, (String)zipPath);
                byte[] data = Files.readAllBytes(Paths.get(zipPath, new String[0]));
                try (ServletOutputStream os = response.getOutputStream();){
                    String fileName = new File(zipPath).getName();
                    LOGGER.info("\u6587\u4ef6\u540d\uff1a{}", (Object)fileName);
                    response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
                    response.setContentType("application/octet-stream");
                    IOUtils.write((byte[])data, (OutputStream)os);
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                if (zipPath == null || !new File(zipPath).exists()) break block18;
                new File(zipPath).delete();
            }
            catch (Throwable throwable) {
                if (zipPath != null && new File(zipPath).exists()) {
                    new File(zipPath).delete();
                }
                throw throwable;
            }
        }
    }

    private void writeToFile(Object object, String path) {
        String json = JSONObject.toJSONString((Object)object);
        this.filePublishService.writeStringToFile(json, path);
    }
}

