/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.mobile.push.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.mobile.push.app.dao.ProducerMapper;
import com.jxdinfo.hussar.mobile.push.app.dao.TokenMapper;
import com.jxdinfo.hussar.mobile.push.app.dto.ProducerConfiguration;
import com.jxdinfo.hussar.mobile.push.app.model.App;
import com.jxdinfo.hussar.mobile.push.app.model.DeviceToken;
import com.jxdinfo.hussar.mobile.push.app.service.AppService;
import com.jxdinfo.hussar.mobile.push.message.PushApp;
import com.jxdinfo.hussar.mobile.push.message.TagRule;
import com.jxdinfo.hussar.mobile.push.publish.enums.CodeEnum;
import com.jxdinfo.hussar.mobile.push.publish.enums.ProTypeEnum;
import com.jxdinfo.hussar.mobile.push.publish.model.PushRecordDO;
import com.jxdinfo.hussar.mobile.push.publish.service.PushService;
import com.jxdinfo.hussar.mobile.push.util.StringUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.platform.core.utils.date.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class PushServiceImpl
implements PushService {
    @Resource
    private ProducerMapper producerMapper;
    @Resource
    private TokenMapper tokenMapper;
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private AppService appService;

    public ApiResponse<Boolean> sendConfiguration(PushApp pushApp) {
        ApiResponse<Boolean> response;
        App appInfo = new App();
        appInfo.setId(pushApp.getAppId());
        if (HussarUtils.isNotEmpty((Object)appInfo.getId())) {
            appInfo = (App)this.appService.getOne((Wrapper)new LambdaQueryWrapper().eq(App::getId, (Object)appInfo.getId()));
        }
        if (!((Boolean)(response = this.checkPushApp(pushApp)).getData()).booleanValue()) {
            return response;
        }
        String produceType = "";
        if (pushApp.getPlatform() != null && pushApp.getPlatform() == 0) {
            produceType = "6";
        }
        if (pushApp.getPlatform() != null && pushApp.getPlatform() == 1) {
            produceType = "5";
        }
        List<ProducerConfiguration> list = this.producerMapper.getProducerConfiguration(appInfo.getId(), produceType);
        String pushId = IdUtil.randomUUID();
        if (pushApp.getAudienceType() == 1) {
            this.convertAndSendByToken(list, pushApp, pushId);
        }
        if (pushApp.getAudienceType() == 0) {
            this.convertAndSendByProToken(list, this.tokenMapper.listTokenByAppId(appInfo.getId()), pushApp, pushId);
        }
        if (pushApp.getAudienceType() == 2) {
            this.convertAndSendByProToken(list, this.dealTagToken(pushApp), pushApp, pushId);
        }
        Long nowTime = System.currentTimeMillis();
        Long sendTime = HussarUtils.isNotEmpty((Object)pushApp.getMessage().getSendTime()) ? DateUtil.parseDateTime((CharSequence)pushApp.getMessage().getSendTime()).getTime() : nowTime.longValue();
        PushRecordDO pushRecordDO = new PushRecordDO();
        pushRecordDO.setPushId(pushId);
        pushRecordDO.setAppId(appInfo.getId().toString());
        pushRecordDO.setAppName(appInfo.getAppName());
        pushRecordDO.setSecretKey(appInfo.getSecretKey());
        pushRecordDO.setTitle(pushApp.getMessage().getTitle());
        pushRecordDO.setContent(pushApp.getMessage().getContent());
        pushRecordDO.setAssistInfo(JSON.toJSONString((Object)pushApp.getMessage()));
        pushRecordDO.setPlatform(pushApp.getPlatform());
        pushRecordDO.setSendTime(sendTime);
        pushRecordDO.setCreateTime(nowTime);
        pushRecordDO.setDataStatus(Integer.valueOf(1));
        pushRecordDO.setModifyTime(nowTime);
        pushRecordDO.setAudienceType(pushApp.getAudienceType());
        pushRecordDO.setMessageType(pushApp.getMessageType());
        pushRecordDO.setTagRule(pushApp.getTagRule() == null ? "" : JSON.toJSONString((Object)pushApp.getTagRule()));
        pushRecordDO.setTokenList(pushApp.getTokenList() == null ? "" : JSON.toJSONString((Object)pushApp.getTokenList()));
        pushRecordDO.setEnvironment(pushApp.getEnvironment());
        this.mongoTemplate.save((Object)pushRecordDO);
        return ApiResponse.success((Object)true);
    }

    private void convertAndSend(ProducerConfiguration producerConfiguration) {
        int maxSize = 1000;
        if (producerConfiguration.getTokenSet().size() > maxSize) {
            Set set = producerConfiguration.getTokenSet();
            producerConfiguration.setTokenSet(set.stream().limit(maxSize).collect(Collectors.toSet()));
            this.rabbitTemplate.convertAndSend("messageDirectExchange", "messageRoutingKey", (Object)JSON.toJSONString((Object)producerConfiguration));
            producerConfiguration.setTokenSet(set.stream().skip(maxSize).collect(Collectors.toSet()));
            this.convertAndSend(producerConfiguration);
        } else {
            this.rabbitTemplate.convertAndSend("messageDirectExchange", "messageRoutingKey", (Object)JSON.toJSONString((Object)producerConfiguration));
        }
    }

    private void convertAndSendByProToken(List<ProducerConfiguration> list, List<DeviceToken> tokens, PushApp pushApp, String pushId) {
        ProTypeEnum[] proTypeEnums = ProTypeEnum.values();
        list.forEach(i -> {
            Set set = tokens.stream().filter(j -> proTypeEnums[Integer.parseInt(i.getProType())].ordinal() == j.getProType().intValue()).map(DeviceToken::getProToken).collect(Collectors.toSet());
            if (HussarUtils.isNotEmpty(set)) {
                i.setTokenSet(set);
                i.setEnvironment(pushApp.getEnvironment());
                i.setMessage(pushApp.getMessage());
                i.setMessageType(pushApp.getMessageType());
                i.setPushId(pushId);
                this.convertAndSend((ProducerConfiguration)i);
            }
        });
    }

    private void convertAndSendByToken(List<ProducerConfiguration> list, PushApp pushApp, String pushId) {
        ProTypeEnum[] proTypeEnums = ProTypeEnum.values();
        List tokens = pushApp.getTokenList().stream().limit(1000L).collect(Collectors.toList());
        list.forEach(i -> {
            Set set = tokens.stream().filter(j -> proTypeEnums[Integer.parseInt(i.getProType())].decodeToken(j).contains(proTypeEnums[Integer.parseInt(i.getProType())].tokenRule())).map(j -> proTypeEnums[Integer.parseInt(i.getProType())].decodeToken(j).replace(proTypeEnums[Integer.parseInt(i.getProType())].tokenRule(), "")).collect(Collectors.toSet());
            if (HussarUtils.isNotEmpty(set)) {
                i.setTokenSet(set);
                i.setEnvironment(pushApp.getEnvironment());
                i.setMessage(pushApp.getMessage());
                i.setMessageType(pushApp.getMessageType());
                i.setPushId(pushId);
                this.rabbitTemplate.convertAndSend("messageDirectExchange", "messageRoutingKey", (Object)JSON.toJSONString((Object)i));
            }
        });
    }

    private List<DeviceToken> dealTagToken(PushApp pushApp) {
        List<DeviceToken> list = new ArrayList<DeviceToken>();
        List conditions = pushApp.getTagRule().getConditions();
        for (int i = 0; i < conditions.size(); ++i) {
            List<DeviceToken> deviceTokens;
            QueryWrapper queryWrapper = new QueryWrapper();
            TagRule.Condition condition = (TagRule.Condition)conditions.get(i);
            if (condition.getOptType().intValue() == TagRule.OptType.and.ordinal()) {
                StringBuilder stringBuilder = new StringBuilder();
                ArrayList<String> params = new ArrayList<String>();
                for (int j = 0; j < condition.getTags().size(); ++j) {
                    stringBuilder.append("INSTR(GROUP_CONCAT(t2.TAG),{");
                    stringBuilder.append(j);
                    stringBuilder.append("}) > 0");
                    if (j != condition.getTags().size() - 1) {
                        stringBuilder.append(" AND ");
                    }
                    params.add(StringUtil.replaceSpecialChar((String)condition.getTags().get(j)));
                }
                ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"t2.TAG_CODE", (Object)((TagRule.Condition)conditions.get(i)).getTagCode())).groupBy((Object)"t2.TOKEN")).groupBy((Object)"t1.PRODUCE_TYPE")).groupBy((Object)"t1.PRODUCE_TOKEN")).having(stringBuilder.toString(), params.toArray());
            }
            if (condition.getOptType().intValue() == TagRule.OptType.or.ordinal()) {
                queryWrapper.in((Object)"TAG", (Collection)condition.getTags());
            }
            if (condition.getOptType().intValue() == TagRule.OptType.not.ordinal()) {
                queryWrapper.notIn((Object)"TAG", (Collection)condition.getTags());
            }
            if (HussarUtils.isEmpty(deviceTokens = this.tokenMapper.listTokenByWrapper(queryWrapper))) {
                return new ArrayList<DeviceToken>();
            }
            if (i == 0) {
                list.addAll(deviceTokens);
                continue;
            }
            list = this.dealTagRule(list, deviceTokens);
        }
        return list;
    }

    private List<DeviceToken> dealTagRule(List<DeviceToken> list, List<DeviceToken> deviceTokens) {
        return list.stream().filter(deviceTokens::contains).collect(Collectors.toList());
    }

    private ApiResponse<Boolean> checkPushApp(PushApp pushApp) {
        if (pushApp.getEnvironment() == null) {
            pushApp.setEnvironment(Integer.valueOf(0));
        }
        if (pushApp.getMessage() == null) {
            return ApiResponse.fail((int)CodeEnum.MISSING_PARAMETER.getCode(), (String)CodeEnum.MISSING_PARAMETER.getName());
        }
        if (pushApp.getAudienceType() == null) {
            return ApiResponse.fail((int)CodeEnum.MISSING_PARAMETER.getCode(), (String)CodeEnum.MISSING_PARAMETER.getName());
        }
        if (pushApp.getAudienceType() == 1) {
            if (HussarUtils.isEmpty((Object)pushApp.getTokenList()) || pushApp.getTokenList().size() == 0) {
                return ApiResponse.fail((int)CodeEnum.MISSING_PARAMETER.getCode(), (String)CodeEnum.MISSING_PARAMETER.getName());
            }
            if (pushApp.getTokenList().size() > 1000) {
                return ApiResponse.fail((int)CodeEnum.PARAMTER_PARSE_ERROR.getCode(), (String)"token\u6570\u8d85\u51fa1000\uff01");
            }
        }
        if (pushApp.getAudienceType() == 2) {
            if (pushApp.getTagRule() == null || pushApp.getTagRule().getConditions().size() == 0) {
                return ApiResponse.fail((int)CodeEnum.MISSING_PARAMETER.getCode(), (String)CodeEnum.MISSING_PARAMETER.getName());
            }
            List conditions = pushApp.getTagRule().getConditions();
            if (HussarUtils.isEmpty((Object)conditions)) {
                return ApiResponse.fail((int)CodeEnum.MISSING_PARAMETER.getCode(), (String)CodeEnum.MISSING_PARAMETER.getName());
            }
            int count = 0;
            for (TagRule.Condition condition : conditions) {
                if (HussarUtils.isEmpty((Object)condition.getTags())) {
                    return ApiResponse.fail((int)CodeEnum.MISSING_PARAMETER.getCode(), (String)CodeEnum.MISSING_PARAMETER.getName());
                }
                if ((count += condition.getTags().size()) <= 20) continue;
                return ApiResponse.fail((int)CodeEnum.MISSING_PARAMETER.getCode(), (String)"\u6807\u7b7e\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc720\u4e2a");
            }
        }
        return ApiResponse.success((Object)true);
    }
}

